/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn.detail;

import java.util.Calendar;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ru.bitel.bgbilling.kernel.network.datalog.FlowReader;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLog;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.reports.AbstractJRDataSource;

public class FlowJRDataSource
extends AbstractJRDataSource<AbstractJRDataSource.JRDataSourceField<Data, Object>, Data>
implements JRRewindableDataSource {
    private final Iterable<IPHourlyDataLog> logsIterable;
    private Iterator<IPHourlyDataLog> logs;
    public IPHourlyDataLog log;
    private FlowReader reader;
    private FlowArray<? extends Data> flowArray;
    private int position;

    public FlowJRDataSource(Iterable<IPHourlyDataLog> logsIterable) {
        this.logsIterable = logsIterable;
        try {
            this.moveFirst();
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void moveFirst() throws JRException {
        this.logs = this.logsIterable.iterator();
        this.position = -1;
        this.flowArray = null;
        this.reader = null;
        while (this.logs.hasNext()) {
            this.log = this.logs.next();
            while ((this.reader = (FlowReader)this.log.nextReader(null, false)) != null) {
                this.flowArray = this.reader.readChunk();
                if (this.flowArray == null) continue;
            }
        }
        if (this.flowArray == null) {
            this.flowArray = new FlowArray(new Data[0]);
        }
        if (this.reader == null) {
            this.reader = new FlowReader(){

                public FlowArray<? extends Data> readChunk() {
                    return null;
                }
            };
        }
    }

    public boolean next() throws JRException {
        if (++this.position < this.flowArray.size) {
            this.current = this.flowArray.array[this.position];
            return true;
        }
        this.position = 0;
        while ((this.flowArray = this.reader.readChunk()) != null) {
            if (this.position >= this.flowArray.size) continue;
            this.current = this.flowArray.array[this.position];
            return true;
        }
        while ((this.reader = (FlowReader)this.log.nextReader(null, false)) != null) {
            while ((this.flowArray = this.reader.readChunk()) != null) {
                if (this.position >= this.flowArray.size) continue;
                this.current = this.flowArray.array[this.position];
                return true;
            }
        }
        while (this.logs.hasNext()) {
            this.log = this.logs.next();
            while ((this.reader = (FlowReader)this.log.nextReader(null, false)) != null) {
                while ((this.flowArray = this.reader.readChunk()) != null) {
                    if (this.position >= this.flowArray.size) continue;
                    this.current = this.flowArray.array[this.position];
                    return true;
                }
            }
        }
        return false;
    }

    protected AbstractJRDataSource.JRDataSourceField<Data, Object> newField(JRField jrField) {
        String name = jrField.getName();
        if ("srcAddress".equals(name)) {
            return new AbstractJRDataSource.JRDataSourceField<Data, Object>(){

                public Long getValue(Data val) throws JRException {
                    return val.getSrcAddress();
                }
            };
        }
        if ("dstAddress".equals(name)) {
            return new AbstractJRDataSource.JRDataSourceField<Data, Object>(){

                public Long getValue(Data val) throws JRException {
                    return val.getDstAddress();
                }
            };
        }
        if ("inputInterface".equals(name)) {
            return new AbstractJRDataSource.JRDataSourceField<Data, Object>(){

                public Integer getValue(Data val) throws JRException {
                    return val.getInputInterface();
                }
            };
        }
        if ("outputInterface".equals(name)) {
            return new AbstractJRDataSource.JRDataSourceField<Data, Object>(){

                public Integer getValue(Data val) throws JRException {
                    return val.getOutputInterface();
                }
            };
        }
        if ("octets".equals(name)) {
            return new AbstractJRDataSource.JRDataSourceField<Data, Object>(){

                public Long getValue(Data val) throws JRException {
                    return val.getOctets();
                }
            };
        }
        if ("milliseconds".equals(name)) {
            return new AbstractJRDataSource.JRDataSourceField<Data, Object>(){

                public Long getValue(Data val) throws JRException {
                    return val.getMilliseconds();
                }
            };
        }
        if ("packets".equals(name)) {
            return new AbstractJRDataSource.JRDataSourceField<Data, Object>(){

                public Long getValue(Data val) throws JRException {
                    return val.getPackets();
                }
            };
        }
        if ("diffServ".equals(name)) {
            return new AbstractJRDataSource.JRDataSourceField<Data, Object>(){

                public Integer getValue(Data val) throws JRException {
                    return val.getDiffServ();
                }
            };
        }
        return new AbstractJRDataSource.JRDataSourceField<Data, Object>(){

            public Object getValue(Data val) throws JRException {
                return null;
            }
        };
    }

    public static Iterable<IPHourlyDataLog> newIPHourlyDataLogIterable(final DefaultServerSetup setup, final int sourceId, final Calendar hour1, final Calendar hour2) {
        return new Iterable<IPHourlyDataLog>(){

            @Override
            public Iterator<IPHourlyDataLog> iterator() {
                return new Iterator<IPHourlyDataLog>(){
                    private final Calendar hour;
                    private IPHourlyDataLog dataLog;
                    {
                        this.hour = (Calendar)hour1.clone();
                        this.dataLog = new IPHourlyDataLog((ParameterMap)setup, sourceId, this.hour);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.dataLog != null;
                    }

                    @Override
                    public IPHourlyDataLog next() {
                        IPHourlyDataLog current = this.dataLog;
                        this.hour.add(11, 1);
                        this.dataLog = TimeUtils.compare((Calendar)this.hour, (Calendar)hour2, (int)11) <= 0 ? new IPHourlyDataLog((ParameterMap)setup, sourceId, this.hour) : null;
                        return current;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

