/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import bitel.billing.server.ModuleBase;
import bitel.billing.server.admin.resource.bean.ip.IPResourceRange;
import bitel.billing.server.contract.object.bean.ModuleEntity;
import bitel.billing.server.load.bean.Source;
import bitel.billing.server.load.bean.SourceManager;
import bitel.billing.server.util.MonthForRecalc;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.MenuItem;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.CommonEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.kernel.event.events.system.GetErrorLogModulesEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ObjectMoveEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.ipn.common.bean.AddressRange;
import ru.bitel.bgbilling.modules.ipn.server.bean.AddressRangeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.GatePortManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.IPNContractStatusManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.IPNResourceManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.Iface;
import ru.bitel.bgbilling.modules.ipn.server.bean.IfaceManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.RangeIface;
import ru.bitel.bgbilling.modules.ipn.server.bean.RangeIfaceManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRule;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRuleManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class Module
extends ModuleBase {
    private static final String[] PACKAGES = new String[]{"bitel.billing.server.ipn", "ru.bitel.bgbilling.modules.ipn.server"};

    public void start(Connection con, BGModule module) throws BGException {
        super.start(con, module);
        GetErrorLogModulesEvent.addListener((BGModule)module);
    }

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void moduleAction(ServerContext ctx, int mid, Event event) throws Exception {
        super.moduleAction(ctx, mid, event);
        int cid = event.getContractId();
        if (event instanceof ContractDeleteEvent) {
            ContractDeleteEvent cdEvent = (ContractDeleteEvent)event;
            if (!cdEvent.isCheck()) {
                Connection con = ctx.getConnection();
                new IPNResourceManager(con, mid).freeResources(cid);
                String cidStr = String.valueOf(cid);
                List aids = ServerUtils.deleteRowsFromTable((Connection)con, (String)("ipn_user_range_" + mid), (String)"cid", (String)cidStr, (String)"id");
                for (String aid : aids) {
                    ServerUtils.deleteRowsFromTable((Connection)con, (String)("ipn_user_source_" + mid), (String)"aid", (String)aid, null);
                }
                ServerUtils.deleteRowsFromTable((Connection)con, (String)("ipn_user_gate_" + mid), (String)"cid", (String)cidStr, null);
                ServerUtils.deleteRowsFromTable((Connection)con, (String)("ipn_contract_status_" + mid), (String)"cid", (String)cidStr, null);
                ServerUtils.deleteRowsFromTable((Connection)con, (String)("ipn_contract_status_log_" + mid), (String)"cid", (String)cidStr, null);
                ServerUtils.deleteRowsFromTable((Connection)con, (String)("ipn_gate_vlan_" + mid), (String)"cid", (String)cidStr, null);
                ServerUtils.deleteRowsFromTable((Connection)con, (String)("ipn_gate_contract_port_" + mid), (String)"cid", (String)cidStr, null);
            }
        } else if (event instanceof ContractCloseEvent) {
            ContractCloseEvent cEvent = (ContractCloseEvent)event;
            Connection con = ctx.getConnection();
            if (cEvent.isCheck()) {
                AddressRangeManager rm = new AddressRangeManager(con, mid);
                for (AddressRange r : rm.getContractAddressRange(cid)) {
                    if (r.getDate2() == null || !TimeUtils.dateBefore((java.util.Date)cEvent.getDate(), (java.util.Date)TimeUtils.convertCalendarToDate((Calendar)r.getDate2()))) continue;
                    cEvent.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435, \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432 " + r.toStringWithoutSource() + " \u0437\u0430\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u0437\u0436\u0435 \u0434\u0430\u0442\u044b \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f.");
                    return;
                }
            } else {
                Date sqlDate = TimeUtils.convertDateToSqlDate((java.util.Date)cEvent.getDate());
                String query = "UPDATE ipn_user_range_" + mid + " SET date2=? WHERE cid=? AND date2 IS NULL";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setDate(1, sqlDate);
                ps.setInt(2, cid);
                ps.executeUpdate();
                ps.close();
                new IPNResourceManager(con, mid).closeResourceUse(cid, cEvent.getDate());
            }
        } else if (event instanceof ContractWrapEvent) {
            ContractWrapEvent cwEvent = (ContractWrapEvent)event;
            Connection con = ctx.getConnection();
            if (cwEvent.isCheck()) {
                AddressRangeManager rm = new AddressRangeManager(con, mid);
                for (AddressRange r : rm.getContractAddressRange(cid)) {
                    if (r.getDate1() != null) continue;
                    cwEvent.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435, \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432 " + r.toStringWithoutSource() + " \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0434\u0430\u0442\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f.");
                    return;
                }
            } else {
                MonthForRecalc months = new MonthForRecalc();
                AddressRangeManager rm = new AddressRangeManager(con, mid);
                for (AddressRange r : rm.getContractAddressRange(cid)) {
                    Integer objectId = (Integer)cwEvent.getObjectMap().get(r.getObjectId());
                    if (objectId == null) {
                        objectId = 0;
                    }
                    rm.wrapRange(r, cwEvent.getToContractId(), objectId, cwEvent.getDateClose(), cwEvent.getDateOpen(), 0);
                }
                Calendar date = TimeUtils.convertDateToCalendar((java.util.Date)cwEvent.getDateClose());
                date.set(5, 1);
                date.set(11, 0);
                TimeUtils.clear_MIN_MIL_SEC((Calendar)date);
                GregorianCalendar now = new GregorianCalendar();
                months.addPeriod((Calendar)date.clone(), (Calendar)now);
                UserGateRuleManager gm = new UserGateRuleManager(con, mid);
                for (UserGateRule rule : gm.getUserGateRules(cid)) {
                    rule.setId(-1);
                    rule.setContractId(cwEvent.getToContractId());
                    gm.updateUserGateRule("new", rule);
                    int gid = rule.getGateId();
                    GatePortManager gpm = new GatePortManager(con, mid);
                    List<Integer> ports = gpm.getGatePorts(cid, gid);
                    gpm.updateGatePorts(cwEvent.getToContractId(), gid, ports);
                }
                rm.recalcAfterMove(months, cwEvent.getContractId(), cwEvent.getToContractId());
            }
        } else if (event instanceof ObjectMoveEvent) {
            Connection con = ctx.getConnection();
            String tableName = " ipn_user_range_" + mid;
            String query = "UPDATE " + tableName + " SET object_id=0 WHERE object_id=?";
            PreparedStatement psUpdate = con.prepareStatement(query);
            psUpdate.setInt(1, ((ObjectMoveEvent)event).getObjectId());
            psUpdate.executeUpdate();
            psUpdate.close();
        } else if (event instanceof ContractCreateEvent) {
            Element addressrange;
            ContractCreateEvent ccEvent = (ContractCreateEvent)event;
            Connection con = ctx.getConnection();
            Document dataDoc = ccEvent.getPattern().getData();
            if (dataDoc != null && (addressrange = XMLUtils.selectElement((Node)dataDoc, (String)("data/modules/ipn[@mid=" + mid + "]/addressrange"))) != null) {
                Calendar date = TimeUtils.convertDateToCalendar((java.util.Date)ccEvent.getDateFrom());
                NodeList nodes = addressrange.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element addAddressRange;
                    boolean todo;
                    Node n = nodes.item(i);
                    if (!"addAddressRange".equals(n.getNodeName()) || !(todo = Utils.parseBoolean((String)(addAddressRange = (Element)n).getAttribute("do")))) continue;
                    long mask = Utils.parseLong((String)addAddressRange.getAttribute("mask"));
                    int categoryId = Utils.parseInt((String)addAddressRange.getAttribute("category_id"));
                    Iterable<IPResourceRange> ranges = new IPNResourceManager(con, mid).getFreeResourceIterator(categoryId, new GregorianCalendar());
                    AddressRange contractRange = null;
                    IPResourceRange range2 = null;
                    for (IPResourceRange range2 : ranges) {
                        IPUtils.Netv4 net = IPUtils.subnet((long)range2.getIp1(), (long)range2.getIp2(), (short)((short)mask));
                        if (net == null) continue;
                        int port1 = Utils.parseInt((String)addAddressRange.getAttribute("port1"));
                        int port2 = Utils.parseInt((String)addAddressRange.getAttribute("port2"));
                        String sources = addAddressRange.getAttribute("source_id");
                        int resourceId = range2.getId();
                        contractRange = new AddressRange();
                        contractRange.setAddr1(net.hostMin);
                        contractRange.setAddr2(net.hostMax);
                        contractRange.setContractId(cid);
                        contractRange.setDate1(date);
                        contractRange.setMask((int)mask);
                        contractRange.setPort1(port1);
                        contractRange.setPort2(port2);
                        contractRange.setResourceId(resourceId);
                        contractRange.setSources(sources);
                        contractRange.setComment("");
                        HashSet<Integer> zones = new HashSet<Integer>();
                        List<RangeIface> ifaceList = null;
                        try {
                            ifaceList = this.getIfaces(con, contractRange, sources, mid);
                        }
                        catch (BGException ex) {
                            ccEvent.setError("\u041c\u043e\u0434\u0443\u043b\u044c IPN (mid=" + mid + "): " + ex.getMessage());
                            return;
                        }
                        for (RangeIface rangeIface : ifaceList) {
                            zones.add(rangeIface.getIface().getZoneId());
                        }
                        if (ifaceList.size() > 1 && zones.size() > 1) {
                            ccEvent.setError("\u041c\u043e\u0434\u0443\u043b\u044c IPN (mid=" + mid + "): \u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u043e\u043d \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u043e\u0432");
                            return;
                        }
                        if (!ccEvent.isCheck()) {
                            AddressRangeManager arm = new AddressRangeManager(con, mid);
                            arm.updateAddressRangeInfo("new", contractRange);
                            RangeIfaceManager rangeIfaceManager = new RangeIfaceManager(con, mid);
                            rangeIfaceManager.updateAddressRangeIfaces(contractRange.getId(), ifaceList);
                        }
                        return;
                    }
                    if (addressrange != null) continue;
                    ccEvent.setError("\u041c\u043e\u0434\u0443\u043b\u044c IPN (mid=" + mid + "):  \u041d\u0435\u0442 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u043e\u0433\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430!");
                }
            }
        } else if (event instanceof CommonEvent) {
            AddressRangeManager man;
            AddressRange range;
            CommonEvent commonEvent = (CommonEvent)event;
            Connection con = ctx.getConnection();
            Integer cmid = (Integer)commonEvent.getParameter("mid");
            boolean flag = commonEvent.getParameter("ipDeleted") != null;
            Integer rangeId = (Integer)commonEvent.getParameter("rangeId");
            if (cmid != null && cmid == mid && flag && rangeId != null && (range = (man = new AddressRangeManager(con, mid)).getAddressRange(rangeId)) != null) {
                commonEvent.setParameter("deleteRejected", (Object)true);
            }
        }
    }

    private List<RangeIface> getIfaces(Connection con, AddressRange ar, String ifaces, int mid) throws BGException {
        AddressRangeManager manager = new AddressRangeManager(con, mid);
        IfaceManager ifaceManager = new IfaceManager(con, mid);
        SourceManager sourceManager = new SourceManager(con);
        ArrayList<RangeIface> ifaceList = new ArrayList<RangeIface>();
        HashSet<Integer> checkedZones = new HashSet<Integer>();
        StringTokenizer st = new StringTokenizer(ifaces, ",");
        while (st.hasMoreTokens()) {
            String[] source_iface = st.nextToken().trim().split("_");
            RangeIface rangeIface = new RangeIface();
            rangeIface.setRangeId(0);
            rangeIface.setSourceId(Utils.parseInt((String)source_iface[0], (int)0));
            rangeIface.setIfaceId(Utils.parseInt((String)source_iface[1], (int)0));
            ifaceList.add(rangeIface);
            Iface iface = ifaceManager.getIface(rangeIface.getSourceId(), rangeIface.getIfaceId());
            rangeIface.setIface(iface);
            int zoneId = iface.getZoneId();
            if (zoneId == -1 || checkedZones.contains(zoneId)) continue;
            String checkResult = manager.checkAddress("new", ar, zoneId, rangeIface.getSourceId(), rangeIface.getIfaceId());
            if (checkResult.length() != 0) {
                String msg = "\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c\u0438: " + checkResult;
                Source source = sourceManager.getSource(rangeIface.getSourceId());
                if (source != null) {
                    msg = msg + " \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a " + source.getTitle() + " \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 " + iface.getTitle();
                }
                throw new BGException(msg);
            }
            checkedZones.add(zoneId);
        }
        return ifaceList;
    }

    public void serializeContract(Connection con, int cid, int mid, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
        String cidStr = String.valueOf(cid);
        List aids = ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("ipn_user_range_" + mid), (String)"cid", (String)cidStr, (String)"id", (boolean)onlyCurrent, (String)"date1", (String)"date2");
        for (String aid : aids) {
            ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("ipn_user_source_" + mid), (String)"aid", (String)aid, null, (boolean)false, null, null);
        }
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("ipn_user_gate_" + mid), (String)"cid", (String)cidStr, null, (boolean)false, null, null);
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("ipn_contract_status_" + mid), (String)"cid", (String)cidStr, null, (boolean)false, null, null);
        if (!onlyCurrent) {
            ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("ipn_contract_status_log_" + mid), (String)"cid", (String)cidStr, null, (boolean)false, null, null);
        }
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("ipn_gate_vlan_" + mid), (String)"cid", (String)cidStr, null, (boolean)false, null, null);
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("ipn_gate_contract_port_" + mid), (String)"cid", (String)cidStr, null, (boolean)false, null, null);
    }

    public String getStatus(Connection con, int mid, int cid) throws BGException {
        return IPNContractStatusManager.statusToString(new IPNContractStatusManager(con, mid, (Preferences)new ModuleSetup(con, mid)).getContractStatus(cid));
    }

    public void unlockService(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        ModuleSetup setup = new ModuleSetup(con, mid);
        IPNContractStatusManager csm = new IPNContractStatusManager(con, mid, (Preferences)setup);
        if (csm.getContractStatus(contractRuntime.contractId) == 2) {
            int status = setup.getInt("status.after.unlock", 1);
            csm.changeStatus(contractRuntime.contractId, status, 0, true);
        }
    }

    public void unlockServiceNow(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        this.unlockService(con, mid, contractRuntime, balance, limit, lightweight);
    }

    public void lockService(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        IPNContractStatusManager csm = new IPNContractStatusManager(con, mid, (Preferences)new ModuleSetup(con, mid));
        int ipnStatus = csm.getContractStatus(contractRuntime.contractId);
        if (ipnStatus == 0 || ipnStatus == 1) {
            csm.changeStatus(contractRuntime.contractId, 2, 0, true);
        }
    }

    public List<ModuleEntity> getObjectEntities(Connection con, int mid, int objectId) throws BGException {
        ArrayList<ModuleEntity> result = new ArrayList<ModuleEntity>();
        for (AddressRange addressRange : new AddressRangeManager(con, mid).getObjectAddressRange(objectId)) {
            ModuleEntity entity = new ModuleEntity();
            entity.setName("\u0410\u0434\u0440\u0435\u0441\u0430");
            entity.setData(addressRange.toShortString());
            entity.setComment(addressRange.getComment());
            entity.setPeriod(TimeUtils.formatPeriod((Calendar)addressRange.getDate1(), (Calendar)addressRange.getDate2()));
            result.add(entity);
        }
        return result;
    }

    public List<MenuItem> getContractWebMenuItems(Connection con, String module, int moduleId, int contractId) throws BGException {
        HashSet<Integer> disableIds = new HashSet<Integer>();
        if (new GateManager(con, moduleId).getContractGates(contractId).size() == 0) {
            disableIds.add(2);
        }
        return this.disableContractWebMenuItems(this.getWebMenuItems(con, module, moduleId), disableIds);
    }
}

