/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.modules.ipn.server.bean.Gate;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.GatePortManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;

public class ActionGatePort
extends AbstractAction {
    public List<String> getGatePortMaps() throws Exception {
        GatePortManager man = new GatePortManager(this.con, this.moduleId);
        ArrayList<String> result = new ArrayList<String>();
        for (Map<String, Object> map : man.getGatePortMaps(this.contractId)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("gateId", map.get("gateId"));
            jsonObject.put("gateName", map.get("gateName"));
            jsonObject.put("ports", map.get("ports"));
            result.add(jsonObject.toString());
        }
        return result;
    }

    public MapHolder<String, Object> getGatePortMap() throws Exception {
        HashMap<String, Object> result = null;
        GatePortManager man = new GatePortManager(this.con, this.moduleId);
        Map<String, Object> m = man.getGatePortMap(this.contractId, this.req.getInt("gateId", 0));
        if (m != null) {
            result = new HashMap<String, Object>();
            result.putAll(m);
        }
        return new MapHolder(result);
    }

    public void updateGatePort() throws BGMessageException, BGException {
        int gateId = this.req.getInt("gateId", -1);
        int count = this.req.getInt("count", -1);
        if (gateId <= 0) {
            throw new BGMessageException("\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0448\u043b\u044e\u0437!");
        }
        Gate gate = new GateManager(this.con, this.moduleId).getGateById(gateId);
        Preferences gateSetup = new Preferences(gate.getConfig(), "\r\n");
        String range = gateSetup.get("port.range", "1-24");
        List rangeList = ServerUtils.getRanges((int)gateId, (String)range);
        if (rangeList.size() == 0) {
            throw new BGMessageException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0448\u043b\u044e\u0437\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u0434\u0438\u043f\u0430\u0437\u043e\u043d \u043f\u043e\u0440\u0442\u043e\u0432(\u043e\u043f\u0446\u0438\u044f port.range)");
        }
        GatePortManager man = new GatePortManager(this.con, this.moduleId);
        List<Object> ports = new ArrayList();
        if (count > 0) {
            ports = man.findFreePorts(this.contractId, gateId, count, rangeList);
            if (ports.size() == 0) {
                throw new BGMessageException("\u0412 \u0440\u0435\u0441\u0443\u0440\u0441\u0435 \u043d\u0435\u0442 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 \u043f\u043e\u0440\u0442\u043e\u0432 ");
            }
        } else {
            String portsStr = this.req.get("ports", "");
            HashSet<Integer> portSet = new HashSet<Integer>();
            if (!Utils.isEmptyString((String)portsStr)) {
                String[] parts;
                for (String part : parts = portsStr.split(",")) {
                    int port = Integer.valueOf(part);
                    if (portSet.contains(port)) {
                        throw new BGMessageException("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0432\u0432\u043e\u0434\u0438\u0442\u044c \u043e\u0434\u0438\u043d \u0438 \u0442\u043e\u0442 \u0436\u0435 \u043f\u043e\u0440\u0442 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0440\u0430\u0437");
                    }
                    ports.add(port);
                    portSet.add(port);
                    if (this.portInRange(port, rangeList)) continue;
                    throw new BGMessageException("\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0435 \u043f\u043e\u0440\u0442\u044b \u043d\u0435 \u043f\u043e\u043f\u0430\u0434\u0430\u044e\u0442 \u0432 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d:" + range);
                }
            }
            if (ports.size() == 0) {
                throw new BGMessageException("\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0432\u0432\u0435\u0441\u0442\u0438 \u0445\u043e\u0442\u044f \u0431\u044b \u043e\u0434\u0438\u043d \u043f\u043e\u0440\u0442 . \u0421\u0442\u0440\u043e\u043a\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u0430 :" + portsStr);
            }
        }
        if (man.portsExists(this.contractId, gateId, ports)) {
            throw new BGMessageException("\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0435 \u043f\u043e\u0440\u0442\u044b \u0443\u0436\u0435 \u0437\u0430\u043d\u044f\u0442\u044b \u043d\u0430 \u0434\u0430\u043d\u043d\u043e\u043c \u0448\u043b\u044e\u0437\u0435 ");
        }
        man.updateGatePorts(this.contractId, gateId, ports);
    }

    private boolean portInRange(int port, List<List<Integer>> rangeList) {
        boolean result = false;
        for (List<Integer> list : rangeList) {
            int min = list.get(0);
            int max = list.get(1);
            if (port < min || port > max) continue;
            result = true;
            break;
        }
        return result;
    }

    public List<String> getAvailableGates() throws BGException {
        GatePortManager man = new GatePortManager(this.con, this.moduleId);
        List<Gate> list = man.getAvailableGates(this.contractId);
        ArrayList<String> result = new ArrayList<String>();
        for (Gate gate : list) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("gid", gate.getId());
            jsonObject.put("gateName", (Object)gate.getTitle());
            result.add(jsonObject.toString());
        }
        return result;
    }

    public String getGate() {
        Gate gate = new GateManager(this.con, this.moduleId).getGateById(this.req.getInt("gateId", 0));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("gid", gate.getId());
        jsonObject.put("gateName", (Object)gate.getTitle());
        return jsonObject.toString();
    }

    public void deleteGatePort() throws BGException {
        new GatePortManager(this.con, this.moduleId).deleteGatePorts(this.contractId, this.req.getInt("gateId", 0));
    }

    public List<String> getPortMonitor() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        GatePortManager man = new GatePortManager(this.con, this.moduleId);
        List<Map<String, Object>> list = man.getPortMonitorMap(this.req.getInt("gateId", 0));
        for (Map<String, Object> map : list) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("port", map.get("port"));
            jsonObject.put("title", map.get("title"));
            result.add(jsonObject.toString());
        }
        return result;
    }
}

