/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.bean;

import bitel.billing.server.admin.bean.AddressHouse;
import bitel.billing.server.admin.bean.AddressItem;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.address.AddressCity;
import ru.bitel.bgbilling.kernel.directory.address.AddressCountry;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.entity.server.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.server.utils.AddressUtils;

public class AddressManager {
    public static final String TABLE_ADDRESS_COUNTRY = "address_country";
    public static final String TABLE_ADDRESS_CITY = "address_city";
    public static final String TABLE_ADDRESS_AREA = "address_area";
    public static final String TABLE_ADDRESS_QUARTER = "address_quarter";
    public static final String TABLE_ADDRESS_STREET = "address_street";
    public static final String TABLE_ADDRESS_HOUSE = "address_house";
    public static final String TABLE_ADDRESS_CONFIG = "address_config";
    private Connection con;
    private DefaultServerSetup setup;
    private Map<String, AddressCountry> countryMap = new HashMap<String, AddressCountry>();
    private Map<String, AddressCity> cityMap = new HashMap<String, AddressCity>();
    private Map<String, AddressItem> streetMap = new HashMap<String, AddressItem>();

    public AddressManager(Connection con, DefaultServerSetup setup) {
        this.con = con;
        this.setup = setup;
    }

    public AddressCountry getCountry(int countryId) {
        AddressCountry addressCountry = new AddressCountry();
        try {
            String sql = "SELECT * FROM address_country WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setInt(1, countryId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                addressCountry.setId(rs.getInt("id"));
                addressCountry.setTitle(rs.getString("title"));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return addressCountry;
    }

    public AddressCity getCity(int cityId) {
        AddressCity addressCity = new AddressCity();
        try {
            String sql = "SELECT * FROM address_city WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setInt(1, cityId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                addressCity.setId(rs.getInt("id"));
                addressCity.setTitle(rs.getString("title"));
                addressCity.setCountryId(rs.getInt("country_id"));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return addressCity;
    }

    public AddressItem getAddressItem(int itemId, String table) {
        AddressItem addressItem = new AddressItem();
        try {
            String sql = "SELECT * FROM " + table + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setInt(1, itemId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                addressItem.setId(rs.getInt("id"));
                addressItem.setTitle(rs.getString("title"));
                addressItem.setCityId(rs.getInt("cityid"));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return addressItem;
    }

    public AddressHouse getHouse(int houseId) {
        AddressHouse addressHouse = new AddressHouse();
        try {
            String sql = "SELECT * FROM address_house AS house LEFT JOIN address_street AS street ON house.streetId=street.id   WHERE house.id=?";
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setInt(1, houseId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                addressHouse.setId(rs.getInt("house.id"));
                addressHouse.setAreaId(rs.getInt("house.areaid"));
                addressHouse.setComment(rs.getString("house.comment"));
                addressHouse.setFrac(rs.getString("house.frac"));
                addressHouse.setQuarterId(rs.getInt("house.quarterid"));
                addressHouse.setStreetId(rs.getInt("house.streetid"));
                addressHouse.setHouse(rs.getInt("house.house"));
                addressHouse.setCityId(rs.getInt("street.cityId"));
                addressHouse.setAmount(rs.getInt("house.amount"));
                addressHouse.setDate(TimeUtils.convertSqlDateToDate((Date)rs.getDate("house.dt")));
                addressHouse.setBoxIndex(rs.getString("house.box_index"));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return addressHouse;
    }

    public Map<String, String> getAddressParams(String tableId, int recordId) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String sql = "SELECT * FROM address_config WHERE table_id=? AND record_id=?";
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setString(1, tableId);
            ps.setInt(2, recordId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                map.put(rs.getString("key"), rs.getString("value"));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public String getAddressParam(String tableId, int recordId, String key) {
        String result = null;
        try {
            String sql = "SELECT * FROM address_config WHERE table_id=? AND record_id=? AND address_config.key=?";
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setString(1, tableId);
            ps.setInt(2, recordId);
            ps.setString(3, key);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = rs.getString("value");
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateAddressParams(String tableId, int recordId, String key, String value) {
        try {
            String sql = null;
            sql = "DELETE FROM address_config WHERE table_id=? AND record_id=? AND address_config.key=? ";
            PreparedStatement psDelete = this.con.prepareStatement(sql);
            psDelete.setString(1, tableId);
            psDelete.setInt(2, recordId);
            psDelete.setString(3, key);
            psDelete.executeUpdate();
            psDelete.close();
            sql = "INSERT INTO address_config SET table_id=?, value=?, record_id=?, address_config.key=?";
            PreparedStatement psUpdate = this.con.prepareStatement(sql);
            psUpdate.setString(1, tableId);
            psUpdate.setString(2, value);
            psUpdate.setInt(3, recordId);
            psUpdate.setString(4, key);
            psUpdate.executeUpdate();
            psUpdate.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteAddressParams(String tableId, int recordId) {
        try {
            String sql = null;
            ArrayList<Integer> streetIdList = new ArrayList<Integer>();
            ArrayList<Integer> areaIdList = new ArrayList<Integer>();
            ArrayList<Integer> quarterIdList = new ArrayList<Integer>();
            if (tableId.equals(TABLE_ADDRESS_CITY)) {
                sql = "SELECT * FROM address_street WHERE cityid=?";
                PreparedStatement streetPS = this.con.prepareStatement(sql);
                streetPS.setInt(1, recordId);
                ResultSet rs = streetPS.executeQuery();
                while (rs.next()) {
                    streetIdList.add(rs.getInt("id"));
                }
                sql = "SELECT * FROM address_area WHERE cityid=?";
                PreparedStatement areaPS = this.con.prepareStatement(sql);
                areaPS.setInt(1, recordId);
                rs = areaPS.executeQuery();
                while (rs.next()) {
                    areaIdList.add(rs.getInt("id"));
                }
                sql = "SELECT * FROM address_quarter WHERE cityid=?";
                PreparedStatement quarterPS = this.con.prepareStatement(sql);
                quarterPS.setInt(1, recordId);
                rs = quarterPS.executeQuery();
                while (rs.next()) {
                    quarterIdList.add(rs.getInt("id"));
                }
                rs.close();
                streetPS.close();
                areaPS.close();
                quarterPS.close();
                if (areaIdList.size() > 0) {
                    this.deleteExctraAddressParams(TABLE_ADDRESS_AREA, Utils.toString(areaIdList, (int)0), null);
                }
                if (streetIdList.size() > 0) {
                    this.deleteExctraAddressParams(TABLE_ADDRESS_STREET, Utils.toString(streetIdList, (int)0), null);
                }
                if (quarterIdList.size() > 0) {
                    this.deleteExctraAddressParams(TABLE_ADDRESS_QUARTER, Utils.toString(quarterIdList, (int)0), null);
                }
            }
            this.deleteExctraAddressParams(tableId, String.valueOf(recordId), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteExctraAddressParams(String tableId, String recordId, String key) {
        try {
            String sql = null;
            sql = key == null ? "DELETE FROM address_config WHERE table_id=? AND record_id IN (" + recordId + ")" : "DELETE FROM address_config WHERE table_id=? AND address_config.key=? AND record_id IN (" + recordId + ")";
            PreparedStatement psDelete = this.con.prepareStatement(sql);
            psDelete.setString(1, tableId);
            if (key != null) {
                psDelete.setString(2, key);
            }
            psDelete.executeUpdate();
            psDelete.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void searchCountryList(SearchResult<AddressCountry> searchResult, String countryMask) {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List list = searchResult.getList();
            try {
                int index = 1;
                ResultSet rs = null;
                PreparedStatement ps = null;
                StringBuilder query = new StringBuilder();
                query.append("SELECT SQL_CALC_FOUND_ROWS * FROM ");
                query.append(TABLE_ADDRESS_COUNTRY);
                query.append(" AS country ");
                query.append(" WHERE true");
                if (countryMask != null && !countryMask.isEmpty()) {
                    query.append(" AND country.title LIKE ?");
                }
                query.append(" ORDER BY country.title");
                if (page != null) {
                    query.append(page.sqlLimit());
                }
                ps = this.con.prepareStatement(query.toString());
                if (countryMask != null && !countryMask.isEmpty()) {
                    ps.setString(index++, countryMask);
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(this.getAddressCountryData(rs, "country."));
                }
                rs.close();
                page.setRecordCount(ServerUtils.foundRows(this.con));
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void searchCityList(SearchResult<AddressCity> searchResult, int countryId, String cityMask, boolean loadCountryInfo) {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List list = searchResult.getList();
            try {
                int index = 1;
                ResultSet rs = null;
                PreparedStatement ps = null;
                StringBuilder query = new StringBuilder();
                query.append("SELECT SQL_CALC_FOUND_ROWS * FROM ");
                query.append(TABLE_ADDRESS_CITY);
                query.append(" AS city ");
                if (loadCountryInfo) {
                    query.append(" LEFT JOIN ");
                    query.append(TABLE_ADDRESS_COUNTRY);
                    query.append(" AS country ON city.country_id=country.id");
                }
                query.append(" WHERE true");
                if (countryId > 0) {
                    query.append(" AND city.country_id=");
                    query.append(countryId);
                }
                if (cityMask != null && !cityMask.isEmpty()) {
                    query.append(" AND city.title LIKE ?");
                }
                query.append(" ORDER BY city.title");
                if (page != null) {
                    query.append(page.sqlLimit());
                }
                ps = this.con.prepareStatement(query.toString());
                if (cityMask != null && !cityMask.isEmpty()) {
                    ps.setString(index++, cityMask);
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    AddressCity addressCity = this.getAddressCityData(rs, "city.");
                    if (loadCountryInfo) {
                        addressCity.setAddressCountry(this.getAddressCountryData(rs, "country."));
                    }
                    list.add(addressCity);
                }
                rs.close();
                page.setRecordCount(ServerUtils.foundRows(this.con));
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void searchAreaList(SearchResult<AddressItem> searchResult, int cityId, String areaMask, boolean loadCountryInfo, boolean loadCityInfo) {
        this.searchItemList(searchResult, TABLE_ADDRESS_AREA, cityId, areaMask, loadCountryInfo, loadCityInfo);
    }

    public void searchQuarterList(SearchResult<AddressItem> searchResult, int cityId, String areaMask, boolean loadCountryInfo, boolean loadCityInfo) {
        this.searchItemList(searchResult, TABLE_ADDRESS_QUARTER, cityId, areaMask, loadCountryInfo, loadCityInfo);
    }

    public void searchStreetList(SearchResult<AddressItem> searchResult, int cityId, String areaMask, boolean loadCountryInfo, boolean loadCityInfo) {
        this.searchItemList(searchResult, TABLE_ADDRESS_STREET, cityId, areaMask, loadCountryInfo, loadCityInfo);
    }

    private void searchItemList(SearchResult<AddressItem> searchResult, String tableName, int cityId, String itemMask, boolean loadCountryInfo, boolean loadCityInfo) {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List list = searchResult.getList();
            try {
                int index = 1;
                ResultSet rs = null;
                PreparedStatement ps = null;
                StringBuilder query = new StringBuilder();
                query.append("SELECT SQL_CALC_FOUND_ROWS * FROM ");
                query.append(tableName);
                query.append(" AS item ");
                if (loadCityInfo) {
                    query.append(" LEFT JOIN ");
                    query.append(TABLE_ADDRESS_CITY);
                    query.append(" AS city ON item.cityid=city.id");
                    if (loadCountryInfo) {
                        query.append(" LEFT JOIN ");
                        query.append(TABLE_ADDRESS_COUNTRY);
                        query.append(" AS country ON city.country_id=country.id");
                    }
                }
                query.append(" WHERE true");
                if (cityId > 0) {
                    query.append(" AND item.cityid=");
                    query.append(cityId);
                }
                if (itemMask != null && !itemMask.isEmpty()) {
                    query.append(" AND item.title LIKE ?");
                }
                query.append(" ORDER BY item.title");
                if (page != null) {
                    query.append(page.sqlLimit());
                }
                ps = this.con.prepareStatement(query.toString());
                if (itemMask != null && !itemMask.isEmpty()) {
                    ps.setString(index++, itemMask);
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    AddressItem addressItem = this.getAddressItemData(rs, "item.");
                    if (addressItem == null) continue;
                    if (loadCityInfo) {
                        AddressCity addressCity = this.getAddressCityData(rs, "city.");
                        addressItem.setAddressCity(addressCity);
                        if (loadCountryInfo) {
                            addressCity.setAddressCountry(this.getAddressCountryData(rs, "country."));
                        }
                    }
                    list.add(addressItem);
                }
                rs.close();
                page.setRecordCount(ServerUtils.foundRows(this.con));
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void searchHouseList(SearchResult<AddressHouse> searchResult, int areaId, int quarterId, int streetId, String houseFrac, boolean loadInfo, boolean loadCityInfo, boolean loadCountryInfo) {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List list = searchResult.getList();
            try {
                String frac;
                int house;
                int index = 1;
                ResultSet rs = null;
                PreparedStatement ps = null;
                StringBuilder query = new StringBuilder();
                query.append("SELECT SQL_CALC_FOUND_ROWS * FROM ");
                query.append(TABLE_ADDRESS_HOUSE);
                query.append(" AS house ");
                if (loadInfo) {
                    query.append(" LEFT JOIN ");
                    query.append(TABLE_ADDRESS_AREA);
                    query.append(" AS area ON area.id=house.areaid");
                    query.append(" LEFT JOIN ");
                    query.append(TABLE_ADDRESS_QUARTER);
                    query.append(" AS quarter ON quarter.id=house.quarterid");
                    query.append(" LEFT JOIN ");
                    query.append(TABLE_ADDRESS_STREET);
                    query.append(" AS street ON street.id=house.streetid");
                }
                query.append(" WHERE true");
                if (areaId > 0) {
                    query.append(" AND house.areaid=");
                    query.append(areaId);
                }
                if (quarterId > 0) {
                    query.append(" AND house.quarterid=");
                    query.append(quarterId);
                }
                if (streetId > 0) {
                    query.append(" AND house.streetid=");
                    query.append(streetId);
                }
                if ((house = Utils.parseInt((String)AddressUtils.getHouse(houseFrac), (int)-1)) > -1) {
                    query.append(" AND house.house=");
                    query.append(house);
                }
                if (!(frac = AddressUtils.getHouseFrac(houseFrac)).isEmpty()) {
                    query.append(" AND house.frac LIKE ?");
                }
                query.append(" ORDER BY house.house, house.frac");
                if (page != null) {
                    query.append(page.sqlLimit());
                }
                ps = this.con.prepareStatement(query.toString());
                if (!frac.isEmpty()) {
                    ps.setString(index++, frac);
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    AddressHouse addressHouse = this.getAddressHouseData(rs, "house.");
                    if (addressHouse == null) continue;
                    if (loadInfo) {
                        addressHouse.setAddressArea(this.getAddressItemData(rs, "area."));
                        addressHouse.setAddressQuarter(this.getAddressItemData(rs, "quarter."));
                        addressHouse.setAddressStreet(this.getAddressItemData(rs, "street."));
                    }
                    list.add(addressHouse);
                }
                rs.close();
                page.setRecordCount(ServerUtils.foundRows(this.con));
                ps.close();
                if (loadCityInfo) {
                    StringBuilder cityIds = new StringBuilder();
                    for (AddressHouse addressHouse : list) {
                        AddressItem addressItem = addressHouse.getAddressStreet();
                        if (addressItem != null) {
                            cityIds.append(", ");
                            cityIds.append(addressItem.getCityId());
                            continue;
                        }
                        addressItem = addressHouse.getAddressQuarter();
                        if (addressItem != null) {
                            cityIds.append(", ");
                            cityIds.append(addressItem.getCityId());
                            continue;
                        }
                        addressItem = addressHouse.getAddressArea();
                        if (addressItem == null) continue;
                        cityIds.append(", ");
                        cityIds.append(addressItem.getCityId());
                    }
                    if (cityIds.length() > 0) {
                        HashMap<Integer, AddressCity> addressCityMap = new HashMap<Integer, AddressCity>();
                        query = new StringBuilder();
                        query.append("SELECT * FROM ");
                        query.append(TABLE_ADDRESS_CITY);
                        query.append(" AS city ");
                        if (loadCountryInfo) {
                            query.append(" LEFT JOIN ");
                            query.append(TABLE_ADDRESS_COUNTRY);
                            query.append(" AS country ON country.id=city.country_id");
                        }
                        query.append(" WHERE city.id IN ( ");
                        query.append(cityIds.substring(2));
                        query.append(" )");
                        ps = this.con.prepareStatement(query.toString());
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            AddressCity addressCity = this.getAddressCityData(rs, "city.");
                            if (loadCountryInfo && addressCity != null) {
                                addressCity.setAddressCountry(this.getAddressCountryData(rs, "country."));
                            }
                            addressCityMap.put(addressCity.getId(), addressCity);
                        }
                        rs.close();
                        ps.close();
                        for (AddressHouse addressHouse : list) {
                            AddressItem addressItem = addressHouse.getAddressStreet();
                            if (addressItem != null) {
                                addressItem.setAddressCity((AddressCity)addressCityMap.get(addressItem.getCityId()));
                            }
                            if ((addressItem = addressHouse.getAddressQuarter()) != null) {
                                addressItem.setAddressCity((AddressCity)addressCityMap.get(addressItem.getCityId()));
                            }
                            if ((addressItem = addressHouse.getAddressArea()) == null) continue;
                            addressItem.setAddressCity((AddressCity)addressCityMap.get(addressItem.getCityId()));
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public AddressStruct getAddress(int contractId, int parameterId) {
        AddressStruct addressStruct = new AddressStruct();
        try {
            String query = "SELECT aarea.title, acity.title, params.comment, params.flat,  params.floor, ahouse.frac, ahouse.house, ahouse.box_index, params.pod,  aquarter.title, params.room, astreet.title, params.hid, params.address, acountry.title FROM contract_parameter_type_2 as params LEFT JOIN address_house as ahouse ON params.hid = ahouse.id LEFT JOIN address_area as aarea ON ahouse.areaid = aarea.id LEFT JOIN address_street as astreet ON ahouse.streetid = astreet.id LEFT JOIN address_city as acity ON astreet.cityid = acity.id LEFT JOIN address_quarter as aquarter ON ahouse.quarterid = aquarter.id LEFT JOIN address_country as acountry ON acity.country_id = acountry.id WHERE params.cid = ? AND params.pid = ?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.setInt(2, parameterId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                addressStruct.setArea(rs.getString(1));
                addressStruct.setCity(rs.getString(2));
                addressStruct.setComment(rs.getString(3));
                addressStruct.setFlat(rs.getString(4));
                addressStruct.setFloor(rs.getString(5).equals("-1") ? "" : rs.getString(5));
                addressStruct.setFrac(rs.getString(6));
                addressStruct.setHouse(rs.getString(7));
                addressStruct.setIndex(rs.getString(8));
                addressStruct.setPod(rs.getString(9).equals("-1") ? "" : rs.getString(9));
                addressStruct.setQuarter(rs.getString(10));
                addressStruct.setRoom(rs.getString(11));
                addressStruct.setStreet(rs.getString(12));
                addressStruct.setHouseId(rs.getInt(13));
                addressStruct.setFullAddress(rs.getString(14));
                addressStruct.setCountry(rs.getString(15));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return addressStruct;
    }

    public void updateAddress(int contractId, int parameterId, AddressStruct addressStruct) {
        addressStruct.setFullAddress(AddressUtils.getAddress(this.setup, addressStruct, "cp." + parameterId));
        String query = null;
        PreparedStatement ps = null;
        try {
            this.deleteAddressParam(contractId, parameterId);
            query = "UPDATE contract_parameter_type_2 SET hid=?, pod=?, flat=?, room=?, floor=?, address=?, comment=? WHERE cid=? AND pid=?";
            ps = this.con.prepareStatement(query);
            this.setAddressPs(contractId, parameterId, addressStruct, ps);
            if (ps.executeUpdate() == 0) {
                ps.close();
                query = "INSERT INTO contract_parameter_type_2 (hid, pod, flat, room, floor, address, comment, cid, pid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query);
                this.setAddressPs(contractId, parameterId, addressStruct, ps);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setAddressPs(int contractId, int parameterId, AddressStruct value, PreparedStatement ps) throws SQLException {
        ps.setInt(1, value.getHouseId());
        ps.setInt(2, Utils.parseInt((String)value.getPod()));
        ps.setString(3, value.getFlat());
        ps.setString(4, value.getRoom());
        ps.setInt(5, Utils.parseInt((String)value.getFloor()));
        ps.setString(6, value.getFullAddress());
        ps.setString(7, value.getComment());
        ps.setInt(8, contractId);
        ps.setInt(9, parameterId);
    }

    public void deleteAddressParam(int contractId, int parameterId) throws SQLException {
        try {
            String query = "DELETE FROM contract_parameter_type_2 WHERE cid = ? AND pid = ?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.setInt(2, parameterId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private AddressCountry getAddressCountryData(ResultSet rs, String prefix) {
        AddressCountry addressCountry = new AddressCountry();
        try {
            addressCountry.setId(rs.getInt(prefix + "id"));
            addressCountry.setTitle(rs.getString(prefix + "title"));
        }
        catch (Exception e) {
            addressCountry = null;
        }
        return addressCountry;
    }

    private AddressCity getAddressCityData(ResultSet rs, String prefix) {
        AddressCity addressCity = new AddressCity();
        try {
            addressCity.setId(rs.getInt(prefix + "id"));
            addressCity.setCountryId(rs.getInt(prefix + "country_id"));
            addressCity.setTitle(rs.getString(prefix + "title"));
        }
        catch (Exception e) {
            addressCity = null;
        }
        return addressCity;
    }

    private AddressItem getAddressItemData(ResultSet rs, String prefix) {
        AddressItem addressItem = new AddressItem();
        try {
            addressItem.setId(rs.getInt(prefix + "id"));
            addressItem.setCityId(rs.getInt(prefix + "cityid"));
            addressItem.setTitle(rs.getString(prefix + "title"));
        }
        catch (Exception e) {
            addressItem = null;
        }
        return addressItem;
    }

    private AddressHouse getAddressHouseData(ResultSet rs, String prefix) {
        AddressHouse addressHouse = new AddressHouse();
        try {
            addressHouse.setId(rs.getInt(prefix + "id"));
            addressHouse.setAreaId(rs.getInt(prefix + "areaid"));
            addressHouse.setQuarterId(rs.getInt(prefix + "quarterid"));
            addressHouse.setStreetId(rs.getInt(prefix + "streetid"));
            addressHouse.setHouse(rs.getInt(prefix + "house"));
            addressHouse.setFrac(rs.getString(prefix + "frac"));
            addressHouse.setComment(rs.getString(prefix + "comment"));
        }
        catch (Exception e) {
            addressHouse = null;
        }
        return addressHouse;
    }

    public void addAddressCountry(AddressCountry addressCountry) {
        try {
            String query = "INSERT INTO address_country SET title=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, addressCountry.getTitle());
            ps.executeUpdate();
            ps.close();
            addressCountry.setId(ServerUtils.lastInsertId(this.con));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addAddressCity(AddressCity city) {
        try {
            String query = "INSERT INTO address_city SET country_id=?, title=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            int idx = 1;
            ps.setInt(idx++, city.getCountryId());
            ps.setString(idx++, city.getTitle());
            ps.executeUpdate();
            ps.close();
            city.setId(ServerUtils.lastInsertId(this.con));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addAddressStreet(AddressItem street) {
        try {
            String query = "INSERT INTO address_street SET cityid=?, title=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            int idx = 1;
            ps.setInt(idx++, street.getCityId());
            ps.setString(idx++, street.getTitle());
            ps.executeUpdate();
            ps.close();
            street.setId(ServerUtils.lastInsertId(this.con));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addAddressHouse(AddressHouse house) throws BGException {
        try {
            String query = "INSERT INTO address_house SET areaid=?, quarterid=?, streetid=?, house=?, frac=?, box_index=?, amount=?, comment=?, dt=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            int index = 1;
            ps.setInt(index++, house.getAreaId());
            ps.setInt(index++, house.getQuarterId());
            ps.setInt(index++, house.getStreetId());
            ps.setInt(index++, house.getHouse());
            ps.setString(index++, house.getFrac());
            ps.setString(index++, house.getBoxIndex());
            ps.setInt(index++, house.getAmount());
            ps.setString(index++, house.getComment());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)house.getDate()));
            ps.executeUpdate();
            ps.close();
            house.setId(ServerUtils.lastInsertId(this.con));
        }
        catch (Exception e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateHouse(AddressHouse house) {
        try {
            String query = "UPDATE " + TABLE_ADDRESS_HOUSE + " SET areaid=?, quarterid=?, streetid=?, house=?, frac=?, box_index=?, amount=?, comment=?, dt=? WHERE id=?";
            int index = 1;
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, house.getAreaId());
            ps.setInt(index++, house.getQuarterId());
            ps.setInt(index++, house.getStreetId());
            ps.setInt(index++, house.getHouse());
            ps.setString(index++, house.getFrac());
            ps.setString(index++, house.getBoxIndex());
            ps.setInt(index++, house.getAmount());
            ps.setString(index++, house.getComment());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)house.getDate()));
            ps.setInt(index++, house.getId());
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AddressCountry getAddressCountryByTitle(String country, boolean addIfNotExist) {
        AddressCountry addressCountry = this.countryMap.get(country);
        if (addressCountry == null) {
            try {
                PreparedStatement psSelect = this.con.prepareStatement("SELECT * FROM address_country WHERE title=?");
                psSelect.setString(1, country);
                ResultSet rs = psSelect.executeQuery();
                while (rs.next()) {
                    addressCountry = this.getAddressCountryData(rs, "");
                }
                rs.close();
                psSelect.close();
                if (addIfNotExist && addressCountry == null) {
                    addressCountry = new AddressCountry();
                    addressCountry.setTitle(country);
                    this.addAddressCountry(addressCountry);
                }
                this.countryMap.put(country, addressCountry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return addressCountry;
    }

    public AddressCity getAddressCityByTitle(String city, int countryId, boolean addIfNotExist) {
        AddressCity addressCity = this.cityMap.get(city);
        if (addressCity == null) {
            try {
                PreparedStatement psSelect = this.con.prepareStatement("SELECT * FROM address_city WHERE country_id=? AND title=?");
                psSelect.setInt(1, countryId);
                psSelect.setString(2, city);
                ResultSet rs = psSelect.executeQuery();
                while (rs.next()) {
                    addressCity = this.getAddressCityData(rs, "");
                }
                rs.close();
                psSelect.close();
                if (addIfNotExist && addressCity == null) {
                    addressCity = new AddressCity();
                    addressCity.setCountryId(countryId);
                    addressCity.setTitle(city);
                    this.addAddressCity(addressCity);
                }
                this.cityMap.put(city, addressCity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return addressCity;
    }

    public AddressItem getAddressStreetByTitle(String street, int cityId, boolean addIfNotExist) {
        AddressItem addressStreet = this.streetMap.get(street);
        if (addressStreet == null) {
            try {
                PreparedStatement psSelect = this.con.prepareStatement("SELECT * FROM address_street WHERE cityid=? AND title=?");
                psSelect.setInt(1, cityId);
                psSelect.setString(2, street);
                ResultSet rs = psSelect.executeQuery();
                while (rs.next()) {
                    addressStreet = this.getAddressItemData(rs, "");
                }
                rs.close();
                psSelect.close();
                if (addIfNotExist && addressStreet == null) {
                    addressStreet = new AddressItem();
                    addressStreet.setCityId(cityId);
                    addressStreet.setTitle(street);
                    this.addAddressStreet(addressStreet);
                }
                this.streetMap.put(street, addressStreet);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return addressStreet;
    }

    public AddressHouse getAddressHouseByHouseAndFrac(String houseFrac, int streetId, String postIndex, boolean addIfNotExist) {
        AddressHouse addressHouse = null;
        try {
            int house = 0;
            int pos = 0;
            String frac = "";
            for (int index = 0; index < houseFrac.length() && Character.isDigit(houseFrac.charAt(index)); ++index) {
                ++pos;
            }
            house = Utils.parseInt((String)houseFrac.substring(0, pos));
            frac = pos < houseFrac.length() ? houseFrac.substring(pos) : "";
            PreparedStatement psSelect = this.con.prepareStatement("SELECT * FROM address_house WHERE streetid=? AND house=? AND frac=?");
            psSelect.setInt(1, streetId);
            psSelect.setInt(2, house);
            psSelect.setString(3, frac);
            ResultSet rs = psSelect.executeQuery();
            while (rs.next()) {
                addressHouse = this.getAddressHouseData(rs, "");
            }
            rs.close();
            psSelect.close();
            if (addIfNotExist && addressHouse == null) {
                addressHouse = new AddressHouse();
                addressHouse.setStreetId(streetId);
                addressHouse.setHouse(house);
                addressHouse.setFrac(frac);
                addressHouse.setBoxIndex(postIndex);
                this.addAddressHouse(addressHouse);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return addressHouse;
    }

    public int getHouseId(String country, String city, String street, String houseFrac, String postIndex, boolean addIfNotExist) {
        AddressCountry addressCountry = this.getAddressCountryByTitle(country, addIfNotExist);
        if (addressCountry == null) {
            return -1;
        }
        AddressCity addressCity = this.getAddressCityByTitle(city, addressCountry.getId(), addIfNotExist);
        if (addressCity == null) {
            return -1;
        }
        AddressItem addressStreet = this.getAddressStreetByTitle(street, addressCity.getId(), addIfNotExist);
        if (addressStreet == null) {
            return -1;
        }
        AddressHouse addressHouse = this.getAddressHouseByHouseAndFrac(houseFrac, addressStreet.getId(), postIndex, addIfNotExist);
        return addressHouse == null ? -1 : addressHouse.getId();
    }
}

