/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.object.action;

import bitel.billing.server.contract.object.action.base.ActionBase;
import bitel.billing.server.contract.object.bean.ContractObject;
import bitel.billing.server.contract.object.bean.ObjectManager;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.event.events.ContractAddObjectEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractUpdateObjectEvent;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;

public class ActionObjectUpdate
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", -1);
        int typeId = this.getIntParameter("type", -1);
        String title = this.getParameter("title", "");
        Calendar date1 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date1"));
        Calendar date2 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date2"));
        if (id < 0 || typeId <= 0 || id == 0 && this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        ObjectManager objectManager = new ObjectManager(this.con);
        ContractObject object = new ContractObject();
        object.setId(id);
        boolean isNewObject = false;
        if (id == 0) {
            object.setContractId(this.cid);
            object.setTypeId(typeId);
            isNewObject = true;
        } else {
            object = objectManager.getObject(id);
            if (object.getTypeId() != typeId) {
                throw new BGMessageException("\u041f\u0435\u0440\u0435\u0434\u0430\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430!");
            }
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("ActionObjectUpdate", this.mid, this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate(closedDate, object.getDate1(), object.getDate2(), date1, date2);
        }
        object.setDate1(date1);
        object.setDate2(date2);
        object.setTitle(title);
        object.setTitle(objectManager.generateTitle(object));
        objectManager.updateObject(object);
        this.rootNode.setAttribute("id", String.valueOf(object.getId()));
        this.rootNode.setAttribute("title", object.getTitle());
        if (isNewObject) {
            this.context.publishAfterCommit(new ContractAddObjectEvent(this.userId, object));
        } else {
            this.context.publishAfterCommit(new ContractUpdateObjectEvent(this.userId, object));
        }
    }
}

