/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.load;

import bitel.billing.server.load.FileInfo;
import bitel.billing.server.load.Loader;
import bitel.billing.server.load.bean.Source;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Date;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import ru.bitel.common.Utils;

public class FTPLoader
extends Loader {
    public FTPLoader(int taskId, Source source, FileInfo fileInfo, String tempDirPath) {
        super(taskId, source, fileInfo, tempDirPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block28: {
            this.logger.info(this.taskId + " Load data FROM ftp://" + this.source.getHostOrDir() + this.fileInfo.getPath("/") + "/" + this.fileInfo.getFileName());
            String host = this.source.getHostOrDir();
            if (host == null) {
                host = "";
            }
            host = host.trim();
            String fileName = this.fileInfo.getFileName() + ".zip";
            try {
                String pswd;
                FTPClient ftp = new FTPClient();
                String folder = null;
                int pos = host.indexOf(47);
                if (pos > 0) {
                    folder = host.substring(pos);
                    host = host.substring(0, pos);
                }
                if ("".equals(host)) {
                    throw new Exception("Host = \"" + host + "\" [ sourceId = " + this.getSourceId() + " ]");
                }
                this.logger.info(this.taskId + " Connect to host: " + host);
                pos = host.indexOf(58);
                if (pos > 0) {
                    int port = Utils.parseInt((String)host.substring(pos + 1), (int)21);
                    host = host.substring(0, pos);
                    ftp.setDefaultPort(port);
                }
                ftp.connect(host);
                String user = this.source.getUser();
                if (user == null) {
                    user = "";
                }
                if ((pswd = this.source.getPswd()) == null) {
                    pswd = "";
                }
                ftp.login(user, pswd);
                ftp.enterLocalPassiveMode();
                ftp.setFileType(2);
                if (folder != null) {
                    ftp.cwd(folder);
                }
                ftp.cwd(this.fileInfo.getPath("/"));
                try {
                    FTPFile ftpfile = FTPLoader.getFTPFile(ftp, fileName);
                    if (ftpfile != null) {
                        this.fileInfo.setSourceSize(ftpfile.getSize());
                        Date date = ftpfile.getTimestamp().getTime();
                        if (date != null) {
                            this.fileInfo.setSourceTime(date.getTime());
                        }
                    }
                }
                catch (IOException ftpError) {
                    this.logger.error(this.taskId + " FtpError: " + fileName);
                    this.fileInfo.setSourceSize(-1L);
                    this.fileInfo.setSourceTime(-1L);
                }
                if (this.fileInfo.needLoadFile()) {
                    this.logger.info(this.taskId + " Set to load " + fileName);
                    FileOutputStream fos = null;
                    try {
                        String fs = System.getProperty("file.separator");
                        if (!this.tempDirPath.endsWith(fs)) {
                            this.tempDirPath = this.tempDirPath + fs;
                        }
                        String localFile = this.tempDirPath + this.getSourceId() + "_" + this.fileInfo.getLocalFileName() + ".zip";
                        fos = new FileOutputStream(localFile);
                        ftp.retrieveFile(this.fileInfo.getFileName() + ".zip", (OutputStream)fos);
                        this.fileInfo.setFile(new File(localFile));
                        this.load = true;
                    }
                    catch (Exception e) {
                        this.logger.error(this.taskId + " Error load file - " + this.fileInfo.getFileName() + " [ " + e.getMessage() + " ]");
                    }
                    finally {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                } else {
                    this.logger.info(this.taskId + " no need load..");
                }
                ftp.disconnect();
                this.logger.info(this.taskId + " Disconnect from host: " + host);
            }
            catch (Exception e) {
                if (this.logger == null) break block28;
                this.logger.error(this.taskId + " Error host = " + host + " [ " + e.getMessage() + " ]");
            }
        }
    }

    private static FTPFile getFTPFile(FTPClient ftp, String name) throws IOException {
        FTPFile[] files;
        for (FTPFile file : files = ftp.listFiles()) {
            if (!file.getName().equals(name)) continue;
            return file;
        }
        return null;
    }

    public static void main(String[] args) throws SocketException, IOException {
        String[] names;
        FTPClient ftp = new FTPClient();
        ftp.connect("localhost");
        ftp.login("anonymous", "");
        for (String name : names = ftp.listNames()) {
            System.out.println(name);
        }
        ftp.cwd("pub/gavno");
        FTPFile ftpfile = FTPLoader.getFTPFile(ftp, "file1");
        System.out.println(ftpfile);
        System.out.println(ftpfile.getName());
        System.out.println(ftpfile.getTimestamp().getTime());
    }
}

