/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.client;

import java.io.ByteArrayInputStream;
import javax.activation.DataHandler;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicService;

public class ClientDynLoader
extends ClassLoader {
    private DynamicService dynamicService;
    private String packName;

    public ClientDynLoader(ClientContext clientContext, String packName) {
        super(Thread.currentThread().getContextClassLoader());
        this.dynamicService = (DynamicService)clientContext.getPort(DynamicService.class);
        this.packName = packName;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            Holder data = new Holder();
            String realName = this.dynamicService.getSource(name, (Holder<DataHandler>)data);
            ByteArrayInputStream is = (ByteArrayInputStream)((DataHandler)data.value).getInputStream();
            byte[] classData = new byte[is.available()];
            is.read(classData);
            return this.defineClass(realName, classData, 0, classData.length);
        }
        catch (Exception ex) {
            throw new ClassNotFoundException(name);
        }
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = null;
        if (name.startsWith(this.packName)) {
            result = this.findClass(name);
            if (resolve) {
                this.resolveClass(result);
            }
        } else {
            result = super.loadClass(name, resolve);
        }
        return result;
    }
}

