/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import bitel.billing.server.radius.RadiusVendorAttribute;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.server.util.Trace;
import ru.bitel.bgbilling.server.util.TraceImpl;
import ru.bitel.common.Utils;

public class RadiusPacket
extends RadiusAttributeSet {
    private static final Logger log = LogManager.getLogger();
    public static final byte ACCESS_REQUEST = 1;
    public static final byte ACCESS_ACCEPT = 2;
    public static final byte ACCESS_REJECT = 3;
    public static final byte ACCOUNTING_REQUEST = 4;
    public static final byte ACCOUNTING_RESPONSE = 5;
    public static final byte ACCOUNTING_STATUS = 6;
    public static final byte PASSWORD_REQUEST = 7;
    public static final byte PASSWORD_ACCEPT = 8;
    public static final byte PASSWORD_REJECT = 9;
    public static final byte ACCOUNTING_MESSAGE = 10;
    public static final byte ACCESS_CHALLENGE = 11;
    public static final byte STATUS_SERVER = 12;
    public static final byte STATUS_CLIENT = 13;
    public static final byte DISCONNECT_REQUEST = 40;
    public static final byte DISCONNECT_ACK = 41;
    public static final byte DISCONNECT_NAK = 42;
    public static final byte CoA_REQUEST = 43;
    public static final byte CoA_ACK = 44;
    public static final byte CoA_NAK = 45;
    public static final byte ACCOUNTING_STATUS_START = 1;
    public static final byte ACCOUNTING_STATUS_STOP = 2;
    public static final byte ACCOUNTING_STATUS_UPDATE = 3;
    private static final String[] CODE_STRING = new String[46];
    private byte code;
    public final byte identifier;
    protected final byte[] requestAuthenticator;
    protected byte[] authenticator;
    protected final byte[] messageAuthenticator;
    private long createTime = System.currentTimeMillis();
    private int requestAcctStatusType = -1;
    private TraceImpl trace;
    int vendorCode = -1;
    private static final Random random;
    static final byte[] empty16;
    private final Map<String, Object> optionMap;

    protected RadiusPacket(byte code, byte identifier, byte[] requestAuthenticator, byte[] authenticator, byte[] messageAuthenticator, Map<Integer, List<RadiusAttribute<?>>> standartAttributes, Map<Integer, Map<Integer, List<RadiusAttribute<?>>>> vendorAttributes, Map<String, Object> optionMap) {
        super(standartAttributes, vendorAttributes);
        this.code = code;
        this.identifier = identifier;
        this.requestAuthenticator = requestAuthenticator;
        this.authenticator = authenticator;
        this.messageAuthenticator = messageAuthenticator;
        this.optionMap = optionMap;
    }

    public RadiusPacket(byte code, byte identifier) {
        super(new HashMap(), new HashMap());
        this.code = code;
        this.identifier = identifier;
        this.requestAuthenticator = null;
        this.authenticator = new byte[16];
        random.nextBytes(this.authenticator);
        this.messageAuthenticator = null;
        this.optionMap = new HashMap<String, Object>(8);
    }

    public byte getCode() {
        return this.code;
    }

    public void setCode(byte code) {
        this.code = code;
    }

    public boolean isRequest() {
        return this.code == 1 || this.code == 4 || this.code == 43 || this.code == 40;
    }

    public void write(ByteBuffer bb, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] authenticator = this.authenticator;
        bb.put(this.code);
        bb.put(this.identifier);
        bb.putShort((short)0);
        switch (this.code) {
            case 1: {
                bb.put(authenticator);
                break;
            }
            case 4: 
            case 40: 
            case 43: {
                bb.put(empty16);
                break;
            }
            default: {
                bb.put(this.requestAuthenticator);
            }
        }
        RadiusAttribute messageAuthenticator = null;
        for (List list : this.standartAttributes.values()) {
            for (RadiusAttribute ra : list) {
                ra.write(bb);
                if (((RadiusAttributeInfo)ra.info).type != 80) continue;
                assert (messageAuthenticator == null);
                messageAuthenticator = ra;
            }
        }
        for (Map map : this.vendorAttributes.values()) {
            for (List list : map.values()) {
                for (RadiusAttribute ra : list) {
                    ra.write(bb);
                }
            }
        }
        int position = bb.position();
        bb.limit(bb.position());
        bb.position(0);
        ByteBuffer data = bb.slice();
        bb.position(position);
        short packetLength = (short)data.limit();
        data.position(2);
        data.putShort(packetLength);
        if (messageAuthenticator != null) {
            data.rewind();
            byte[] hmac = RadiusUtils.getHmacMD5(key, data);
            data.position(messageAuthenticator.bufferPosition + 2);
            data.put(hmac);
        }
        switch (this.code) {
            case 1: {
                break;
            }
            default: {
                data.rewind();
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(data);
                md5.update(key);
                authenticator = md5.digest();
                data.position(4);
                data.put(authenticator);
                this.authenticator = authenticator;
                break;
            }
        }
    }

    public static RadiusPacket parse(ByteBuffer bb) throws BGException {
        return RadiusPacket.parse(bb, false);
    }

    public static RadiusPacket parse(ByteBuffer byteBuffer, boolean move) throws BGException {
        byte[] messageAuthenticator;
        byteBuffer.mark();
        byte packetType = byteBuffer.get();
        byte packetId = byteBuffer.get();
        short length = byteBuffer.getShort();
        byte[] authenticator = new byte[16];
        byteBuffer.get(authenticator);
        HashMap standartAttributes = new HashMap();
        HashMap vendorAttributes = new HashMap();
        boolean ok = false;
        try {
            ok = RadiusDictionary.parseAttributes(byteBuffer, length, standartAttributes, vendorAttributes);
        }
        catch (Exception e) {
            byteBuffer.reset();
            log.error("Error RADIUS packet: " + Utils.bytesToHexString((byte[])Utils.byteBufferAsArray((ByteBuffer)byteBuffer, (int)length)));
            throw new BGException((Throwable)e);
        }
        byteBuffer.reset();
        List mas = (List)standartAttributes.get(80);
        if (mas != null) {
            RadiusAttribute ma = (RadiusAttribute)mas.get(0);
            messageAuthenticator = ma.getDataAsByteArray();
        } else {
            messageAuthenticator = null;
        }
        if (move) {
            byteBuffer.position(byteBuffer.position() + length);
        }
        if (!ok) {
            return null;
        }
        return new RadiusPacket(packetType, packetId, null, authenticator, messageAuthenticator, standartAttributes, vendorAttributes, new HashMap<String, Object>(8));
    }

    public RadiusPacket createResponse() {
        Object messageAuthenticator;
        Object proxy;
        byte packetType = switch (this.code) {
            case 4 -> 5;
            case 1 -> 3;
            case 7 -> 9;
            default -> throw new IllegalArgumentException("Request code=" + this.code);
        };
        HashMap standartAttributes = new HashMap();
        HashMap vendorAttributes = new HashMap();
        RadiusPacket response = new RadiusPacket(packetType, this.identifier, this.authenticator, null, this.messageAuthenticator, standartAttributes, vendorAttributes, new HashMap<String, Object>(8));
        response.requestAcctStatusType = this.getIntAttribute(-1, 40, -1);
        Object state = this.getAttribute(-1, 24);
        if (state != null) {
            response.setAttribute((RadiusAttribute<?>)((RadiusAttribute)state).clone());
        }
        if ((proxy = this.getAttribute(-1, 33)) != null) {
            response.setAttribute((RadiusAttribute<?>)((RadiusAttribute)proxy).clone());
        }
        if ((messageAuthenticator = this.getAttribute(-1, 80)) != null) {
            response.setAttribute(new RadiusAttribute<ByteBuffer>(-1, 80, 0, ByteBuffer.wrap(new byte[16])));
        }
        response.vendorCode = this.vendorCode;
        return response;
    }

    public <O> O getOption(RadiusPacketOption<O> option) {
        return (O)this.optionMap.get(option.name);
    }

    public <O> O getOption(RadiusPacketOption<O> option, O value) {
        Object result = this.optionMap.get(option.name);
        if (result != null) {
            return (O)result;
        }
        return value;
    }

    public <O> void setOption(RadiusPacketOption<O> option, O value) {
        this.optionMap.put(option.name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("Packet type: ").append(this.getPacketTypeString()).append("\n");
        sb.append("Identifier: ").append(Utils.unsignedByteToInt((byte)this.identifier)).append("\n");
        sb.append("Authenticator: ").append("{").append(Utils.bytesToString((byte[])this.authenticator)).append("}\n");
        sb.append("Attributes:\n");
        this.toString(this.standartAttributes.entrySet(), sb);
        for (Map map : this.vendorAttributes.values()) {
            this.toString(map.entrySet(), sb);
        }
        if (this.code == 2 || this.code == 3) {
            sb.append("\nProcess time auth: ");
            sb.append(System.currentTimeMillis() - this.createTime);
            sb.append("\n");
        } else if (this.requestAcctStatusType != -1 && this.code == 5) {
            int statusType = this.requestAcctStatusType;
            long l = System.currentTimeMillis() - this.createTime;
            switch (statusType) {
                case 3: {
                    sb.append("\nProcess time update: ");
                    break;
                }
                case 2: {
                    sb.append("\nProcess time stop: ");
                    break;
                }
                case 1: {
                    sb.append("\nProcess time start: ");
                }
            }
            sb.append(l);
            sb.append("\n");
        }
        if (this.optionMap != null && this.optionMap.size() > 0) {
            sb.append("Common options: {");
            for (Map.Entry entry : this.optionMap.entrySet()) {
                Object value = entry.getValue();
                sb.append((String)entry.getKey());
                if (value instanceof byte[]) {
                    sb.append("={").append(Utils.bytesToString((byte[])((byte[])value), (boolean)false, null)).append('}');
                } else if (value instanceof ByteBuffer) {
                    ByteBuffer bb = (ByteBuffer)value;
                    bb.mark();
                    byte[] result = new byte[bb.remaining()];
                    bb.get(result);
                    bb.reset();
                    sb.append("={").append(Utils.bytesToString((byte[])result, (boolean)false, null)).append('}');
                } else {
                    sb.append('=').append(value);
                }
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append('}');
        }
        if (this.trace != null) {
            sb.append("Trace:\n");
            sb.append(this.trace.getReport());
        }
        return sb.toString();
    }

    public String getPacketTypeString() {
        return CODE_STRING[this.code];
    }

    public void fromPacket(RadiusPacket lastResponsePacket) {
        this.code = lastResponsePacket.code;
        this.vendorCode = lastResponsePacket.vendorCode;
        this.optionMap.clear();
        this.optionMap.putAll(lastResponsePacket.optionMap);
        this.standartAttributes.clear();
        this.standartAttributes.putAll(lastResponsePacket.standartAttributes);
        this.vendorAttributes.clear();
        this.vendorAttributes.putAll(lastResponsePacket.vendorAttributes);
    }

    public Trace getTrace() {
        if (this.trace == null) {
            this.trace = new TraceImpl();
        }
        return this.trace;
    }

    @Deprecated
    public Object getOption(String option) {
        return this.optionMap.get(option);
    }

    @Deprecated
    public void setOption(String option, Object value) {
        this.optionMap.put(option, value);
    }

    @Deprecated
    public void setFlag(int flag) {
        this.optionMap.put("call.type", flag);
    }

    @Deprecated
    public int getFlag() {
        Integer result = (Integer)this.optionMap.get("call.type");
        return result != null ? result : 0;
    }

    @Deprecated
    public void setPacketType(byte value) {
        this.setCode(value);
    }

    @Deprecated
    public void addAttribute(bitel.billing.server.radius.RadiusAttribute ra) {
        this.addAttribute(RadiusAttribute.newInstance(-1, ra.getAttrCode(), ByteBuffer.wrap(ra.getByteValue())));
    }

    @Deprecated
    public void setVendorAttribute(RadiusVendorAttribute rva) {
        this.setAttribute(RadiusAttribute.newInstance(rva.getVendorCode(), rva.getAttrCode(), ByteBuffer.wrap(rva.getByteValue())));
    }

    @Deprecated
    public void addVendorAttribute(RadiusVendorAttribute rva) {
        this.addAttribute(RadiusAttribute.newInstance(rva.getVendorCode(), rva.getAttrCode(), ByteBuffer.wrap(rva.getByteValue())));
    }

    @Deprecated
    public void addVendorAttributes(List<RadiusVendorAttribute> attrs) {
        for (RadiusVendorAttribute rva : attrs) {
            this.addVendorAttribute(rva);
        }
    }

    @Deprecated
    public void addAttributes(List<bitel.billing.server.radius.RadiusAttribute> attrs) {
        for (bitel.billing.server.radius.RadiusAttribute ra : attrs) {
            this.addAttribute(ra);
        }
    }

    @Deprecated
    public void setStringAttribute(int code, String value) {
        this.setAttribute(new RadiusAttribute.RadiusAttributeString(-1, code, value));
    }

    @Deprecated
    public void setIntAttribute(int code, int value) {
        this.setAttribute(new RadiusAttribute.RadiusAttributeInteger(-1, code, value));
    }

    @Deprecated
    public void setByteAttribute(int code, byte[] value) {
        this.setAttribute(new RadiusAttribute<ByteBuffer>(-1, code, 0, ByteBuffer.wrap(value)));
    }

    @Deprecated
    public byte[] getByteAttribute(int code) {
        return this.getByteAttribute(-1, code, null);
    }

    @Deprecated
    public String getStringAttribute(int code) {
        return this.getStringAttribute(-1, code, null);
    }

    @Deprecated
    public int getIntAttribute(int code) {
        return this.getIntAttribute(-1, code, 0);
    }

    @Deprecated
    public String getVendorStringAttribute(int code) {
        return this.getStringAttribute(this.vendorCode, code, null);
    }

    @Deprecated
    public int getVendorIntAttribute(int code) {
        return this.getIntAttribute(this.vendorCode, code, 0);
    }

    @Deprecated
    public List<RadiusAttribute<?>> getVendorAttributes(int vendor, int code) {
        return this.getAttributes(vendor, code);
    }

    @Deprecated
    public List<RadiusAttribute<?>> getVendorAttributes(int vendor) {
        Map attributes = vendor < 0 ? this.standartAttributes : (Map)this.vendorAttributes.get(vendor);
        ArrayList result = new ArrayList();
        for (List l : attributes.values()) {
            result.addAll(l);
        }
        return result;
    }

    @Deprecated
    public int getPacketType() {
        return this.code;
    }

    @Deprecated
    public byte getPacketId() {
        return this.identifier;
    }

    public RadiusPacket clone() {
        RadiusPacket result = new RadiusPacket(this.code, this.identifier, this.requestAuthenticator, this.authenticator, this.messageAuthenticator, new HashMap(), new HashMap(), new HashMap<String, Object>(this.optionMap));
        result.vendorCode = this.vendorCode;
        result.addAttributes(this);
        return result;
    }

    @Deprecated
    public byte[] getAuthenticatorBytes() {
        return this.authenticator;
    }

    public byte[] getAuthenticator() {
        return this.authenticator;
    }

    public void addOptions(RadiusPacket request) {
        if (request != null && request.optionMap != null) {
            this.optionMap.putAll(request.optionMap);
        }
    }

    static {
        RadiusPacket.CODE_STRING[1] = "Access-Request";
        RadiusPacket.CODE_STRING[2] = "Access-Accept";
        RadiusPacket.CODE_STRING[3] = "Access-Reject";
        RadiusPacket.CODE_STRING[4] = "Accounting-Request";
        RadiusPacket.CODE_STRING[5] = "Accounting-Response";
        RadiusPacket.CODE_STRING[6] = "Accounting-Status";
        RadiusPacket.CODE_STRING[7] = "Password-Request";
        RadiusPacket.CODE_STRING[8] = "Password-Accept";
        RadiusPacket.CODE_STRING[9] = "Password-Reject";
        RadiusPacket.CODE_STRING[10] = "Accounting-Message";
        RadiusPacket.CODE_STRING[11] = "Access-Challenge";
        RadiusPacket.CODE_STRING[12] = "Status-Server";
        RadiusPacket.CODE_STRING[13] = "Status-Client";
        RadiusPacket.CODE_STRING[40] = "Disconnect-Request";
        RadiusPacket.CODE_STRING[41] = "Disconnect-ACK";
        RadiusPacket.CODE_STRING[42] = "Disconnect-NAK";
        RadiusPacket.CODE_STRING[43] = "CoA-Request";
        RadiusPacket.CODE_STRING[44] = "CoA-ACK";
        RadiusPacket.CODE_STRING[45] = "CoA-NAK";
        random = new Random();
        empty16 = new byte[16];
    }

    public static class RadiusPacketOption<T> {
        final String name;

        public RadiusPacketOption(String name) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.name = name;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : super.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof RadiusPacketOption) {
                return this.name.equals(((RadiusPacketOption)o).name);
            }
            if (o instanceof String) {
                return this.name.equals(o);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

