/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.script.common.bean.GlobalScriptLink;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class GlobalScriptLinkDao
extends AbstractIdDao<GlobalScriptLink> {
    public GlobalScriptLinkDao(Connection con) {
        super(con, 0, "global_script_link");
    }

    protected GlobalScriptLink getFromRS(ResultSet rs) throws SQLException, BGException {
        GlobalScriptLink link = new GlobalScriptLink();
        link.setId(rs.getInt("id"));
        link.setTitle(rs.getString("title"));
        link.setClassName(rs.getString("class_name"));
        return link;
    }

    protected void updateImpl(GlobalScriptLink b) throws BGException, SQLException {
        PreparedStatement ps = null;
        if (b.getId() <= 0) {
            String query = "INSERT INTO " + this.tableName + "(title, class_name) VALUES(?,?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            String query = "UPDATE " + this.tableName + " SET title=?, class_name=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(3, b.getId());
        }
        ps.setString(1, b.getTitle());
        ps.setString(2, b.getClassName());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId(ps));
        }
    }

    public List<GlobalScriptLink> getList() throws BGException {
        return this.list("", "title", new Object[0]);
    }
}

