/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree.npay;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ModuleServiceTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.npay.server.bean.quantity.ModuleQuantity;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayServiceCost;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffContext;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffRequest;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;
import ru.bitel.common.worker.ThreadContext;

public class CalculateModeTariffTreeNode
extends ModuleServiceTariffTreeNode<NPayTariffContext, NPayServiceCost, NPayTariffRequest> {
    private final Mode mode;
    private final int calcType;
    private final int monthDay;
    private final String monthDayMode;
    private final Map<Integer, Integer> contractStartDays = new HashedMap();

    public CalculateModeTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        String modeParam = parameterMap.get("mode", null);
        this.mode = "day".equals(modeParam) ? Mode.DAY : ("year".equals(modeParam) ? Mode.YEAR : ("advance".equals(modeParam) ? Mode.ADVANCE : ("quarter".equals(modeParam) ? Mode.QUARTER : Mode.MONTH)));
        this.calcType = parameterMap.getInt("type", 0);
        this.monthDay = parameterMap.getInt("day", 1);
        this.monthDayMode = parameterMap.get("dayMode", "DAY");
    }

    @Override
    public int execute(Long treeNodeId, Long parentTreeNodeId, NPayTariffRequest tariffRequest, TariffTreeNodeHolder holder, NPayTariffContext tariffContext, TreeContext treeContext, ThreadContext workerContext) {
        List serviceCostList = (List)tariffRequest.getServiceCost().get(this.serviceId);
        if (serviceCostList == null) {
            return 0;
        }
        switch (this.mode) {
            case MONTH: {
                int size = serviceCostList.size();
                for (int i = 0; i < size; ++i) {
                    tariffRequest.serviceCost = (ServiceCost)serviceCostList.get(i);
                    this.monthMode(treeNodeId, tariffRequest, holder, tariffContext, treeContext, workerContext);
                }
                break;
            }
            case DAY: {
                int size = serviceCostList.size();
                for (int i = 0; i < size; ++i) {
                    tariffRequest.serviceCost = (ServiceCost)serviceCostList.get(i);
                    this.dayMode(treeNodeId, tariffRequest, holder, tariffContext, treeContext, workerContext);
                }
                break;
            }
            case ADVANCE: {
                int size = serviceCostList.size();
                for (int i = 0; i < size; ++i) {
                    tariffRequest.serviceCost = (ServiceCost)serviceCostList.get(i);
                    this.advanceMode(treeNodeId, tariffRequest, holder, tariffContext, treeContext, workerContext);
                }
                break;
            }
            case YEAR: {
                int size = serviceCostList.size();
                for (int i = 0; i < size; ++i) {
                    tariffRequest.serviceCost = (ServiceCost)serviceCostList.get(i);
                    this.yearMode(treeNodeId, tariffRequest, holder, tariffContext, treeContext, workerContext);
                }
                break;
            }
            case QUARTER: {
                int size = serviceCostList.size();
                for (int i = 0; i < size; ++i) {
                    tariffRequest.serviceCost = (ServiceCost)serviceCostList.get(i);
                    this.quarterMode(treeNodeId, tariffRequest, holder, tariffContext, treeContext, workerContext);
                }
                break;
            }
            default: {
                tariffRequest.addError("Unknown mode");
            }
        }
        return 1;
    }

    public void dayMode(Long treeNodeId, NPayTariffRequest tariffRequest, TariffTreeNodeHolder holder, NPayTariffContext tariffContext, TreeContext treeContext, ThreadContext workerContext) {
        Calendar end;
        Map suspendPeriodMapList;
        List<Period> suspendPeriodList;
        Calendar time = tariffRequest.getTime();
        Calendar date1 = ((NPayServiceCost)tariffRequest.serviceCost).date1;
        Calendar date2 = ((NPayServiceCost)tariffRequest.serviceCost).date2;
        BigDecimal inCost = ((NPayServiceCost)tariffRequest.serviceCost).cost;
        Map pushed = tariffRequest.acceptedSetPush();
        Calendar day = (Calendar)date1.clone();
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)day);
        Calendar dayEnd = (Calendar)date1.clone();
        if (tariffRequest.isInfoEnabled()) {
            tariffRequest.addInfo("Day mode: " + ((NPayServiceCost)tariffRequest.serviceCost).toString());
        }
        if ((suspendPeriodList = this.getSuspendPeriodList(suspendPeriodMapList = tariffContext.getSuspendPeriods(tariffRequest.contractId, ((NPayServiceCost)tariffRequest.serviceCost).serviceId))) == null && tariffRequest.isInfoEnabled()) {
            tariffRequest.addInfo("Service not suspedable");
        }
        Calendar calendar = end = this.calcType == 1 ? tariffContext.getCurrentDay() : date2;
        if (TimeUtils.dateBefore((Calendar)date2, (Calendar)end)) {
            end = date2;
        }
        BigDecimal cost = BigDecimal.ZERO;
        ModuleQuantity quantity = tariffContext.getModuleQuantity(((NPayServiceCost)tariffRequest.serviceCost).serviceId);
        List quantityPeriodList = quantity == null ? null : quantity.getPeriodQuantity(tariffRequest.getConnection(), tariffRequest.contractId, ((NPayServiceCost)tariffRequest.serviceCost).date1, ((NPayServiceCost)tariffRequest.serviceCost).date2);
        tariffRequest.cleardayDetailLog();
        HashMap<BigDecimal, Integer> mapCostCount = new HashMap<BigDecimal, Integer>();
        while (TimeUtils.dateBeforeOrEq((Calendar)day, (Calendar)end)) {
            boolean skipDayBySuspend = this.checkDayInStatus(tariffContext, day, suspendPeriodList);
            if (skipDayBySuspend) {
                if (tariffRequest.isInfoEnabled()) {
                    tariffRequest.addInfo("Service " + ((NPayServiceCost)tariffRequest.serviceCost).serviceId + " suspended at " + TimeUtils.formatDate((Calendar)day));
                }
                day.add(6, 1);
                continue;
            }
            dayEnd.setTimeInMillis(day.getTimeInMillis());
            dayEnd.add(5, 1);
            dayEnd.add(14, -1);
            assert (TimeUtils.compare((Calendar)day, (Calendar)dayEnd, (int)5) == 0);
            ((NPayServiceCost)tariffRequest.serviceCost).date1 = day;
            ((NPayServiceCost)tariffRequest.serviceCost).date2 = dayEnd;
            tariffRequest.setTime(day);
            ((NPayServiceCost)tariffRequest.serviceCost).cost = null;
            tariffRequest.acceptedSetClear();
            super.executeChildren(treeNodeId, (AbstractTariffRequest<?>)tariffRequest, holder, tariffContext, treeContext, workerContext);
            if (((NPayServiceCost)tariffRequest.serviceCost).cost != null) {
                BigDecimal mountCost;
                Integer dayCount = (Integer)mapCostCount.get(mountCost = ((NPayServiceCost)tariffRequest.serviceCost).cost.multiply(new BigDecimal(tariffRequest.getAccountingMonthDays())).setScale(2, RoundingMode.HALF_UP));
                mapCostCount.put(mountCost, dayCount == null ? 1 : dayCount + 1);
                if (tariffRequest.isInfoEnabled()) {
                    tariffRequest.addInfo(TimeUtils.formatDate((Calendar)day) + "=>" + ((NPayServiceCost)tariffRequest.serviceCost).cost);
                }
                if (quantity != null) {
                    BigDecimal quantityVal = this.getDayQuantity(day, quantityPeriodList);
                    if (tariffRequest.isInfoEnabled()) {
                        tariffRequest.addInfo("quantity val=" + quantityVal);
                    }
                    ((NPayServiceCost)tariffRequest.serviceCost).cost = ((NPayServiceCost)tariffRequest.serviceCost).cost.multiply(quantityVal, tariffContext.mc);
                    cost = cost.add(((NPayServiceCost)tariffRequest.serviceCost).cost);
                    tariffRequest.setDayDetailLog(day.get(5), ((NPayServiceCost)tariffRequest.serviceCost).cost);
                }
            } else {
                cost = null;
                break;
            }
            day.add(5, 1);
        }
        if (cost != null && quantity == null) {
            for (BigDecimal mountSum : mapCostCount.keySet()) {
                cost = cost.add(new BigDecimal((Integer)mapCostCount.get(mountSum)).divide(new BigDecimal(tariffRequest.getAccountingMonthDays()), 10, RoundingMode.HALF_UP).multiply(mountSum).setScale(2, RoundingMode.HALF_UP));
            }
        }
        ((NPayServiceCost)tariffRequest.serviceCost).date1 = date1;
        ((NPayServiceCost)tariffRequest.serviceCost).date2 = date2;
        ((NPayServiceCost)tariffRequest.serviceCost).cost = cost;
        tariffRequest.setTime(time);
        tariffRequest.acceptedSetPop(pushed);
        if (cost != null) {
            tariffRequest.addInfo("process cost=" + cost);
            ((NPayServiceCost)tariffRequest.serviceCost).cost = cost;
            if (((NPayServiceCost)tariffRequest.serviceCost).amount != 1L && ((NPayServiceCost)tariffRequest.serviceCost).cost != null) {
                ((NPayServiceCost)tariffRequest.serviceCost).cost = ((NPayServiceCost)tariffRequest.serviceCost).cost.multiply(BigDecimal.valueOf(((NPayServiceCost)tariffRequest.serviceCost).amount), tariffContext.mc);
            }
            this.addCloseReplaceServices(tariffRequest, tariffContext, suspendPeriodMapList);
            tariffRequest.setCalculateModeLog(1);
        } else {
            tariffRequest.addInfo("return cost=" + inCost);
            ((NPayServiceCost)tariffRequest.serviceCost).cost = inCost;
            tariffRequest.cleardayDetailLog();
        }
    }

    public void monthMode(Long treeNodeId, NPayTariffRequest tariffRequest, TariffTreeNodeHolder holder, NPayTariffContext tariffContext, TreeContext treeContext, ThreadContext workerContext) {
        Map suspendPeriodMapList = tariffContext.getSuspendPeriods(tariffRequest.contractId, ((NPayServiceCost)tariffRequest.serviceCost).serviceId);
        List<Period> suspendPeriodList = this.getSuspendPeriodList(suspendPeriodMapList);
        Period precalcOpenPeriod = tariffContext.getPrecalcOpenPeriod();
        long days = this.days(tariffContext, tariffRequest, suspendPeriodList, precalcOpenPeriod);
        BigDecimal inCost = ((NPayServiceCost)tariffRequest.serviceCost).cost;
        ((NPayServiceCost)tariffRequest.serviceCost).accountingPeriodDays = Long.bitCount(days);
        tariffRequest.setTime(((NPayServiceCost)tariffRequest.serviceCost).date2);
        ((NPayServiceCost)tariffRequest.serviceCost).cost = null;
        int monthDay = 1;
        Calendar currentDay = tariffContext.getCurrentDay();
        int maxDay = currentDay != null ? currentDay.getActualMaximum(5) : 31;
        switch (this.monthDayMode) {
            case "CONTRACT": {
                monthDay = this.contractStartDays.getOrDefault(tariffRequest.contractId, 0);
                if (monthDay != 0) break;
                Connection con = Setup.getSetup().getDBConnection();
                try (ContractDao contractDao = new ContractDao(con, 0);){
                    Calendar contractStart = null;
                    Contract contract = (Contract)contractDao.get(tariffRequest.contractId);
                    if (contract != null) {
                        contractStart = TimeUtils.convertDateToCalendar((Date)contract.getDateFrom());
                    }
                    monthDay = contractStart != null ? contractStart.get(5) : 1;
                    this.contractStartDays.put(tariffRequest.contractId, monthDay);
                }
                catch (BGException bGException) {}
                break;
            }
            case "SERVICE": {
                Calendar serviceStart = ((NPayServiceCost)tariffRequest.serviceCost).serviceStart;
                monthDay = serviceStart != null ? serviceStart.get(5) : 1;
                break;
            }
            default: {
                monthDay = this.monthDay;
            }
        }
        monthDay = Math.min(maxDay, monthDay);
        if (currentDay != null && monthDay <= currentDay.get(5)) {
            super.executeChildren(treeNodeId, (AbstractTariffRequest<?>)tariffRequest, holder, tariffContext, treeContext, workerContext);
        } else {
            ((NPayServiceCost)tariffRequest.serviceCost).cost = BigDecimal.ZERO;
        }
        if (((NPayServiceCost)tariffRequest.serviceCost).cost != null) {
            ModuleQuantity quantity = tariffContext.getModuleQuantity(((NPayServiceCost)tariffRequest.serviceCost).serviceId);
            if (quantity != null) {
                List quantityPeriodList = quantity.getPeriodQuantity(tariffRequest.getConnection(), tariffRequest.contractId, ((NPayServiceCost)tariffRequest.serviceCost).date1, ((NPayServiceCost)tariffRequest.serviceCost).date2);
                BigDecimal quantityVal = this.getDayQuantity(((NPayServiceCost)tariffRequest.serviceCost).date2, quantityPeriodList);
                if (tariffRequest.isInfoEnabled()) {
                    tariffRequest.addInfo("quantity val=" + quantityVal);
                }
                ((NPayServiceCost)tariffRequest.serviceCost).cost = ((NPayServiceCost)tariffRequest.serviceCost).cost.multiply(quantityVal, tariffContext.mc);
            }
            if (((NPayServiceCost)tariffRequest.serviceCost).amount != 1L) {
                ((NPayServiceCost)tariffRequest.serviceCost).cost = ((NPayServiceCost)tariffRequest.serviceCost).cost.multiply(BigDecimal.valueOf(((NPayServiceCost)tariffRequest.serviceCost).amount), tariffContext.mc);
            }
            this.addCloseReplaceServices(tariffRequest, tariffContext, suspendPeriodMapList);
            tariffRequest.setCalculateModeLog(0);
        } else {
            tariffRequest.addInfo("return cost=" + inCost);
            ((NPayServiceCost)tariffRequest.serviceCost).cost = inCost;
        }
    }

    private List<Period> getSuspendPeriodList(Map<Integer, List<Period>> suspendPeriodMapList) {
        ArrayList<Period> suspendPeriodList = null;
        if (suspendPeriodMapList.size() > 0) {
            suspendPeriodList = new ArrayList<Period>();
            for (List<Period> e : suspendPeriodMapList.values()) {
                suspendPeriodList.addAll(e);
            }
        }
        return suspendPeriodList;
    }

    public void quarterMode(Long treeNodeId, NPayTariffRequest req, TariffTreeNodeHolder holder, NPayTariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        int month = ((NPayServiceCost)req.serviceCost).date1.get(2);
        Calendar prevMonthCalendar = (Calendar)((NPayServiceCost)req.serviceCost).date1.clone();
        prevMonthCalendar.add(2, -1);
        if (!CalculateModeTariffTreeNode.isFirstInQuarter(month) && !CalculateModeTariffTreeNode.closedOnMonth((NPayServiceCost)req.serviceCost, prevMonthCalendar)) {
            ((NPayServiceCost)req.serviceCost).cost = BigDecimal.ZERO;
            return;
        }
        Map suspendPeriodMapList = ctx.getSuspendPeriods(req.contractId, ((NPayServiceCost)req.serviceCost).serviceId);
        List<Period> suspendPeriodList = this.getSuspendPeriodList(suspendPeriodMapList);
        Period precalcOpenPeriod = ctx.getPrecalcOpenPeriod();
        long days = this.days(ctx, req, suspendPeriodList, precalcOpenPeriod);
        BigDecimal inCost = ((NPayServiceCost)req.serviceCost).cost;
        ((NPayServiceCost)req.serviceCost).accountingPeriodDays = Long.bitCount(days);
        req.setTime(((NPayServiceCost)req.serviceCost).date2);
        ((NPayServiceCost)req.serviceCost).cost = null;
        super.executeChildren(treeNodeId, (AbstractTariffRequest<?>)req, holder, ctx, treeContext, workerContext);
        if (((NPayServiceCost)req.serviceCost).cost != null) {
            ModuleQuantity quantity = ctx.getModuleQuantity(((NPayServiceCost)req.serviceCost).serviceId);
            if (quantity != null) {
                List quantityPeriodList = quantity.getPeriodQuantity(req.getConnection(), req.contractId, ((NPayServiceCost)req.serviceCost).date1, ((NPayServiceCost)req.serviceCost).date2);
                BigDecimal quantityVal = this.getDayQuantity(((NPayServiceCost)req.serviceCost).date2, quantityPeriodList);
                if (req.isInfoEnabled()) {
                    req.addInfo("quantity val=" + quantityVal);
                }
                ((NPayServiceCost)req.serviceCost).cost = ((NPayServiceCost)req.serviceCost).cost.multiply(quantityVal, ctx.mc);
            }
            if (((NPayServiceCost)req.serviceCost).amount != 1L) {
                ((NPayServiceCost)req.serviceCost).cost = ((NPayServiceCost)req.serviceCost).cost.multiply(BigDecimal.valueOf(((NPayServiceCost)req.serviceCost).amount), ctx.mc);
            }
            req.setCalculateModeLog(4);
        } else {
            req.addInfo("return cost=" + inCost);
            ((NPayServiceCost)req.serviceCost).cost = inCost;
        }
    }

    private static boolean isFirstInQuarter(int month) {
        int[] quarterStartMonths = new int[]{0, 3, 6, 9};
        for (int i = 0; i < quarterStartMonths.length; ++i) {
            if (quarterStartMonths[i] != month) continue;
            return true;
        }
        return false;
    }

    private static boolean closedOnMonth(NPayServiceCost serviceCost, Calendar month) {
        return serviceCost.serviceEnd != null && serviceCost.serviceEnd.get(2) == month.get(2) && serviceCost.serviceEnd.get(1) == month.get(1);
    }

    public void yearMode(Long treeNodeId, NPayTariffRequest req, TariffTreeNodeHolder holder, NPayTariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        if (((NPayServiceCost)req.serviceCost).serviceStart == null) {
            return;
        }
        if (((NPayServiceCost)req.serviceCost).serviceStart.get(2) != ((NPayServiceCost)req.serviceCost).date1.get(2)) {
            ((NPayServiceCost)req.serviceCost).cost = BigDecimal.ZERO;
            return;
        }
        BigDecimal inCost = ((NPayServiceCost)req.serviceCost).cost;
        req.setTime(((NPayServiceCost)req.serviceCost).date2);
        super.executeChildren(treeNodeId, (AbstractTariffRequest<?>)req, holder, ctx, treeContext, workerContext);
        if (((NPayServiceCost)req.serviceCost).cost != null) {
            if (((NPayServiceCost)req.serviceCost).amount != 1L) {
                ((NPayServiceCost)req.serviceCost).cost = ((NPayServiceCost)req.serviceCost).cost.multiply(BigDecimal.valueOf(((NPayServiceCost)req.serviceCost).amount), ctx.mc);
            }
            req.setCalculateModeLog(2);
        } else {
            req.addInfo("return cost=" + inCost);
            ((NPayServiceCost)req.serviceCost).cost = inCost;
        }
    }

    public void advanceMode(Long treeNodeId, NPayTariffRequest req, TariffTreeNodeHolder holder, NPayTariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        Calendar date1 = ((NPayServiceCost)req.serviceCost).date1;
        Calendar date2 = ((NPayServiceCost)req.serviceCost).date2;
        BigDecimal inCost = ((NPayServiceCost)req.serviceCost).cost;
        if (req.isInfoEnabled()) {
            req.addInfo("Advance mode: " + ((NPayServiceCost)req.serviceCost).toString());
        }
        if (((NPayServiceCost)req.serviceCost).serviceEnd != null && TimeUtils.monthsDelta((Calendar)((NPayServiceCost)req.serviceCost).serviceStart, (Calendar)ctx.getCurrentDay()) != 0) {
            ((NPayServiceCost)req.serviceCost).cost = BigDecimal.ZERO;
            return;
        }
        Map suspendPeriodMapList = ctx.getSuspendPeriods(req.contractId, ((NPayServiceCost)req.serviceCost).serviceId);
        List<Period> suspendPeriodList = this.getSuspendPeriodList(suspendPeriodMapList);
        if (suspendPeriodList == null && req.isInfoEnabled()) {
            req.addInfo("Service not suspedable");
        }
        req.setTime(((NPayServiceCost)req.serviceCost).date1);
        ((NPayServiceCost)req.serviceCost).cost = null;
        super.executeChildren(treeNodeId, (AbstractTariffRequest<?>)req, holder, ctx, treeContext, workerContext);
        if (((NPayServiceCost)req.serviceCost).cost != null) {
            if (req.isInfoEnabled()) {
                req.addInfo("cost => " + ((NPayServiceCost)req.serviceCost).cost);
            }
            if (((NPayServiceCost)req.serviceCost).amount != 1L && ((NPayServiceCost)req.serviceCost).cost != null) {
                ((NPayServiceCost)req.serviceCost).cost = ((NPayServiceCost)req.serviceCost).cost.multiply(BigDecimal.valueOf(((NPayServiceCost)req.serviceCost).amount), ctx.mc);
            }
            BigDecimal cost = BigDecimal.ZERO;
            Calendar day = (Calendar)date1.clone();
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)day);
            Calendar dateEnd = ((NPayServiceCost)req.serviceCost).serviceEnd;
            if (dateEnd == null) {
                dateEnd = date2;
            }
            while (TimeUtils.dateBeforeOrEq((Calendar)day, (Calendar)dateEnd)) {
                boolean skipDayBySuspend = this.checkDayInStatus(ctx, day, suspendPeriodList);
                if (skipDayBySuspend) {
                    if (req.isInfoEnabled()) {
                        req.addInfo("Service " + ((NPayServiceCost)req.serviceCost).serviceId + " suspended at " + TimeUtils.formatDate((Calendar)day));
                    }
                    day.add(6, 1);
                    continue;
                }
                cost = cost.add(((NPayServiceCost)req.serviceCost).cost);
                day.add(5, 1);
            }
            ((NPayServiceCost)req.serviceCost).cost = cost;
            req.setCalculateModeLog(3);
        } else {
            req.addInfo("return cost=" + inCost);
            ((NPayServiceCost)req.serviceCost).cost = inCost;
        }
    }

    private BigDecimal getDayQuantity(Calendar day, List<ModuleQuantity.ModuleQuantityResult> quantityList) {
        int result = 0;
        for (ModuleQuantity.ModuleQuantityResult moduleQuantityResult : quantityList) {
            Period period = moduleQuantityResult.getPeriod();
            if (period.getDateFromCalendar() != null && !TimeUtils.dateBeforeOrEq((Calendar)period.getDateFromCalendar(), (Calendar)day) || period.getDateToCalendar() != null && !TimeUtils.dateBeforeOrEq((Calendar)day, (Calendar)period.getDateToCalendar())) continue;
            result += moduleQuantityResult.getCount();
        }
        return BigDecimal.valueOf(result);
    }

    private long days(NPayTariffContext ctx, NPayTariffRequest req, List<Period> suspendPeriodList, Period precalcOpenPeriod) {
        assert (((NPayServiceCost)req.serviceCost).date1 != null && ((NPayServiceCost)req.serviceCost).date2 != null && TimeUtils.monthsDelta((Calendar)((NPayServiceCost)req.serviceCost).date1, (Calendar)((NPayServiceCost)req.serviceCost).date2) == 0);
        int day1 = ((NPayServiceCost)req.serviceCost).date1.get(5);
        int result = ((NPayServiceCost)req.serviceCost).date2.get(5) - day1 + 1;
        long days = 0xFFFFFFFFL >> 32 - result << day1 - 1;
        long daysSuspended = 0L;
        if (suspendPeriodList != null) {
            int size = suspendPeriodList.size();
            for (int i = 0; i < size; ++i) {
                Period p = suspendPeriodList.get(i);
                day1 = p.getDateFromCalendar().get(5);
                result = p.getDateToCalendar().get(5) - day1 + 1;
                daysSuspended |= 0xFFFFFFFFL >> 32 - result << day1 - 1;
            }
        }
        long precalcOpened = 0L;
        if (precalcOpenPeriod != null) {
            day1 = precalcOpenPeriod.getDateFromCalendar().get(5);
            result = precalcOpenPeriod.getDateToCalendar().get(5) - day1 + 1;
            precalcOpened = 0xFFFFFFFFL >> 32 - result << day1 - 1;
        }
        return days &= daysSuspended ^ 0xFFFFFFFFFFFFFFFFL | precalcOpened;
    }

    private boolean checkDayInStatus(NPayTariffContext ctx, Calendar day, List<Period> periodList) {
        boolean skipDay = false;
        if (periodList != null) {
            for (Period period : periodList) {
                if (!TimeUtils.dateInRange((Calendar)day, (Calendar)period.getDateFromCalendar(), (Calendar)period.getDateToCalendar())) continue;
                skipDay = true;
                break;
            }
            Period precalcOpenPeriod = ctx.getPrecalcOpenPeriod();
            if (skipDay && precalcOpenPeriod != null && TimeUtils.dateInRange((Calendar)day, (Calendar)precalcOpenPeriod.getDateFromCalendar(), (Calendar)precalcOpenPeriod.getDateToCalendar())) {
                skipDay = false;
            }
        }
        return skipDay;
    }

    private void addCloseReplaceServices(NPayTariffRequest nPayTariffRequest, NPayTariffContext nPayTariffContext, Map<Integer, List<Period>> closePeriodList) {
        Period precalcOpenPeriod = nPayTariffContext.getPrecalcOpenPeriod();
        if (closePeriodList != null) {
            for (Map.Entry<Integer, List<Period>> me : closePeriodList.entrySet()) {
                Integer status = me.getKey();
                for (Period p : me.getValue()) {
                    Calendar date2;
                    int wrapServiceId = nPayTariffContext.getWrapService(((NPayServiceCost)nPayTariffRequest.serviceCost).serviceId, status.intValue());
                    if (wrapServiceId <= 0) continue;
                    Calendar date1 = TimeUtils.dateBefore((Calendar)p.getDateFromCalendar(), (Calendar)((NPayServiceCost)nPayTariffRequest.serviceCost).date1) ? ((NPayServiceCost)nPayTariffRequest.serviceCost).date1 : p.getDateFromCalendar();
                    Calendar calendar = date2 = TimeUtils.dateBefore((Calendar)p.getDateToCalendar(), (Calendar)((NPayServiceCost)nPayTariffRequest.serviceCost).date2) ? p.getDateToCalendar() : ((NPayServiceCost)nPayTariffRequest.serviceCost).date2;
                    if (precalcOpenPeriod != null && TimeUtils.dateBefore((Calendar)precalcOpenPeriod.getDateFromCalendar(), (Calendar)date2)) {
                        date2 = TimeUtils.getPrevDay((Calendar)precalcOpenPeriod.getDateFromCalendar());
                    }
                    if (!TimeUtils.dateBeforeOrEq((Calendar)date1, (Calendar)date2)) continue;
                    NPayServiceCost serviceCost = new NPayServiceCost(wrapServiceId, ((NPayServiceCost)nPayTariffRequest.serviceCost).serviceStart, ((NPayServiceCost)nPayTariffRequest.serviceCost).serviceEnd, date1, date2, ((NPayServiceCost)nPayTariffRequest.serviceCost).amount);
                    nPayTariffRequest.addServiceCost((ServiceCost)serviceCost);
                }
            }
        }
    }

    static enum Mode {
        MONTH,
        DAY,
        YEAR,
        ADVANCE,
        QUARTER;

    }
}

