/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.kernel.directories.address.common.bean.City;

public class CityDao
extends AbstractIdDao<City>
implements Directory<City> {
    public CityDao(Connection con) {
        super(con, 0, "address_city");
    }

    protected City getFromRS(ResultSet rs) throws SQLException, BGException {
        City result = new City();
        result.setId(rs.getInt("id"));
        result.setCountryId(rs.getInt("country_id"));
        result.setTitle(rs.getString("title"));
        return result;
    }

    protected void updateImpl(City b) throws BGException, SQLException {
        PreparedStatement ps;
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (country_id, title) VALUES (?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET country_id=?, title=? WHERE id=?");
            ps.setInt(3, b.getId());
        }
        ps.setInt(1, b.getCountryId());
        ps.setString(2, b.getTitle());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    @Override
    public List<City> list() throws BGException {
        return super.list(null, "title", new Object[0]);
    }

    public List<City> list(int countryId, String title) throws BGException {
        return super.list("(? OR country_id=?) AND (? OR title LIKE ?)", "title", new Object[]{countryId <= 0, countryId, Utils.isBlankString((String)title), title + "%"});
    }

    @Override
    public City get(String title) throws BGException {
        return (City)super.get("title=?", new Object[]{title});
    }
}

