/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.admin.DialogContractSelect;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractIdTitleComment;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.model.IdTitle;

public class BGControlPanelContractSelect
extends BGPanel {
    private boolean singleSelect;
    private boolean okCancel;
    private int ignoredCid;
    private String contracts;
    private JButton selectButton;
    private List<WindowListener> windowListeners;
    private DialogContractSelect dialog;

    public BGControlPanelContractSelect() {
        this(true, false);
    }

    public BGControlPanelContractSelect(boolean border) {
        this(border, false);
    }

    public BGControlPanelContractSelect(boolean border, boolean singleSelect) {
        this(border, singleSelect, false);
    }

    public BGControlPanelContractSelect(boolean border, boolean singleSelect, boolean okCancel) {
        this.singleSelect = singleSelect;
        this.okCancel = okCancel;
        this.jbInit(border);
    }

    public BGControlPanelContractSelect(boolean border, boolean singleSelect, boolean okCancel, int ignoredCid) {
        this(border, singleSelect, okCancel);
        this.ignoredCid = ignoredCid;
    }

    public void setIgnoredCid(int ignoredCid) {
        this.ignoredCid = ignoredCid;
    }

    private void jbInit(boolean border) {
        this.selectButton = new JButton();
        this.selectButton.setHorizontalAlignment(2);
        this.selectButton.setMargin(new Insets(2, 2, 2, 2));
        this.selectButton.addActionListener(e -> this.select());
        this.setText("");
        JButton resetButton = new JButton("X");
        resetButton.setMargin(new Insets(2, 2, 2, 2));
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGControlPanelContractSelect.this.setContractId(0);
                String oldContracts = BGControlPanelContractSelect.this.contracts;
                BGControlPanelContractSelect.this.contracts = "";
                BGControlPanelContractSelect.this.setText("");
                if (BGControlPanelContractSelect.this.windowListeners != null && Utils.notBlankString(oldContracts)) {
                    BGControlPanelContractSelect.this.windowListeners.forEach(n -> n.windowClosed(null));
                }
            }
        });
        this.setLayout(new GridBagLayout());
        if (border) {
            BGSwingUtilites.wrapBorder(this, this.singleSelect ? "\u0414\u043e\u0433\u043e\u0432\u043e\u0440" : "\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
            this.add((Component)this.selectButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)resetButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        } else {
            this.add((Component)this.selectButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)resetButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        }
    }

    private void setText(String text) {
        if (Utils.isBlankString(text)) {
            this.selectButton.setText(this.singleSelect ? "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440..." : "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440(\u044b)...");
            this.selectButton.setToolTipText(this.singleSelect ? "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440..." : "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440(\u044b)...");
        } else {
            this.selectButton.setText(text);
            this.selectButton.setToolTipText(text);
        }
    }

    private String[] getSelectSingle() {
        String[] selected = null;
        List<ContractIdTitleComment> contracts = BGClientBase.getFrame().getTabbedPane().getContracts();
        for (IdTitle idTitle : contracts) {
            if (this.ignoredCid == idTitle.getId()) continue;
            if (contracts.size() == 2 && (this.ignoredCid == 0 || ((IdTitle)contracts.get(0)).getId() != this.ignoredCid && ((IdTitle)contracts.get(1)).getId() != this.ignoredCid) || contracts.size() > 2) break;
            selected = new String[]{String.valueOf(idTitle.getId()), idTitle.getTitle()};
        }
        return selected;
    }

    private void select() {
        String[] selected = this.getSelectSingle();
        if (selected == null) {
            this.dialog = new DialogContractSelect(this.okCancel, this.singleSelect, this.ignoredCid);
            if (this.windowListeners != null) {
                this.windowListeners.forEach(n -> this.dialog.addWindowListener((WindowListener)n));
            }
            this.dialog.setVisible(true);
            selected = this.dialog.getSelected();
            this.setContracts(selected[0], selected[1]);
            this.dialog.dispose();
        } else {
            this.setContracts(selected[0], selected[1]);
            if (this.windowListeners != null) {
                this.windowListeners.forEach(n -> n.windowClosed(null));
            }
        }
    }

    public String getContracts() {
        return this.contracts;
    }

    public Set<Integer> getContractSet() {
        return Utils.toSet(this.contracts).stream().map(s -> Integer.parseInt(s)).collect(Collectors.toSet());
    }

    public List<Integer> getContractList() {
        return Utils.notBlankString(this.contracts) ? Utils.toSet(this.contracts).stream().map(s -> Integer.parseInt(s)).collect(Collectors.toList()) : null;
    }

    public void setContracts(String cids, String titles) {
        this.contracts = cids;
        this.setText(titles);
    }

    public void addWindowListenerForDialog(WindowListener listener) {
        if (this.windowListeners == null) {
            this.windowListeners = new ArrayList<WindowListener>();
        }
        this.windowListeners.add(listener);
    }
}

