/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.contract.ContractEditor;
import bitel.billing.module.contract.ContractPanel;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventSubscriber;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ContractPanel_Report
extends ContractPanel
implements EventSubscriber<UpdateContractTreeEvent> {
    private JTabbedPane reportTabbedPane = new JTabbedPane();
    private boolean inited = false;

    public ContractPanel_Report(ContractEditor editor) {
        this.init(editor);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EventBus.subscribe(UpdateContractTreeEvent.class, (EventSubscriber)this);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.reportTabbedPane.setTabPlacement(1);
        this.add((Component)this.reportTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setData() {
        if (!this.inited) {
            this.inited = true;
            this.refreshSelectedPanel();
        }
    }

    protected void refreshSelectedPanel() {
        JPanel panel = this.getSelectedTab();
        if (panel != null) {
            if (panel instanceof BGPanel) {
                ((BGPanel)panel).setData();
            } else if (panel instanceof BGUPanel) {
                ((BGUPanel)panel).performAction("refresh");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "refresh") {
            this.refreshSelectedPanel();
            return;
        }
        super.actionPerformed(e);
    }

    @Override
    public void init(ContractEditor editor) {
        super.init(editor);
        if (this.reportTabbedPane.getTabCount() == 0) {
            Request request = new Request();
            request.setModule("contract");
            request.setAction("GetPackageName");
            request.setContractId(this.getContractId());
            this.setDocument(this.getDocument(request));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            this.reportTabbedPane.removeAll();
            Node packages = XMLUtils.selectNode(doc, "//packages");
            if (packages != null && packages.hasChildNodes()) {
                for (Element item : XMLUtils.elements(packages.getChildNodes())) {
                    String tmp = XMLUtils.getAttribute(item, "id", "-1");
                    int packageID = Utils.parseInt(tmp, -1);
                    String packageName = XMLUtils.getAttribute(item, "package", null);
                    String packageTitle = XMLUtils.getAttribute(item, "title", null);
                    if (packageName == null || packageTitle == null || packageID == -1) continue;
                    try {
                        String className = packageName + ".ServiceReportPanel";
                        String module = ClientUtils.getValueFromResourceBundle(packageName + ".setup", "module.id", this.module);
                        ClientContext context = new ClientContext(module, packageID, this.getContractId(), this.rb_name);
                        ClientContext.push(context);
                        try {
                            JPanel panel = Utils.newInstance(className, JPanel.class);
                            if (panel instanceof ServicePanel) {
                                ((ServicePanel)panel).init(this.getContractId(), packageID);
                            } else {
                                if (!(panel instanceof BGUPanel)) continue;
                                Constructor<?> constructor = panel.getClass().getConstructor(ClientContext.class);
                                panel = (BGUPanel)constructor.newInstance(context);
                            }
                            this.reportTabbedPane.add((Component)panel, packageTitle);
                        }
                        finally {
                            ClientContext.pop();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            this.reportTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!ContractPanel_Report.this.fl) {
                        ContractPanel_Report.this.refreshSelectedPanel();
                    }
                }
            });
        }
    }

    private JPanel getSelectedTab() {
        return (JPanel)this.reportTabbedPane.getSelectedComponent();
    }

    @Override
    public void deleteItem() {
        Component comp = this.reportTabbedPane.getSelectedComponent();
        if (comp instanceof BGPanel) {
            ((BGPanel)comp).deleteItem();
        }
    }

    @Override
    public void editItem() {
        Component comp = this.reportTabbedPane.getSelectedComponent();
        if (comp instanceof BGPanel) {
            ((BGPanel)comp).editItem();
        }
    }

    public void onEvent(UpdateContractTreeEvent event) {
        this.inited = false;
        this.fl = true;
        if (event.getContractId() == this.getContractId()) {
            while (this.reportTabbedPane.getTabCount() > 0) {
                this.reportTabbedPane.removeTabAt(0);
            }
            this.init(this.editor);
        }
        this.fl = false;
    }
}

