/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.contract.ContractEditor;
import bitel.billing.module.contract.ContractSubPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;

public class ContractSubPanel_WebStatLog
extends ContractSubPanel {
    public static final String LOG_TYPE_OK = "ok";
    public static final String LOG_TYPE_ERROR = "error";
    private boolean firstSetData = false;
    private BGTable table = null;
    private String logType = null;
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGControlPanelPeriodNoB periodControl = new BGControlPanelPeriodNoB();

    public ContractSubPanel_WebStatLog() {
        try {
            this.table = new BGTable(){

                @Override
                public TableCellRenderer getCellRenderer(int row, int column) {
                    TableCellRenderer tableCellRenderer = null;
                    tableCellRenderer = column < 3 ? HorizontalAlignmentTableCellRenderer.CENTER.get() : super.getCellRenderer(row, column);
                    return tableCellRenderer;
                }
            };
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel filterPanel = new JPanel(new GridBagLayout());
        BGButton okButton = new BGButton("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c");
        filterPanel.setBorder(new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440"));
        filterPanel.add((Component)this.periodControl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)okButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)this.pagePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContractSubPanel_WebStatLog.this.setData(true);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ContractSubPanel_WebStatLog.this.viewItem();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)filterPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    public void setLogType(String logType) {
        this.logType = null;
        if (logType != null && LOG_TYPE_OK.equals(logType)) {
            this.logType = logType;
            this.table.setHeader(this.rb_name, this.moduleDoc, "logon.ok");
        } else if (logType != null && LOG_TYPE_ERROR.equals(logType)) {
            this.logType = logType;
            this.table.setHeader(this.rb_name, this.moduleDoc, "logon.error");
        }
    }

    private void viewItem() {
    }

    public void setFirstData() {
        if (!this.firstSetData) {
            this.setData(true);
            this.pagePanel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().startsWith("to")) {
                        ContractSubPanel_WebStatLog.this.setData();
                    }
                }
            });
        }
    }

    public void setData(boolean resetPageIndex) {
        if (resetPageIndex) {
            this.pagePanel.init();
        }
        this.setData();
    }

    @Override
    public void setData() {
        if (this.logType != null) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("WebContractLogonLog");
            request.setContractId(this.getContractId());
            request.setPeriod(this.periodControl.getPeriod());
            request.setPageIndex(this.pagePanel.getPageIndex());
            request.setPageSize(this.pagePanel.getPageSize());
            request.setAttribute("logType", this.logType);
            this.setDocument(this.getDocument(request));
            this.firstSetData = true;
        }
    }

    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            Element tableElement = this.table.updateData(doc);
            this.pagePanel.setPageInfo(tableElement);
        }
    }

    @Override
    public void setParentComponent(ContractEditor editor) {
        super.setParentComponent(editor);
        this.pagePanel.setKey(ContractSubPanel_WebStatLog.class.getName());
    }
}

