/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGBorderFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class CommentPatternEditor
extends BGPanel {
    private int id = -1;
    private int mode = 17;
    private String nameEditor = "\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0435\u0432";
    private BGButtonPanelRestoreOkCancelHelp bGControlPanel_02 = new BGButtonPanelRestoreOkCancelHelp();
    private JTextField title = new JTextField();
    private JTextField pattern = new JTextField();
    private JPanel editorPanel = new JPanel(new GridBagLayout());
    private PatternTableModel patternTableModel = new PatternTableModel(PatternTableModel.class.getName());
    private BGUTable table = new BGUTable(this.patternTableModel);

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
    }

    public CommentPatternEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.table.getSelectionModel().setSelectionMode(0);
        this.editorPanel.setVisible(false);
    }

    private void jbInit() throws Exception {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.title.setPreferredSize(new Dimension(this.title.getPreferredSize().width, 24));
        this.pattern.setPreferredSize(new Dimension(this.pattern.getPreferredSize().width, 24));
        this.editorPanel.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        jPanel3.setBorder(new BGTitleBorder(this.nameEditor));
        this.bGControlPanel_02.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommentPatternEditor.this.bGControlPanel_02_actionPerformed(e);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) == 0) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    CommentPatternEditor.this.editItem();
                }
            }
        });
        this.table.setBorder(BGBorderFactory.createEmptyBorder());
        this.editorPanel.add((Component)this.bGControlPanel_02, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(15, 10, 5, 10), 0, 0));
        this.editorPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        jPanel2.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        jPanel2.add((Component)new JLabel("\u0428\u0430\u0431\u043b\u043e\u043d:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        jPanel2.add((Component)this.pattern, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.editorPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ListDirectory");
        request.setAttribute("mode", this.mode);
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.setDocument(doc);
        }
    }

    @Override
    public void setDocument(Document doc) {
        this.id = -1;
        ArrayList<ContractPattern> patterns = new ArrayList<ContractPattern>();
        for (Element element : XMLUtils.selectElements(doc, "//table/data/row")) {
            ContractPattern contractPattern = new ContractPattern();
            contractPattern.setId(Utils.parseInt(element.getAttribute("f0")));
            contractPattern.setTitle(element.getAttribute("f1"));
            contractPattern.setPattern(element.getAttribute("f2"));
            patterns.add(contractPattern);
        }
        this.patternTableModel.setData(patterns);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if ("newItem".equals(actionCommand)) {
            this.editorPanel.setVisible(true);
            this.id = -1;
            this.title.setText("");
            this.pattern.setText("");
        } else if ("editItem".equals(actionCommand)) {
            this.editItem();
        } else if ("deleteItem".equals(actionCommand)) {
            ContractPattern contractPattern = (ContractPattern)this.patternTableModel.getSelectedRow();
            if (contractPattern == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
                return;
            }
            if (!ClientUtils.confirmDelete(((ContractPattern)this.patternTableModel.getSelectedRow()).getTitle())) {
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("DeleteDirectoryItem");
            request.setAttribute("mode", this.mode);
            request.setAttribute("id", ((ContractPattern)this.patternTableModel.getSelectedRow()).getId());
            if (!ClientUtils.checkStatus(TransferManager.getDocument(request))) {
                return;
            }
            this.setData();
        } else if ("refresh".equals(actionCommand)) {
            this.setData();
        }
    }

    void bGControlPanel_02_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("ok".equals(actionCommand)) {
            if (this.title.getText().trim().length() == 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("UpdateDirectoryItem");
            request.setAttribute("mode", this.mode);
            request.setAttribute("id", this.id);
            request.setAttribute("title", this.title.getText().trim());
            request.setAttribute("pattern", this.pattern.getText().trim());
            if (ClientUtils.checkStatus(TransferManager.getDocument(request))) {
                this.setData();
            }
            this.editorPanel.setVisible(false);
        } else if ("reset".equals(actionCommand)) {
            this.editItem();
        } else if ("cancel".equals(actionCommand)) {
            this.editorPanel.setVisible(false);
        }
    }

    @Override
    public void editItem() {
        ContractPattern contractPattern = (ContractPattern)this.patternTableModel.getSelectedRow();
        if (contractPattern == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
            return;
        }
        this.editorPanel.setVisible(true);
        this.id = contractPattern.getId();
        this.title.setText(contractPattern.getTitle());
        this.pattern.setText(contractPattern.getPattern());
    }

    class PatternTableModel
    extends BGTableModel<ContractPattern> {
        public PatternTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 150, 250, 500, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0428\u0430\u0431\u043b\u043e\u043d", 150, 150, -1, "pattern", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }
    }

    public class ContractPattern
    extends IdTitle {
        private String pattern = "";

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }
}

