/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.ListItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ListValuesPopupEditor
extends JPopupMenu {
    protected JTextField valueField = new JTextField();
    protected JList<ListItem> valuesList = new JList();
    protected JButton addButton = new JButton();
    protected JButton removeButton = new JButton();
    protected JButton cancelButton = new JButton();
    protected String action = "List";
    protected String module;
    protected String paramId;
    protected String customValue;
    protected ListModel<ListItem> valuesListModel;

    public ListValuesPopupEditor() {
        this.jbinit();
    }

    protected void jbinit() {
        this.valueField.setPreferredSize(new Dimension(150, 25));
        this.valuesList.setSelectionMode(0);
        this.addButton.setText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c");
        this.addButton.setPreferredSize(new Dimension(110, 25));
        this.removeButton.setText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        this.removeButton.setPreferredSize(new Dimension(110, 25));
        this.removeButton.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0432\u043e\u0451 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0437 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        this.cancelButton.setPreferredSize(new Dimension(110, 25));
        this.cancelButton.setText("\u041e\u0442\u043c\u0435\u043d\u0430");
        this.setTextButton();
        JScrollPane scroll = new JScrollPane(this.valuesList);
        scroll.setPreferredSize(new Dimension(120, 100));
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.valueField, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel("\u0418\u043b\u0438 \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0437 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430:"), new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)scroll, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.addButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.removeButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.cancelButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.addButton.addActionListener(e -> {
            if (Utils.isBlankString(this.valueField.getText()) && this.valuesList.isSelectionEmpty()) {
                return;
            }
            if (this.addButton.getActionCommand().equals("replace")) {
                this.updateValue();
            } else {
                this.addValue();
            }
            this.setVisible(false);
        });
        this.removeButton.addActionListener(e -> this.deleteValue());
        this.cancelButton.addActionListener(e -> this.setVisible(false));
        this.valueField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ListValuesPopupEditor.this.autoCompleteJList();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ListValuesPopupEditor.this.autoCompleteJList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ListValuesPopupEditor.this.autoCompleteJList();
            }
        });
        this.valuesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListValuesPopupEditor.this.setTextButton();
            }
        });
    }

    public void init(String module, String paramId) {
        this.module = module;
        this.paramId = paramId;
    }

    public void setText(String text) {
        this.valueField.setText(text);
    }

    public String getText() {
        return this.valueField.getText();
    }

    protected void autoCompleteJList() {
        if (this.valuesListModel == null) {
            return;
        }
        String text = this.valueField.getText().toLowerCase().trim();
        int index = -1;
        DefaultListModel<ListItem> newModel = new DefaultListModel<ListItem>();
        for (int i = 0; i < this.valuesListModel.getSize(); ++i) {
            ListItem item = this.valuesListModel.getElementAt(i);
            String elem = item.toString().toLowerCase();
            if (!elem.toLowerCase().startsWith(text)) continue;
            ListItem newItem = new ListItem();
            newItem.setText(item.toString());
            newItem.setAttribute("id", item.getAttribute("id"));
            if (elem.equals(text)) {
                index = newModel.size();
            }
            newModel.addElement(newItem);
        }
        this.valuesList.setModel(newModel);
        if (index != -1) {
            this.valuesList.setSelectedIndex(index);
        }
        this.setTextButton();
    }

    protected void setTextButton() {
        if (this.valuesList.isSelectionEmpty()) {
            this.addButton.setText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c");
            this.addButton.setActionCommand("add");
            this.addButton.setToolTipText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u0438 \u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u0438\u043c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435");
        } else {
            this.addButton.setText("\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c");
            this.addButton.setActionCommand("replace");
            this.addButton.setToolTipText("\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 \u043d\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0438\u0437 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430");
        }
    }

    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction(this.action + "Values");
        request.setAttribute("pid", this.paramId);
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            ClientUtils.buildList(this.valuesList, XMLUtils.selectNode(doc, "//values"));
        }
        this.valuesListModel = this.valuesList.getModel();
        this.autoCompleteJList();
    }

    protected void updateValue() {
        this.updateValue(this.getSelectedId(), this.valuesList.getSelectedValue() != null ? this.valuesList.getSelectedValue().toString() : "");
    }

    protected void addValue() {
        this.updateValue(0, this.valueField.getText().trim());
    }

    protected void updateValue(int id, String title) {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("Update" + this.action + "CustomValue");
        request.setAttribute("id", id);
        request.setAttribute("pid", this.paramId);
        request.setAttribute("title", title);
        request.setAttribute("customValue", this.customValue);
        if (ClientUtils.checkStatus(TransferManager.getDocument(request))) {
            this.setData();
            this.firePropertyChange("UpdateListValue", null, null);
        }
    }

    protected void deleteValue() {
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("Delete" + this.action + "CustomValue");
            request.setAttribute("customValue", this.customValue);
            request.setAttribute("pid", this.paramId);
            if (ClientUtils.checkStatus(TransferManager.getDocument(request))) {
                this.setData();
                this.firePropertyChange("UpdateListValue", null, null);
            }
        }
    }

    protected int getSelectedId() {
        int id = -1;
        ListItem li = this.valuesList.getSelectedValue();
        if (li != null) {
            id = Utils.parseInt((String)li.getAttribute("id"));
        }
        return id;
    }

    public void setCustomValue(String customValue) {
        this.customValue = customValue;
    }
}

