/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.status;

import bitel.billing.module.contract.ContractEditor;
import bitel.billing.module.contract.ContractSubPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.status.client.ClientStatusUtil;
import ru.bitel.bgbilling.kernel.contract.status.client.StatusControlPanel;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class ContractSubPanel_Status
extends ContractSubPanel {
    private StatusTableModel statusTableModel = new StatusTableModel(StatusTableModel.class.getName());
    private StatusLogTableModel statusLogTableModel = new StatusLogTableModel(StatusLogTableModel.class.getName());
    private StatusControlPanel statusControl = new StatusControlPanel();

    public ContractSubPanel_Status() {
        this.jbInit();
    }

    private void jbInit() {
        BGPanel logPanel = new BGPanel();
        logPanel.setLayout(new GridBagLayout());
        logPanel.add((Component)new JScrollPane(new BGUTable(this.statusLogTableModel)), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.wrapBorder(logPanel, "\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432");
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(0, new JScrollPane(new BGUTable(this.statusTableModel)), (Component)logPanel, 300L);
        this.statusControl.addActionListener(e -> this.changeStatus());
        this.setLayout(new GridBagLayout());
        this.add((Component)this.statusControl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)splitPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void init(ContractEditor editor) {
        super.init(editor);
    }

    @Override
    public void setData() {
        ArrayList<Element> data;
        this.statusControl.performAction("refresh");
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ContractStatusTable");
        request.setContractId(this.getContractId());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            data = new ArrayList<Element>();
            for (Element element : XMLUtils.selectElements(doc, "//table/data/row")) {
                data.add(element);
            }
            this.statusTableModel.setData(data);
        }
        request = new Request();
        request.setModule(this.module);
        request.setAction("ContractStatusLog");
        request.setContractId(this.getContractId());
        doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            data = new ArrayList();
            for (Element element : XMLUtils.selectElements(doc, "//table/data/row")) {
                data.add(element);
            }
            this.statusLogTableModel.setData(data);
        }
    }

    private void changeStatus() {
        if (this.statusControl.getDateFrom() == null) {
            ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
            return;
        }
        int[] cids = new int[]{this.getContractId()};
        ClientStatusUtil.changeStatusOnServer(this, this.getContext(), cids, this.statusControl.getStatusId(), this.statusControl.getDateFrom(), this.statusControl.getDateTo(), this.statusControl.getComment());
        this.setData();
        EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
    }

    class StatusTableModel
    extends BGTableModel<Element> {
        public StatusTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 100, 200, 200, "period", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 200, 300, "status", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }
    }

    class StatusLogTableModel
    extends BGTableModel<Element> {
        public StatusLogTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 100, 200, 200, "period", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u0414\u0430\u0442\u0430", 200, 200, 200, "date", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 200, 300, "status", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 100, 100, -1, "user", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }
    }
}

