/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.services.ServiceEditorListPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.util.List;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.BGControlPanelTextArea;

public class ServiceEditor
extends BGPanel {
    private BGControlPanelPeriod bgControlPanelPeriod = new BGControlPanelPeriod();
    private ServiceEditorListPanel listPanel = new ServiceEditorListPanel();
    private BGControlPanelTextArea bGControlPanel_TextArea = new BGControlPanelTextArea();
    private BGButtonPanelRestoreOkCancelHelp bgControlPanelOkCancel = new BGButtonPanelRestoreOkCancelHelp();

    public ServiceEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setVisible(false);
    }

    private void jbInit() throws Exception {
        this.setBorder(new BGTitleBorder("\u0412\u044b\u0431\u043e\u0440 \u0443\u0441\u043b\u0443\u0433\u0438"));
        this.setLayout(new GridBagLayout());
        this.bGControlPanel_TextArea.setTitle(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 ");
        this.bGControlPanel_TextArea.getJTextArea().setColumns(50);
        this.bGControlPanel_TextArea.getJTextArea().setRows(5);
        this.bgControlPanelPeriod.setTitleBorderName(" \u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f ");
        this.add((Component)this.listPanel, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.bgControlPanelPeriod, new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 2, new Insets(5, 0, 0, 10), 0, 0));
        this.add((Component)this.bGControlPanel_TextArea, new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.bgControlPanelOkCancel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.bgControlPanelOkCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceEditor.this.bGControlPanel_02_actionPerformed(e);
            }
        });
        this.listPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceEditor.this.setData();
            }
        });
    }

    public void setServicesBoxEnable(boolean enable) {
        this.listPanel.setEnabled(enable);
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ContractService");
        request.setAttribute("id", this.id);
        request.setModuleId(this.getModuleId());
        request.setAttribute("onlyUsing", this.listPanel.isShowOnlyUsing());
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            Element service = XMLUtils.selectElement(doc, "//service");
            String sid = XMLUtils.getAttribute(service, "sid", "0");
            this.bgControlPanelPeriod.setLocalDateFrom(LocalDate.now());
            String date1 = XMLUtils.getAttribute(service, "date1", null);
            if (date1 != null) {
                this.bgControlPanelPeriod.setDateString1(date1);
            }
            this.bgControlPanelPeriod.setDateString2(XMLUtils.getAttribute(service, "date2", ""));
            this.bGControlPanel_TextArea.setText(XMLUtils.getAttribute(service, "comment", ""));
            this.listPanel.buildList(XMLUtils.selectNode(doc, "//tree"), sid);
        }
    }

    void bGControlPanel_02_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("ok".equals(actionCommand)) {
            if ("".equals(this.bgControlPanelPeriod.getDateString1())) {
                ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
                return;
            }
            int selectedCount = 0;
            List<String> idList = this.listPanel.getSelectedIdList();
            for (String idService : idList) {
                Request request = new Request();
                request.setModule("contract");
                request.setAction("UpdateContractService");
                request.setAttribute("id", this.id);
                request.setContractId(this.getContractId());
                request.setAttribute("sid", idService);
                request.setAttribute("date1", this.bgControlPanelPeriod.getDateString1());
                request.setAttribute("date2", this.bgControlPanelPeriod.getDateString2());
                request.setAttribute("comment", this.bGControlPanel_TextArea.getText());
                if (!ClientUtils.checkStatus(TransferManager.getDocument(request))) continue;
                ++selectedCount;
            }
            if (selectedCount == 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443");
                return;
            }
            this.setVisible(false);
            EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
        } else if ("cancel".equals(actionCommand)) {
            this.setVisible(false);
        } else if ("reset".equals(actionCommand)) {
            this.setData();
        } else if ("help".equals(actionCommand)) {
            this.openHelp(ServiceEditor.class.getName());
        }
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (!flag) {
            this.firePropertyChange("closeEditor", "0", "1");
        }
    }

    public void setEditData(String serviceId, String comment, String date) {
        this.listPanel.selectByIds(serviceId);
        String[] s = date.split("-");
        if (s.length > 1) {
            this.bgControlPanelPeriod.setDateString1(s[0]);
            if (s.length > 2) {
                this.bgControlPanelPeriod.setDateString1(s[1]);
            }
        }
        this.bGControlPanel_TextArea.setText(comment);
    }
}

