/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services;

import bitel.billing.module.common.ComboBoxItem;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.voiceip.client.ServicePropertiesPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.GroupParent;

public class ServicePanel
extends BGPanel
implements GroupParent {
    protected JTabbedPane editorsTabbedPane;
    protected CardLayout cardLayout1;
    protected int objectId;
    private ClientContext context = null;
    protected Map<String, Object> params;

    public ServicePanel() {
        this.init();
    }

    private void init() {
        this.rb_name = this.getClass().getPackage().getName() + ".setup";
        this.module = ClientUtils.getValueFromResourceBundle(this.rb_name, "module.id", this.module);
    }

    public void init(int contractId, int moduleId) {
        this.setContractId(contractId);
        this.setModuleId(moduleId);
    }

    public void init(int contractId, int moduleId, int objectId) {
        this.objectId = objectId;
        this.init(contractId, moduleId);
    }

    @Override
    public ClientContext getContext() {
        if (this.context == null) {
            ClientContext parentContext = super.getContext();
            this.context = new ClientContext(this.module, this.getModuleId(), this.getContractId(), this.rb_name);
            this.context.setCustomer(parentContext.getCustomer());
            this.context.setCustomerId(parentContext.getCustomerId());
        }
        return this.context;
    }

    protected void initServiceSubPanel(JTabbedPane jTabbedPane, int id) {
        this.initServiceSubPanel(jTabbedPane, String.valueOf(id));
    }

    protected void initServiceSubPanel(JTabbedPane jTabbedPane, String id) {
        ServicePanel panel = null;
        for (int i = 0; i < jTabbedPane.getComponentCount(); ++i) {
            panel = (ServicePanel)jTabbedPane.getComponentAt(i);
            if (!(panel instanceof ServicePanel)) continue;
            ServicePanel sp = panel;
            sp.init(this.getContractId(), this.getModuleId(), this.objectId);
            sp.setId(id);
            sp.setData();
        }
    }

    protected void setTabbedPanel() {
        this.setTabbedPanel("module.contract.tab");
    }

    protected void setTabbedPanel(String pref) {
        this.editorsTabbedPane = new JTabbedPane();
        this.cardLayout1 = new CardLayout();
        String moduleTab = ClientUtils.getValueFromResourceBundle(this.rb_name, pref);
        if (moduleTab != null) {
            for (String tabIndex : moduleTab.split(" ")) {
                this.addTab(pref, tabIndex);
            }
        } else {
            if (pref.endsWith(".")) {
                pref = pref.substring(0, pref.length() - 1);
            }
            int i = 1;
            while (this.addTab(pref, String.valueOf(i++))) {
            }
        }
    }

    private boolean addTab(String pref, String tabIndex) {
        boolean flag = false;
        String prefix = pref + "." + tabIndex + ".";
        try {
            String title = ClientUtils.getValueFromResourceBundle(this.rb_name, prefix.concat("title"));
            String className = ClientUtils.getValueFromResourceBundle(this.rb_name, prefix.concat("class"));
            if (title != null && className != null) {
                Class<?> clazz = Class.forName(className);
                JPanel panel = (JPanel)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.editorsTabbedPane.add((Component)panel, title);
                if (panel instanceof BGUPanel) {
                    ((ClientContext)((BGUPanel)panel).getContext()).setObjectId(ClientContext.get().getObjectId());
                }
                flag = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    public void initModuleToollBar(BGDialogToolBar toolBar) {
        toolBar.removeAll();
    }

    protected void buildObjectCombo(JComboBox<ComboBoxItem> object_CB, boolean showAll, String selected) {
        if (Utils.isBlankString(selected)) {
            selected = "0";
        }
        Request req = new Request();
        req.setModule("contract.object");
        req.setAction("ContractObjectList");
        req.setAttribute("showAll", showAll);
        req.setAttribute("currentObjectId", selected);
        req.setContractId(this.getContractId());
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus(doc)) {
            ClientUtils.buildComboBox(object_CB, XMLUtils.selectElement(doc, "/data/list"), "");
        }
        object_CB.insertItemAt(new ComboBoxItem("0", "-----"), 0);
        if (this.objectId > 0) {
            ClientUtils.setComboBoxSelection(object_CB, String.valueOf(this.objectId));
            object_CB.setEnabled(false);
        } else {
            ClientUtils.setComboBoxSelection(object_CB, selected);
            object_CB.setEnabled(true);
        }
    }

    protected void showMessageDialog() {
        ClientUtils.showErrorMessageDialog("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430. \u041d\u0435 \u0437\u0430\u043a\u0440\u044b\u0442 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440.");
    }

    public final boolean isAllowedServiceAvaliable() {
        return ServicePanel.isAllowedServiceAvaliable(this.getClass());
    }

    public static boolean isAllowedServiceAvaliable(Class<?> clazz) {
        Boolean b;
        String isAvaliable;
        Element serviceAvaliable;
        Document mDoc;
        boolean isAval = false;
        if (clazz != null && (mDoc = ClientUtils.getModuleDoc(clazz)) != null && (serviceAvaliable = XMLUtils.getElement(mDoc, "AllowedServiceAvaliable")) != null && (isAvaliable = serviceAvaliable.getAttribute("value")) != null && (b = Boolean.valueOf(Utils.parseBoolean(isAvaliable))) != null) {
            isAval = b;
        }
        return isAval;
    }

    public boolean updateData() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            for (int i = 0; i < this.editorsTabbedPane.getTabCount(); ++i) {
                ((ServicePanel)this.editorsTabbedPane.getComponentAt(i)).setData();
            }
        } else if ("ok".equals(actionCommand)) {
            for (int i = 0; i < this.editorsTabbedPane.getTabCount(); ++i) {
                Component comp = this.editorsTabbedPane.getComponentAt(i);
                if (((ServicePanel)comp).updateData()) continue;
                return;
            }
            this.setData();
            this.cardLayout1.show(this, "table");
        } else if ("cancel".equals(actionCommand)) {
            this.cardLayout1.show(this, "table");
        } else if ("help".equals(actionCommand)) {
            this.openHelp(ServicePropertiesPanel.class.getName());
        } else {
            super.actionPerformed(e);
        }
    }

    protected void initServiceSubPanel(JTabbedPane jTabbedPane) {
        Component panel = null;
        for (int i = 0; i < jTabbedPane.getComponentCount(); ++i) {
            panel = jTabbedPane.getComponentAt(i);
            if (!(panel instanceof ServicePanel)) continue;
            ((ServicePanel)panel).init(this.getContractId(), this.getModuleId(), this.objectId);
        }
    }

    protected void setId(JTabbedPane jTabbedPane, String id) {
        Component panel = null;
        for (int i = 0; i < jTabbedPane.getComponentCount(); ++i) {
            panel = jTabbedPane.getComponentAt(i);
            if (!(panel instanceof ServicePanel)) continue;
            ((ServicePanel)panel).setId(id);
        }
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    protected void setParams(JTabbedPane jTabbedPane, Map<String, Object> params) {
        Component panel = null;
        for (int i = 0; i < jTabbedPane.getComponentCount(); ++i) {
            panel = jTabbedPane.getComponentAt(i);
            if (!(panel instanceof ServicePanel)) continue;
            ((ServicePanel)panel).setParams(params);
        }
    }
}

