/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.json.JSONObject;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public class BGControlPanelPages
extends JPanel
implements PropertyChangeListener,
PopupMenuListener {
    private int pageIndex = 1;
    private int pageIndexOld = 1;
    private int pageCount = 1;
    private int pageSize = 25;
    private int pageSizeOld = 25;
    private String key = null;
    private boolean readConfig = true;
    private ClientSetup setupData = ClientSetup.getInstance();
    private BGTextField textField = new BGTextField(10);
    private BGButton toFirstButton = new BGButton();
    private BGButton toPrevButton = new BGButton();
    private BGButton toNextButton = new BGButton();
    private BGButton toLastButton = new BGButton();
    private static final Popup popup;

    public BGControlPanelPages() {
        this((String)null);
    }

    public BGControlPanelPages(String key) {
        this.key = key;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.textField.setFocusable(false);
        this.textField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BGControlPanelPages.this.setPopupVisible(true);
            }
        });
        this.init();
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent event) {
                if (event.getID() == 1400 && (event.getChangeFlags() & 1L) > 0L && event.getChanged() instanceof BGPanel && BGControlPanelPages.this.setupData == null) {
                    BGControlPanelPages.this.setupData = ((BGPanel)event.getChanged()).getSetup();
                    BGControlPanelPages.this.setText();
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.textField.setEditable(false);
        this.textField.setHorizontalAlignment(0);
        this.toFirstButton.setIcon(ClientUtils.getIcon("to_first.gif"));
        this.toFirstButton.setMargin(new Insets(0, 2, 0, 2));
        this.toFirstButton.setToolTipText("\u041d\u0430 \u043f\u0435\u0440\u0432\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 (Ctrl+Alt+PageUp)");
        this.toFirstButton.addActionListener(actionEvent -> this.toFirstButton_actionPerformed(actionEvent));
        this.toPrevButton.setIcon(ClientUtils.getIcon("to_prev.gif"));
        this.toPrevButton.setMargin(new Insets(0, 2, 0, 2));
        this.toPrevButton.setToolTipText("\u041d\u0430 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 (Alt+PageUp)");
        this.toPrevButton.addActionListener(actionEvent -> this.toPrevButton_actionPerformed(actionEvent));
        this.toNextButton.setIcon(ClientUtils.getIcon("to_next.gif"));
        this.toNextButton.setMargin(new Insets(0, 2, 0, 2));
        this.toNextButton.setToolTipText("\u041d\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 (Alt+PageDown)");
        this.toNextButton.addActionListener(actionEvent -> this.toNextButton_actionPerformed(actionEvent));
        this.toLastButton.setIcon(ClientUtils.getIcon("to_last.gif"));
        this.toLastButton.setMargin(new Insets(0, 2, 0, 2));
        this.toLastButton.setToolTipText("\u041d\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 (Ctrl+Alt+PageDown)");
        this.toLastButton.addActionListener(actionEvent -> this.toLastButton_actionPerformed(actionEvent));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.toFirstButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.toPrevButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.textField, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.toNextButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.toLastButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setText() {
        this.textField.setText(this.getPageIndex() + " \u0438\u0437 " + this.getPageCount() + " [" + this.getPageSize() + "]");
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
        this.setText();
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
        this.setText();
    }

    public void setPageCount(Element element) {
        this.setPageCount(Page.getPageCount(element));
    }

    void toFirstButton_actionPerformed(ActionEvent actionEvent) {
        int oldValue = this.getPageIndex();
        this.setPageIndex(1);
        this.firePropertyChange("toFirst", oldValue, this.getPageIndex());
    }

    void toPrevButton_actionPerformed(ActionEvent actionEvent) {
        int oldValue = this.getPageIndex();
        if (this.getPageIndex() > 1) {
            this.setPageIndex(this.getPageIndex() - 1);
        }
        this.firePropertyChange("toPrev", oldValue, this.getPageIndex());
    }

    void toNextButton_actionPerformed(ActionEvent actionEvent) {
        int oldValue = this.getPageIndex();
        if (this.getPageIndex() < this.getPageCount()) {
            this.setPageIndex(this.getPageIndex() + 1);
        }
        this.firePropertyChange("toNext", oldValue, this.getPageIndex());
    }

    void toLastButton_actionPerformed(ActionEvent actionEvent) {
        int oldValue = this.getPageIndex();
        this.setPageIndex(this.getPageCount());
        this.firePropertyChange("toLast", oldValue, this.getPageIndex());
    }

    public int getPageSize() {
        if (this.setupData != null && this.readConfig && this.getKey() != null) {
            Preferences prefs = this.setupData.getUserConfig();
            this.pageSize = prefs.getInt("page.size." + this.getKey(), 25);
            this.readConfig = false;
        }
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (this.pageSize != pageSize) {
            this.pageIndex = 1;
        }
        this.pageSize = pageSize;
        if (this.setupData != null && this.getKey() != null) {
            Preferences prefs = this.setupData.getUserConfig();
            prefs.set("page.size." + this.getKey(), String.valueOf(pageSize));
            this.setupData.saveUserConfig();
        }
        this.setText();
    }

    public void init() {
        this.setPageIndex(1);
        this.setPageCount(1);
        ActionMap actionMap = this.getActionMap();
        actionMap.put("toFirstPage", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGControlPanelPages.this.toFirstButton_actionPerformed(actionEvent);
            }
        });
        actionMap.put("toPrevPage", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGControlPanelPages.this.toPrevButton_actionPerformed(actionEvent);
            }
        });
        actionMap.put("toNextPage", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGControlPanelPages.this.toNextButton_actionPerformed(actionEvent);
            }
        });
        actionMap.put("toLastPage", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGControlPanelPages.this.toLastButton_actionPerformed(actionEvent);
            }
        });
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(33, 640), "toFirstPage");
        inputMap.put(KeyStroke.getKeyStroke(33, 512), "toPrevPage");
        inputMap.put(KeyStroke.getKeyStroke(34, 512), "toNextPage");
        inputMap.put(KeyStroke.getKeyStroke(34, 640), "toLastPage");
    }

    public void setPopupVisible(boolean visible) {
        if (visible) {
            this.pageIndexOld = this.getPageIndex();
            this.pageSizeOld = this.getPageSize();
            BGControlPanelPages.popup.pageSetPanel.setPageIndex(this.pageIndexOld);
            BGControlPanelPages.popup.pageSetPanel.setPageSize(this.pageSizeOld);
            BGControlPanelPages.popup.pageSetPanel.addPropertyChangeListener(this);
            popup.addPopupMenuListener(this);
            popup.show(this, 0, this.getHeight() + 1);
        } else {
            popup.setVisible(false);
        }
    }

    public String getKey() {
        if (this.key == null || this.key.isEmpty()) {
            boolean flag = false;
            StringBuffer buf = new StringBuffer();
            for (Container container = this.getParent(); container != null; container = container.getParent()) {
                if (buf.length() > 0) {
                    buf.append("_");
                }
                buf.append(container.getClass().getName());
                flag = true;
            }
            if (flag) {
                this.key = Utils.getDigest(buf.toString(), "UTF-8");
            }
        }
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setPageInfo(JSONObject page) {
        int serverPageIndex = page.optInt("pageIndex", 1);
        int serverPageCount = page.optInt("pageCount", 1);
        if (serverPageIndex > 0) {
            this.setPageIndex(serverPageIndex);
        }
        if (serverPageCount > 0) {
            this.setPageCount(serverPageCount);
        }
    }

    public void setPageInfo(Element element) {
        if (element != null) {
            int serverPageIndex = Page.getPageIndex(element);
            int serverPageCount = Page.getPageCount(element);
            if (serverPageIndex > 0) {
                this.setPageIndex(serverPageIndex);
            }
            if (serverPageCount > 0) {
                this.setPageCount(serverPageCount);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("pageSet".equals(propertyName)) {
            this.setPopupVisible(false);
            this.setPageIndex(Math.min(BGControlPanelPages.popup.pageSetPanel.getPageIndex(), this.getPageCount()));
            this.setPageSize(BGControlPanelPages.popup.pageSetPanel.getPageSize());
            if (this.getPageSize() != this.pageSizeOld) {
                this.firePropertyChange("toSize", this.pageSizeOld, this.getPageSize());
            }
            if (this.getPageIndex() != this.pageIndexOld) {
                this.firePropertyChange("toPage", this.pageIndexOld, this.getPageIndex());
            }
        }
    }

    @Override
    public void addPropertyChangeListener(final PropertyChangeListener listener) {
        super.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name != null && name.startsWith("to")) {
                    listener.propertyChange(evt);
                }
            }
        });
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        BGControlPanelPages.popup.pageSetPanel.removePropertyChangeListener(this);
        popup.removePopupMenuListener(this);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public Page getPage() {
        return new Page(this.getPageIndex(), this.getPageSize());
    }

    public void setPage(Page page) {
        this.setPageIndex(page.getPageIndex());
        this.setPageSize(page.getPageSize());
        this.setPageCount(page.getPageCount());
    }

    @Override
    public void setBorder(Border border) {
        if (border instanceof TitledBorder) {
            super.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        } else {
            super.setBorder(border);
        }
    }

    static {
        Popup cp = null;
        try {
            cp = new Popup();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        popup = cp;
    }

    private static class Popup
    extends JPopupMenu {
        private PageSetPanel pageSetPanel = new PageSetPanel();

        public Popup() {
            try {
                this.setLayout(new BorderLayout());
                this.add("Center", this.pageSetPanel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class PageSetPanel
    extends JPanel {
        private int pageIndex = 1;
        private int pageSize = 25;
        private boolean newSize = true;
        private boolean newIndex = true;
        private JTextField pageSizeField = new JTextField(5);
        private JTextField pageIndexField = new JTextField(5);
        private JButton okButton = new BGButton("Ok");
        private JToggleButton modeButton = new JToggleButton(ClientUtils.getIcon("numpad.png"));

        public PageSetPanel() {
            try {
                this.jbInit();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            this.okButton.addActionListener(e -> this.firePropertyChange("pageSet", false, true));
        }

        private void jbInit() throws Exception {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.getSizePanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.getIndexPanel(), new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        }

        private JPanel getSizePanel() {
            JPanel panel = new JPanel();
            JLabel pageSizeLabel = new JLabel("\u0420\u0430\u0437\u043c\u0435\u0440");
            String[] pageSizes = new String[]{"10", "15", "20", "25", "30", "50", "100"};
            ActionListener actionListener = actionEvent -> {
                String actionCommand = actionEvent.getActionCommand();
                this.pageSizeField.setText(actionCommand);
                this.newSize = true;
                this.newIndex = true;
            };
            panel.setLayout(new GridBagLayout());
            panel.add((Component)pageSizeLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.pageSizeField.setEnabled(false);
            this.pageSizeField.setForeground(Color.black);
            this.pageSizeField.setHorizontalAlignment(0);
            this.pageSizeField.setPreferredSize(this.okButton.getPreferredSize());
            panel.add((Component)this.pageSizeField, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            for (int index = 0; index < pageSizes.length; ++index) {
                int x = index % 2;
                int y = 2 + index / 2;
                BGButton button = new BGButton(pageSizes[index], pageSizes[index], actionListener);
                panel.add((Component)button, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            panel.add((Component)this.modeButton, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getIndexPanel() {
            BGButton button = null;
            JPanel panel = new JPanel(new GridBagLayout());
            JLabel pageIndexLabel = new JLabel("\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430");
            String[] pageIndexes = new String[]{"7", "8", "9", "4", "5", "6", "1", "2", "3"};
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String actionCommand = actionEvent.getActionCommand();
                    JTextField pageField = null;
                    pageField = modeButton.isSelected() ? pageSizeField : pageIndexField;
                    if ("0123456789".indexOf(actionCommand) > -1) {
                        String value = pageField.getText();
                        if (modeButton.isSelected()) {
                            if (newSize) {
                                pageField.setText(actionCommand);
                                newIndex = true;
                                newSize = false;
                            } else if (value == null || value.length() > 2 || value.length() == 0 && "0".equals(actionCommand)) {
                                Toolkit.getDefaultToolkit().beep();
                            } else {
                                pageField.setText(value + actionCommand);
                            }
                        } else if (newIndex) {
                            pageField.setText(actionCommand);
                            newIndex = false;
                            newSize = true;
                        } else if (value == null || value.length() > 4 || value.length() == 0 && "0".equals(actionCommand)) {
                            Toolkit.getDefaultToolkit().beep();
                        } else {
                            pageField.setText(value + actionCommand);
                        }
                    } else {
                        pageField.setText("");
                    }
                }
            };
            panel.add((Component)pageIndexLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.pageIndexField.setEnabled(false);
            this.pageIndexField.setForeground(Color.black);
            this.pageIndexField.setHorizontalAlignment(0);
            panel.add((Component)this.pageIndexField, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.okButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            for (int index = 0; index < pageIndexes.length; ++index) {
                int x = index % 3;
                int y = 2 + index / 3;
                button = new BGButton(pageIndexes[index], pageIndexes[index], actionListener);
                panel.add((Component)button, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            button = new BGButton("0", "0", actionListener);
            panel.add((Component)button, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            button = new BGButton("C", "C", actionListener);
            panel.add((Component)button, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        public int getPageIndex() {
            int result = this.pageIndex;
            try {
                result = Integer.parseInt(this.pageIndexField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return result;
        }

        public void setPageIndex(int pageIndex) {
            this.pageIndex = pageIndex;
            this.pageIndexField.setText(String.valueOf(pageIndex));
        }

        public int getPageSize() {
            int result = this.pageSize;
            try {
                result = Integer.parseInt(this.pageSizeField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return result;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
            this.pageSizeField.setText(String.valueOf(pageSize));
        }
    }
}

