/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.directory.address;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.ListItem;
import bitel.billing.module.contract.AddressEditor;
import bitel.billing.module.contract.object.table.ContractObjectAddressEditor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.concurrent.Future;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.table.BGTableModel;

public class DirectoryNewAddressEditorTab
extends AbstractBGUPanel<ClientContext, BGUPanel> {
    String selected;
    String whoseParam = "contract";
    private JPopupMenu popupMenu = null;
    JLabel recordCountLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: 0");
    BGTableModel<String[][]> tableModel;
    CardLayout addressEditorLayout;
    JPanel addressEditorPanel;
    JPanel addressEditorsPanel;
    JList<ListItem> objectAddressParamList;
    JList<ListItem> contractAddressParamList;
    BGButtonPanelRestoreOkCancelHelp okCancelPanel;
    AddressEditor contractAddressEditor;
    ContractObjectAddressEditor objectAddressEditor;
    BGControlPanelPages pagePanel = new BGControlPanelPages();

    @Override
    protected void build() {
        super.build();
        this.setDataToAddressCustom();
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                DirectoryNewAddressEditorTab.this.build();
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (DirectoryNewAddressEditorTab.this.tableModel.getSelectedRow() == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
                    return;
                }
                if (DirectoryNewAddressEditorTab.this.whoseParam.equals("contract")) {
                    int c = Integer.valueOf(DirectoryNewAddressEditorTab.this.tableModel.getValueFromSelectedRow("cid"));
                    DirectoryNewAddressEditorTab.this.contractAddressEditor.setId(DirectoryNewAddressEditorTab.this.tableModel.getValueFromSelectedRow("pid"));
                    DirectoryNewAddressEditorTab.this.contractAddressEditor.setContractId(c);
                    DirectoryNewAddressEditorTab.this.contractAddressEditor.setAddressCustomFlag(false);
                    DirectoryNewAddressEditorTab.this.contractAddressEditor.setData();
                    DirectoryNewAddressEditorTab.this.addressEditorLayout.show(DirectoryNewAddressEditorTab.this.addressEditorsPanel, "contract");
                    DirectoryNewAddressEditorTab.this.addressEditorPanel.setVisible(true);
                } else if (DirectoryNewAddressEditorTab.this.whoseParam.equals("object")) {
                    DirectoryNewAddressEditorTab.this.objectAddressEditor.setId(DirectoryNewAddressEditorTab.this.tableModel.getValueFromSelectedRow("pid"));
                    DirectoryNewAddressEditorTab.this.objectAddressEditor.setObjectId(DirectoryNewAddressEditorTab.this.tableModel.getValueFromSelectedRow("objectId"));
                    DirectoryNewAddressEditorTab.this.objectAddressEditor.setAddressCustomFlag(false);
                    DirectoryNewAddressEditorTab.this.objectAddressEditor.setData();
                    DirectoryNewAddressEditorTab.this.addressEditorLayout.show(DirectoryNewAddressEditorTab.this.addressEditorsPanel, "object");
                    DirectoryNewAddressEditorTab.this.addressEditorPanel.setVisible(true);
                }
            }
        };
    }

    @Override
    protected Future<BGUPanel> buildAsync() {
        return null;
    }

    @Override
    protected void jbInit() throws Exception {
        this.okCancelPanel = new BGButtonPanelRestoreOkCancelHelp();
        this.okCancelPanel.addActionListener(actionEvent -> this.okCancel2_actionPerformed(actionEvent));
        this.contractAddressEditor = new AddressEditor();
        this.contractAddressEditor.setOkButton(this.okCancelPanel.getButtonOK());
        this.contractAddressEditor.initAsync(((ClientContext)this.getContext()).getModule(), 0);
        this.objectAddressEditor = new ContractObjectAddressEditor();
        this.objectAddressEditor.setOkButton(this.okCancelPanel.getButtonOK());
        this.objectAddressEditor.initAsync(((ClientContext)this.getContext()).getModule(), 0);
        this.addressEditorLayout = new CardLayout();
        this.addressEditorsPanel = new JPanel(this.addressEditorLayout);
        this.addressEditorsPanel.add((Component)this.contractAddressEditor, "contract");
        this.addressEditorsPanel.add((Component)this.objectAddressEditor, "object");
        this.addressEditorPanel = new JPanel(new GridBagLayout());
        this.addressEditorPanel.setVisible(false);
        this.addressEditorPanel.add((Component)this.addressEditorsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.addressEditorPanel.add((Component)this.okCancelPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, this.getAddressParams(), (Component)this.getAddressCustomPanel(), 200L), "Center");
    }

    private JPanel getAddressParams() {
        this.contractAddressParamList = new JList();
        this.contractAddressParamList.setSelectionMode(0);
        this.contractAddressParamList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    DirectoryNewAddressEditorTab.this.objectAddressParamList.removeSelectionInterval(0, 100);
                    DirectoryNewAddressEditorTab.this.whoseParam = "contract";
                    DirectoryNewAddressEditorTab.this.showAddressCustom();
                }
            }
        });
        this.objectAddressParamList = new JList();
        this.objectAddressParamList.setSelectionMode(0);
        this.objectAddressParamList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    DirectoryNewAddressEditorTab.this.contractAddressParamList.removeSelectionInterval(0, DirectoryNewAddressEditorTab.this.contractAddressParamList.getModel().getSize());
                    DirectoryNewAddressEditorTab.this.whoseParam = "object";
                    DirectoryNewAddressEditorTab.this.showAddressCustom();
                }
            }
        });
        JPanel addressParams = new JPanel(new GridBagLayout());
        addressParams.setBorder(new BGTitleBorder("\u0410\u0434\u0440\u0435\u0441\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b"));
        addressParams.add((Component)new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        addressParams.add((Component)new JScrollPane(this.contractAddressParamList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 0, 5), 0, 0));
        addressParams.add((Component)new JLabel("\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        addressParams.add((Component)new JScrollPane(this.objectAddressParamList), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        return addressParams;
    }

    private JPanel getAddressCustomPanel() {
        this.tableModel = new BGTableModel<String[][]>("address"){

            @Override
            protected void initColumns() {
                this.addColumn("", 0, 0, 0, "cid");
                this.addColumn("", 0, 0, 0, "objectId");
                this.addColumn("", 0, 0, 0, "pid");
                this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 (\u041e\u0431\u044a\u0435\u043a\u0442)", 100, 150, 200, "title").setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
                this.addColumn("\u0410\u0434\u0440\u0435\u0441", 0, -1, -1, "address").setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 0, -1, -1, "comment").setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            }
        };
        final BGUTable addressTable = new BGUTable(this.tableModel);
        addressTable.setSelectionMode(0);
        addressTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    DirectoryNewAddressEditorTab.this.performAction("edit");
                } else if (DirectoryNewAddressEditorTab.this.getPopupMenu() != null && SwingUtilities.isRightMouseButton(event) && addressTable.getSelectedRow() == addressTable.rowAtPoint(event.getPoint())) {
                    DirectoryNewAddressEditorTab.this.getPopupMenu().show(addressTable, event.getX(), event.getY());
                }
            }
        });
        this.pagePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().startsWith("to")) {
                    DirectoryNewAddressEditorTab.this.showAddressCustom();
                }
            }
        });
        JPanel addressCustomTablePanel = new JPanel(new GridBagLayout());
        addressCustomTablePanel.add((Component)new JScrollPane(addressTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)new JLabel("\u041d\u043e\u0432\u044b\u0435 \u0430\u0434\u0440\u0435\u0441\u0430:"){
            {
                this.setFont(new Font("Dialog", 1, 18));
            }
        }, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.recordCountLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 20), 0, 0));
        topPanel.add((Component)this.pagePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 13, new Insets(0, 0, 0, 0), 0, 0));
        JPanel addressCustomPanel = new JPanel(new GridBagLayout());
        addressCustomPanel.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        addressCustomPanel.add((Component)addressCustomTablePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        addressCustomPanel.add((Component)this.addressEditorPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return addressCustomPanel;
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(new JMenuItem("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440"){
                {
                    this.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            String[][] selectedRow = DirectoryNewAddressEditorTab.this.tableModel.getSelectedRow();
                            if (selectedRow != null && selectedRow instanceof String[][]) {
                                String[][] rowData;
                                for (String[] cellData : rowData = selectedRow) {
                                    int contractId;
                                    if (cellData == null || cellData.length <= 1 || !"cid".equals(cellData[0]) || (contractId = Utils.parseInt(cellData[1], 0)) <= 0) continue;
                                    BGClientBase.getFrame().getTabbedPane().addContractEditorTab(contractId);
                                }
                            }
                        }
                    });
                }
            });
        }
        return this.popupMenu;
    }

    private void showAddressCustom() {
        ListItem item = null;
        if (this.whoseParam.equals("contract")) {
            item = this.contractAddressParamList.getSelectedValue();
        } else if (this.whoseParam.equals("object")) {
            item = this.objectAddressParamList.getSelectedValue();
        }
        if (item != null) {
            Request request = new Request();
            request.setModule(((ClientContext)this.getContext()).getModule());
            request.setAction("AddressCustomEditor");
            request.setPage(this.pagePanel);
            request.setAttribute("pid", item.getAttribute("id"));
            request.setAttribute("whoseParam", this.whoseParam);
            this.selected = item.getAttribute("id").toString();
            Document doc = TransferManager.getDocument(request);
            ClientUtils.checkStatus(doc);
            if (ClientUtils.checkStatus(doc)) {
                Element tableElement = XMLUtils.selectElement(doc, "/data/table");
                ArrayList<String[][]> rows = new ArrayList<String[][]>();
                for (Element rowElement : XMLUtils.selectElements(tableElement, "//data/row")) {
                    String[][] data = new String[][]{{"address", rowElement.getAttribute("address")}, {"cid", rowElement.getAttribute("contractId")}, {"pid", rowElement.getAttribute("parameterId")}, {"comment", rowElement.getAttribute("comment")}, {"title", rowElement.getAttribute("title")}, {"objectId", rowElement.getAttribute("objectId")}};
                    rows.add(data);
                }
                this.tableModel.setData(rows);
                this.pagePanel.setPageInfo(tableElement);
                this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + tableElement.getAttribute("recordCount"));
            }
        }
    }

    private void okCancel2_actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if ("ok".equals(actionCommand)) {
            if (this.whoseParam.equals("contract")) {
                if (this.contractAddressEditor.updateData()) {
                    this.addressEditorPanel.setVisible(false);
                    this.showAddressCustom();
                }
            } else if (this.whoseParam.equals("object") && this.objectAddressEditor.updateData()) {
                this.addressEditorPanel.setVisible(false);
                this.showAddressCustom();
            }
        } else if ("cancel".equals(actionCommand)) {
            this.addressEditorPanel.setVisible(false);
        }
    }

    private void setDataToAddressCustom() {
        Request request = new Request();
        request.setModule(((ClientContext)this.getContext()).getModule());
        request.setAction("AddressCustomInit");
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            ClientUtils.buildList(this.contractAddressParamList, (Node)XMLUtils.selectElement(doc, "//params/contract_address"), this.selected);
            ClientUtils.buildList(this.objectAddressParamList, (Node)XMLUtils.selectElement(doc, "//params/object_address"), this.selected);
        }
    }
}

