/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server;

import bitel.billing.server.ApplicationModule;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.io.Base64;

public abstract class CommonExecutor
extends HttpServlet {
    protected static final Logger logger = LogManager.getLogger();
    public static final String TRANSFORMER_PARAMETERS = "bitel.billing.server.transformer.parameters";
    protected Setup setup;
    protected ServletContext servletContext;
    protected final XSLManager xslManager = XSLManager.getInstance();
    protected final String CHARSET = "UTF-8";

    protected CommonExecutor() {
    }

    public void init() throws ServletException {
        super.init();
        this.setup = Setup.getSetup();
        for (Annotation annotation : ((Object)((Object)this)).getClass().getAnnotations()) {
            if (!annotation.annotationType().equals(WebServlet.class)) continue;
            WebServlet webServlet = (WebServlet)annotation;
            StringBuilder urlPatterns = new StringBuilder("[");
            for (String urlPattern : webServlet.urlPatterns()) {
                if (urlPatterns.length() > 1) {
                    urlPatterns.append("; ");
                }
                urlPatterns.append(urlPattern);
            }
            urlPatterns.append("]");
            logger.info("Add mapping: " + ((Object)((Object)this)).getClass().getName() + " to " + urlPatterns.toString());
        }
    }

    protected Class<?> findAction(String module, String mode, String className) {
        Class<?> action;
        block27: {
            action = null;
            try {
                ApplicationModule am;
                String[] packs;
                String dynaction = this.setup.get("dynaction:" + module + "." + mode + className);
                if (dynaction != null) {
                    logger.info(String.format("load dynaction class for /%s/%s/%s: %s...", module, mode, className, dynaction));
                    action = DynamicClassManager.getInstance().loadClass(dynaction);
                    return action;
                }
                Map modulesMap = (Map)this.getServletContext().getAttribute("installed_modules_map");
                String modulePackServer = (String)modulesMap.get(module);
                if (modulePackServer == null) {
                    BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin(module);
                    if (plugin != null) {
                        modulePackServer = plugin.getPackServer();
                    }
                    if ((plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins." + module)) != null) {
                        modulePackServer = plugin.getPackServer();
                    }
                }
                if (modulePackServer != null) {
                    try {
                        action = Class.forName(modulePackServer + ".action." + mode + className);
                    }
                    catch (Exception plugin) {
                        // empty catch block
                    }
                }
                if (action == null) {
                    try {
                        action = Class.forName("bitel.billing.server." + module + ".action." + mode + className);
                    }
                    catch (Exception plugin) {
                        // empty catch block
                    }
                }
                if (action == null) {
                    try {
                        action = Class.forName("ru.bitel.bgbilling.modules." + module + ".server.action." + mode + className);
                    }
                    catch (Exception plugin) {
                        // empty catch block
                    }
                }
                if (action == null) {
                    try {
                        action = Class.forName("ru.bitel.bgbilling.modules." + module + ".api.server.action." + mode + className);
                    }
                    catch (Exception plugin) {
                        // empty catch block
                    }
                }
                if (action == null) {
                    try {
                        action = Class.forName(module + ".server.action." + mode + className);
                    }
                    catch (Exception plugin) {
                        // empty catch block
                    }
                }
                if (action == null) {
                    try {
                        action = Class.forName("ru.bitel.bgbilling.kernel." + module + ".server.action." + mode + className);
                    }
                    catch (Exception plugin) {
                        // empty catch block
                    }
                }
                if (action != null || modulePackServer == null || (packs = (am = Utils.newInstance(modulePackServer + ".Module", ApplicationModule.class)).getServerPackages()) == null) break block27;
                for (String pack : packs) {
                    try {
                        action = Class.forName(pack + ".action." + mode + className);
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return action;
    }

    protected void getLoginAndPassword(HttpServletRequest request) {
        String value;
        String unencoded;
        int colon;
        String userName = null;
        String userPswd = null;
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.startsWith("Basic ") && (colon = (unencoded = Base64.decode(authorization = authorization.substring(6).trim(), "UTF-8")).indexOf(58)) > 0) {
            try {
                userName = unencoded.substring(0, colon);
                userPswd = unencoded.substring(colon + 1);
            }
            catch (Exception ex) {
                userName = null;
                userPswd = null;
                ex.printStackTrace();
            }
        }
        if (userName == null && (value = request.getParameter("user")) != null) {
            userName = value;
        }
        if (userPswd == null && (value = request.getParameter("pswd")) != null) {
            userPswd = value;
        }
        if (userName != null) {
            request.setAttribute("userName", (Object)userName);
        }
        if (userPswd != null) {
            request.setAttribute("userPswd", (Object)userPswd);
        }
    }

    protected static void setErrorStatus(HttpServletRequest request, Element rootNode, String msg) {
        if (msg == null) {
            msg = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 ...";
        }
        String errcode = String.valueOf((long)msg.hashCode() & 0xFFFFFFFFL);
        rootNode.setAttribute("status", "error");
        rootNode.setAttribute("errcode", errcode);
        XMLUtils.createTextNode(rootNode, msg);
        request.setAttribute("errorStatus", (Object)new Object[]{errcode, msg});
        try {
            HttpServletResponse response = (HttpServletResponse)request.getAttribute("response");
            if (response != null) {
                response.setHeader("bgbilling-error", Base64.encode(msg, "UTF-8"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void rememberBackUrl(HttpServletRequest request) {
        String backUrl = request.getParameter("backUrl");
        if (!Utils.isEmptyString(backUrl)) {
            request.getSession().setAttribute("backUrl", (Object)backUrl);
        }
    }

    protected static String getRequestParameters(String defaultStr, HttpServletRequest request, String ... params) {
        String param;
        String result = null;
        String[] stringArray = params;
        int n = stringArray.length;
        for (int i = 0; i < n && (result = request.getParameter(param = stringArray[i])) == null; ++i) {
        }
        return result == null ? defaultStr : result;
    }

    protected static String getQueryString(HttpServletRequest request, boolean logUserPassword) {
        StringBuffer txt = new StringBuffer();
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (!logUserPassword && ("user".equals(name) || "pswd".equals(name))) continue;
            txt.append(name).append(" => ").append(request.getParameter(name)).append("\n");
        }
        return txt.toString();
    }

    protected void sendXmlWithXSLTInstuction(HttpServletRequest request, HttpServletResponse response, Document doc, String xsltFile) throws IOException, SAXException {
        StringBuilder xslt = new StringBuilder(60);
        if (request.isSecure()) {
            xslt.append(this.setup.getPathProperty("web.xslt.https", this.setup.getPathProperty("web.xslt", "http://127.0.0.1:8080/bgbilling/xsl/")));
        } else {
            xslt.append(this.setup.getPathProperty("web.xslt", "http://127.0.0.1:8080/bgbilling/xsl/"));
        }
        xslt.append(xsltFile);
        response.setContentType("text/xml; charset=UTF-8");
        PrintWriter out = response.getWriter();
        doc.getDocumentElement().insertBefore(doc.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + xslt + "\""), doc.getDocumentElement());
        XMLUtils.serialize(doc, new StreamResult(out), "UTF-8", true);
        out.flush();
        out.close();
    }

    protected static int getModuleId(HttpServletRequest request) throws BGMessageException {
        int moduleId = 0;
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            String[] params = Pattern.compile("/").split(pathInfo);
            switch (params.length) {
                default: {
                    moduleId = Utils.parseInt(params[1], 0);
                    break;
                }
                case 0: 
                case 1: {
                    moduleId = 0;
                    break;
                }
            }
        } else {
            moduleId = ModuleManager.getModuleIdByName(request.getServletPath().substring(1));
        }
        if (moduleId <= 0) {
            throw new BGMessageException("Invalid URL: 'moduleId' missing! [pathInfo = " + pathInfo + "]");
        }
        return moduleId;
    }

    protected boolean redirectByPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            String[] paths = pathInfo.split("/");
            StringBuilder path = new StringBuilder(request.getServletContext().getContextPath() + request.getServletPath());
            this.buildPath(path, 1, "?module=", paths);
            this.buildPath(path, 2, "&mid=", paths);
            this.buildPath(path, 3, "&action=", paths);
            this.buildPath(path, 4, "&operation=", paths);
            this.buildPath(path, 5, "&contractId=", paths);
            if (request.getQueryString() != null) {
                path.append("&").append(request.getQueryString());
            }
            response.sendRedirect(path.toString());
            return true;
        }
        return false;
    }

    protected void buildPath(StringBuilder path, int index, String name, String[] paths) {
        if (paths.length > index) {
            path.append(name).append(paths[index]);
        }
    }
}

