/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import bitel.billing.server.ApplicationModule;
import bitel.billing.server.contract.ContractRemover;
import bitel.billing.server.contract.bean.CommentPatternManager;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractModuleManager;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.contract.bean.ContractPatternManager;
import bitel.billing.server.contract.bean.PasswordManager;
import bitel.billing.server.contract.bean.PersonalTariff;
import bitel.billing.server.contract.bean.PersonalTariffManager;
import bitel.billing.server.util.MailMsg;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionChecker;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCard;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractFilters;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPasswordLogItem;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractDomainModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractPasswordChangedEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractPasswordLogDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractModuleConfigDao;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelItem;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.contract.plugin.PluginTreeNodeInterface;
import ru.bitel.bgbilling.kernel.contract.search.common.ContractHistoryRecord;
import ru.bitel.bgbilling.kernel.contract.search.server.ContractHistoryRecordDao;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractParamBeforeChangeEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractParamChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.GetContractCardsList;
import ru.bitel.bgbilling.kernel.event.events.ValidateTextParamEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService")
public class ContractServiceImpl
extends AbstractService
implements ContractService {
    protected static final Logger logger = LogManager.getLogger();
    private ContractDao contractDao;

    private ContractDao getDao() {
        if (this.contractDao == null) {
            this.contractDao = new ContractDao(this.getConnection(), this.userId);
        }
        return this.contractDao;
    }

    @PreDestroy
    private void destroy() {
        try {
            if (this.contractDao != null) {
                this.contractDao.close();
                this.contractDao = null;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Contract contractGet(int contractId) throws BGException {
        return (Contract)this.getDao().get(contractId);
    }

    @Override
    public Contract contractByTitle(String contractTitle) throws BGException, BGMessageException {
        return this.getDao().getByTitle(contractTitle);
    }

    @Override
    public void contractGroupRemove(int contractId, int contractGroupId) throws BGException {
        if (contractId < 0 || contractGroupId < 0) {
            return;
        }
        try {
            Directory<ContractGroup> contractGroupDir = this.context.getDirectory(ContractGroup.class, 0);
            ContractGroup contractGroup = contractGroupDir.get(contractGroupId);
            if (contractGroup == null) {
                throw new BGMessageException("\u0422\u0430\u043a\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            }
            if (!contractGroup.isEditable()) {
                throw new BGMessageException("\u0418\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e (\u043d\u0435\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430).");
            }
            ContractManager contractManager = new ContractManager(this.getConnection());
            contractManager.deleteContractGroup(contractId, (long)contractGroupId);
            contractManager.close();
            this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    @Override
    public void contractGroupAdd(int contractId, int contractGroupId) throws BGException {
        if (contractId < 0 || contractGroupId < 0) {
            return;
        }
        try {
            Directory<ContractGroup> contractGroupDir = this.context.getDirectory(ContractGroup.class, 0);
            ContractGroup contractGroup = contractGroupDir.get(contractGroupId);
            if (contractGroup == null) {
                throw new BGMessageException("\u0422\u0430\u043a\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            }
            if (!contractGroup.isEditable()) {
                throw new BGMessageException("\u0418\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e (\u043d\u0435\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430).");
            }
            ContractManager contractManager = new ContractManager(this.getConnection());
            contractManager.addContractGroup(contractId, contractGroupId);
            contractManager.close();
            this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    @Override
    public List<Contract> contractSubList(int contractId, int subMode, boolean withSuperCid) throws BGException {
        Contract contract = null;
        if (subMode == 0 || withSuperCid) {
            contract = (Contract)this.getDao().get(contractId);
        }
        List<Contract> list = subMode == 0 ? this.getDao().getContracts(contract.getDependSubList()) : this.getDao().getSubContracts(contractId, subMode);
        if (withSuperCid) {
            list.add(0, contract);
        }
        return list;
    }

    @Override
    public List<Contract> contractList0(int contractId, String title, String comment, int fc, Set<Integer> labelsIds, List<FilterEntityAttr> entityFilter, boolean subContracts, boolean closed, boolean hidden, Holder<Page> pageHolder) throws BGException {
        List<Contract> findedContracts;
        Page page;
        if (pageHolder == null || (page = (Page)pageHolder.value) == null) {
            page = new Page(1, 25);
        }
        if (title != null && comment != null) {
            findedContracts = this.getDao().list(this.getContractFilters(contractId, title, comment, fc, 0L, subContracts, closed, hidden), entityFilter, page, labelsIds);
        } else if (comment != null) {
            findedContracts = this.getDao().list(this.getContractFilters(contractId, null, comment, fc, 0L, subContracts, closed, hidden), entityFilter, page, labelsIds);
        } else if (title != null) {
            findedContracts = this.getDao().list(this.getContractFilters(contractId, title, null, fc, 0L, subContracts, closed, hidden), entityFilter, page, labelsIds);
            if (Utils.isEmptyCollection(findedContracts)) {
                findedContracts = this.getDao().list(this.getContractFilters(contractId, null, title, fc, 0L, subContracts, closed, hidden), entityFilter, page, labelsIds);
            }
        } else {
            findedContracts = this.getDao().list(this.getContractFilters(contractId, null, null, fc, 0L, subContracts, closed, hidden), entityFilter, page, labelsIds);
        }
        if (pageHolder != null) {
            pageHolder.value = page;
        }
        return findedContracts;
    }

    @Override
    public List<Contract> contractList(String title, String comment, int fc, long groupMask, List<FilterEntityAttr> entityFilter, boolean subContracts, boolean closed, boolean hidden, Holder<Page> pageHolder) throws BGException {
        HashSet<Integer> labelIds = new HashSet<Integer>(Utils.toIntegerList(Utils.maskToEnum(groupMask)));
        return this.contractList0(0, title, comment, fc, labelIds, entityFilter, subContracts, closed, hidden, pageHolder);
    }

    private ContractFilters getContractFilters(int contractId, String title, String comment, int fc, long groupMask, boolean subContracts, boolean closed, boolean hidden) {
        ContractFilters contractFilters = new ContractFilters();
        contractFilters.setId(contractId);
        contractFilters.setTitle(title);
        contractFilters.setComment(comment);
        contractFilters.setFc(fc);
        contractFilters.setGroupMask(groupMask);
        contractFilters.setSubContracts(subContracts);
        contractFilters.setClosed(closed);
        contractFilters.setHidden(hidden);
        return contractFilters;
    }

    @Override
    public void contractPasswordUpdate(int contractId, String password, boolean generate) throws BGException {
        if (contractId < 0) {
            throw new BGIllegalArgumentException();
        }
        if (generate) {
            password = PswdGen.generatePassword((ParameterMap)this.getSetup());
        } else {
            int passwordMin = PswdGen.getPasswordLengthMin((ParameterMap)this.getSetup());
            int passwordMax = PswdGen.getPasswordLengthMax((ParameterMap)this.getSetup());
            String passwordChars = PswdGen.getPasswordChars((ParameterMap)this.getSetup());
            if (Utils.isEmptyString(password)) {
                throw new BGMessageException("\u0414\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043e\u0442 " + passwordMin + " \u0434\u043e " + passwordMax + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432!");
            }
            if ((password = password.trim()).length() < passwordMin || password.length() > passwordMax) {
                throw new BGMessageException("\u0414\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043e\u0442 " + passwordMin + " \u0434\u043e " + passwordMax + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432!");
            }
            if (!PswdGen.checkChars((String)password, (String)passwordChars)) {
                throw new BGMessageException("\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0438\u0437 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432: " + passwordChars);
            }
        }
        this.getDao().updatePassword(contractId, password);
        this.context.publishAfterCommit(new ContractPasswordChangedEvent(this.userId, contractId, password));
        ContractPasswordLogItem item = new ContractPasswordLogItem();
        item.setDatetime(new Date());
        item.setContractId(contractId);
        item.setUserId(this.userId);
        try (ContractPasswordLogDao dao = new ContractPasswordLogDao(this.getConnection());){
            dao.addContractPasswordLogItem(item);
        }
    }

    @Override
    public void sendWebPasswordOfContractToEmail(String email, int cid) throws BGException {
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            Setup setup = Setup.getSetup();
            Contract contract = (Contract)contractDao.get(cid);
            String messageBody = "URL \u0441\u0435\u0440\u0432\u0435\u0440\u0430 (\u043b\u0438\u0447\u043d\u043e\u0433\u043e \u043a\u0430\u0431\u0438\u043d\u0435\u0442\u0430): " + setup.get("web.mail.server.url", null) + "\n\u041b\u043e\u0433\u0438\u043d:  \t" + contract.getTitle() + "\n\u041f\u0430\u0440\u043e\u043b\u044c: \t" + contract.getPassword();
            new MailMsg((Preferences)setup).sendMessage(email.replaceAll("\n", ", "), "\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116 " + contract.getTitle(), messageBody);
        }
    }

    @Override
    public boolean hasModuleInstance(int contractId, int moduleId) throws BGException {
        return new ContractModuleManager(this.getConnection()).getContractModuleSet(contractId).contains(moduleId);
    }

    @Override
    public void contractPasswordReset(int contractId, String email) throws BGException {
        Setup setup = Setup.getSetup();
        Connection con = this.getConnection();
        Contract contract = this.contractGet(contractId);
        if (contract == null) {
            throw new BGException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", "passwordReset.contract.notFound");
        }
        int paramId = setup.getInt("contract.password.forgot.email.param.id", -1);
        try (ContractParameterManager contractParameterManager = new ContractParameterManager(con);){
            Integer authMode;
            String contractEmail = contractParameterManager.getEmailFromParam(contractId, paramId);
            if (contractEmail == null) {
                throw new BGException("Email \u0434\u043b\u044f \u0441\u0431\u0440\u043e\u0441\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d", "passwordReset.email.notFound");
            }
            if (email != null && !this.checkEmail(email, contractEmail)) {
                throw new BGException("Email \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435", "passwordReset.email.notValid");
            }
            PasswordManager passwordManager = new PasswordManager(con);
            long passwordExpireHour = setup.getLong("contract.password.forgot.expire.hour", 24L);
            Object emailLink = setup.get("contract.password.forgot.link", "http://localhost:8080/bgbilling/webexecuter?action=ChangePassword&mid=contract&passwordOnce=${password}");
            String emailSubject = setup.get("contract.password.forgot.email.subject", "\u0412\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u043e\u043b\u044f");
            String emailText = setup.get("contract.password.forgot.email.body", "\u0414\u043b\u044f \u0432\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u043e\u043b\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 {contract} - \u043f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0435 \u043d\u0438\u0436\u0435 (\u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0438 {hour} \u0447\u0430\u0441\u043e\u0432) \u0438 \u0441\u043c\u0435\u043d\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c.");
            String charArray = setup.get("contract.password.forgot.char.array", "1234567890QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm");
            String password = passwordManager.getOncePassword(charArray);
            HashMap<Integer, Integer> authModes = new HashMap<Integer, Integer>();
            String modes = setup.get("web.auth.modes", null);
            if (modes != null) {
                String[] parts = modes.split(";");
                for (int i = 0; i < parts.length; ++i) {
                    String[] mid_mode = parts[i].split(":");
                    if (mid_mode.length != 2) continue;
                    authModes.put(Utils.parseInt(mid_mode[0].trim(), 0), Utils.parseInt(mid_mode[1].trim(), 0));
                }
            }
            if ((authMode = (Integer)authModes.get(0)) != null && authMode > 0 && authMode < 3) {
                if (authMode == 1) {
                    passwordManager.deleteByContract(contract.getTitle());
                    passwordManager.addPassword(contract.getTitle(), passwordExpireHour, password);
                } else if (authMode == 2) {
                    paramId = setup.getInt("web.auth.contract.text.parameter", 0);
                    if (paramId > 0) {
                        String value = contractParameterManager.getTextlikeParam(contract.getId(), paramId);
                        passwordManager.deleteByContract(value);
                        passwordManager.addPassword(value, passwordExpireHour, password);
                    } else {
                        logger.error("Not set parameter 'web.auth.contract.text.parameter' in config!");
                    }
                }
                emailText = emailText.replaceAll("\\{contract\\}", contract.getTitle());
                emailText = emailText.replaceAll("\\{hour\\}", String.valueOf(passwordExpireHour));
                emailLink = ((String)emailLink).contains("${password}") ? ((String)emailLink).replaceAll("\\$\\{password\\}", password) : (String)emailLink + "&passwordOnce=" + password;
                new MailMsg((Preferences)setup).sendMessage(contractEmail, emailSubject, emailText + "\n" + (String)emailLink);
                return;
            }
        }
        throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438", "passwordReset.webAuthModes.notValid");
    }

    private boolean checkEmail(String email, String emailList) {
        boolean result;
        block1: {
            String token;
            result = false;
            if (email == null || emailList == null) break block1;
            StringTokenizer st = new StringTokenizer(emailList, "\n");
            email = email.toLowerCase();
            while (st.hasMoreTokens() && !(result = (token = st.nextToken().toLowerCase()).equals(email) || token.indexOf("<" + email + ">") > -1)) {
            }
        }
        return result;
    }

    @Override
    public int contractPasswordOnceCheck(String passwordOnce) throws BGException {
        PasswordManager passwordManager = new PasswordManager(this.getConnection());
        String contractTitle = passwordManager.findContractTitle(passwordOnce);
        passwordManager.deleteContractTitle(passwordOnce);
        Contract contract = this.getDao().getByTitle(contractTitle);
        if (contract != null) {
            return contract.getId();
        }
        return 0;
    }

    @Override
    public MapHolder<Integer, EntityAttr> contractParameterMap(int contractId, int paramGroupId) throws BGException {
        Map<Integer, EntityAttr> result = this.getDao().getContractParameters(contractId, paramGroupId);
        if (this.userId != 0 && this.userId != 1 && result != null && result.size() > 0) {
            PermissionChecker.PermissionEntry userPermission = PermissionChecker.getUserPermition(this.userId);
            Iterator<Integer> iter = result.keySet().iterator();
            while (iter.hasNext()) {
                if (PermissionChecker.checkReadContractParameter(userPermission, (int)iter.next())) continue;
                iter.remove();
            }
        }
        return new MapHolder<Integer, EntityAttr>(result);
    }

    @Override
    @Deprecated
    public ContractParameterGroup contractParameterGroupGet(int id) throws BGException {
        return this.context.getDirectory(ContractParameterGroup.class, 0).get(id);
    }

    @Override
    @Deprecated
    public List<ContractParameterGroup> contractParameterGroupList() throws BGException {
        return this.context.getDirectory(ContractParameterGroup.class, 0).list();
    }

    @Override
    public SearchResult<ContractHistoryRecord> searchContractHistoryRecord(Page page) throws BGException {
        SearchResult<ContractHistoryRecord> searchResult = new SearchResult<ContractHistoryRecord>(null, page);
        ContractHistoryRecordDao contractHistoryRecordDao = new ContractHistoryRecordDao(this.getConnection());
        contractHistoryRecordDao.searchContractHistoryRecord(searchResult, this.userId);
        contractHistoryRecordDao.close();
        return searchResult;
    }

    @Override
    public void updateContractHistoryRecord(int contractId) throws BGException {
        ContractHistoryRecord contractHistoryRecord = new ContractHistoryRecord();
        contractHistoryRecord.setContractId(contractId);
        contractHistoryRecord.setUserId(this.userId);
        contractHistoryRecord.setLastOpen(new Date());
        ContractHistoryRecordDao contractHistoryRecordDao = new ContractHistoryRecordDao(this.getConnection());
        contractHistoryRecordDao.update(contractHistoryRecord);
        contractHistoryRecordDao.close();
    }

    @Override
    public String contractModuleConfigGet(int contractId, int moduleId, String key) throws BGException {
        String string;
        ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(this.getConnection(), moduleId);
        try {
            string = contractModuleConfigDao.get(contractId, key);
        }
        catch (Throwable throwable) {
            try {
                try {
                    contractModuleConfigDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new BGException(ex);
            }
        }
        contractModuleConfigDao.close();
        return string;
    }

    @Override
    public void contractModuleConfigSet(int contractId, int moduleId, String key, String value) throws BGException {
        try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(this.getConnection(), moduleId);){
            if (Utils.isBlankString(value)) {
                contractModuleConfigDao.delete(contractId, key);
            } else {
                contractModuleConfigDao.update(contractId, key, value);
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    @Override
    public void contractDomainUpdate(int contractId, int domainId) throws BGException {
        int oldDomainId = ((Contract)this.getDao().get(contractId)).getDomainId();
        this.getDao().updateDomain(contractId, domainId);
        this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
        this.context.publishAfterCommit(new ContractDomainModifiedEvent(contractId, oldDomainId, domainId, this.userId));
    }

    @Override
    public void contractsDomainUpdate(List<Integer> contractIds, int domainId) {
        if (contractIds != null) {
            contractIds.forEach(contractId -> {
                try {
                    this.contractDomainUpdate((int)contractId, domainId);
                }
                catch (BGException ex) {
                    logger.error((Object)ex);
                }
            });
        }
    }

    @Override
    public void contractParameterUpdate(int contractId, EntityAttr entityAttr) throws BGException {
        ContractParameterListItem item;
        EntityAttrList a;
        if (contractId <= 0) {
            throw new BGIllegalArgumentException("contractId");
        }
        if (entityAttr == null) {
            throw new BGIllegalArgumentException("entityAttr");
        }
        if (entityAttr.getEntityId() != 0 && contractId != entityAttr.getEntityId()) {
            throw new BGIllegalArgumentException("entityAttr.entityId");
        }
        entityAttr.setEntityId(contractId);
        this.getDao().checkContractParameter(entityAttr);
        if (entityAttr instanceof EntityAttrList && (a = (EntityAttrList)entityAttr).getValue() > 0 && (item = this.context.getDirectory(ContractParameterListItem.class, a.getEntitySpecAttrId()).get(a.getValue())) != null && item.getId() == a.getValue()) {
            a.setTitle(item.getTitle());
        }
        if (entityAttr instanceof EntityAttrText) {
            ValidateTextParamEvent event = new ValidateTextParamEvent(contractId, ((EntityAttrText)entityAttr).getValue());
            event = EventProcessor.getInstance().request(event);
            if (Utils.notBlankString(event.getError())) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438: " + event.getError());
            }
        }
        ContractParamBeforeChangeEvent checkEvent = new ContractParamBeforeChangeEvent(this.userId, contractId, entityAttr.getEntitySpecAttrId(), entityAttr);
        checkEvent = EventProcessor.getInstance().request(checkEvent);
        if (Utils.notBlankString(checkEvent.getError())) {
            throw new BGMessageException(checkEvent.getError());
        }
        this.getDao().updateContractParameter(contractId, entityAttr);
        try {
            new CommentPatternManager(this.getConnection()).updateContractComment(contractId);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        this.context.publishAfterCommit(new ContractParamChangedEvent(this.userId, contractId, entityAttr.getEntitySpecAttrId(), entityAttr));
        this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
    }

    @Override
    public EntityAttr contractParameterGet(int contractId, int parameterId) throws BGException {
        PermissionChecker.PermissionEntry userPermission;
        if (this.userId != 0 && this.userId != 1 && !PermissionChecker.checkReadContractParameter(userPermission = PermissionChecker.getUserPermition(this.userId), parameterId)) {
            throw new BGIllegalAccessException("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u0440\u043e\u0441\u043c\u0430\u0442\u0440\u0438\u0432\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440");
        }
        return this.getDao().getContractParameter(contractId, parameterId);
    }

    @Override
    public void contractUpdate(int contractId, Contract contract) throws BGException {
        if (contractId <= 0) {
            throw new BGIllegalArgumentException("contractId");
        }
        if (contract == null) {
            throw new BGIllegalArgumentException("contract");
        }
        if (contract.getId() <= 0) {
            contract.setId(contractId);
        } else if (contract.getId() != contractId) {
            throw new BGIllegalArgumentException("contractId");
        }
        this.getDao().update(contract);
        this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contract.getId()));
    }

    @Override
    public MapHolder<Integer, EntityAttr> contractParameterMapByType(int contractId, int parameterType) throws BGException {
        MapHolder<Integer, EntityAttr> map = new MapHolder<Integer, EntityAttr>();
        List parametersIds = this.context.getService(ContractParameterService.class, this.moduleId).contractParameterGroupAttrList().stream().filter(a -> a.getType() == parameterType).map(a -> a.getId()).collect(Collectors.toList());
        PermissionChecker.PermissionEntry userPermission = null;
        if (this.userId != 0 && this.userId != 1) {
            userPermission = PermissionChecker.getUserPermition(this.userId);
        }
        Iterator iterator = parametersIds.iterator();
        while (iterator.hasNext()) {
            int parameterId = (Integer)iterator.next();
            if (userPermission != null && !PermissionChecker.checkReadContractParameter(userPermission, parameterId)) continue;
            map.getMap().put(parameterId, this.getDao().getContractParameter(contractId, parameterId));
        }
        return map;
    }

    @Override
    public void contractDelete(int contractId, boolean save, String folder) throws BGException {
        Contract contract = (Contract)this.getDao().get(contractId);
        if (contract != null) {
            if (contract.getSuperCid() != 0) {
                throw new BGMessageException("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430!");
            }
            if (Utils.isBlankString(folder)) {
                folder = "/";
            }
            if (contractId < 0) {
                throw new BGIllegalArgumentException();
            }
            try (ContractRemover contractRemover = new ContractRemover(this.getConnection(), folder);){
                String error = contractRemover.removeContracts(Collections.singletonList(contractId), save);
                if (Utils.notBlankString(error)) {
                    throw new BGException(error);
                }
            }
        }
    }

    @Override
    public String contractListByFilter(ContractFilters contractFilters, List<FilterEntityAttr> entityFilter, Holder<Page> pageHolder) throws BGException {
        Page page;
        if (pageHolder == null || (page = (Page)pageHolder.value) == null) {
            page = new Page(1, 25);
        }
        String list = this.getDao().contractListByFilter(contractFilters, entityFilter, page);
        if (pageHolder != null) {
            pageHolder.value = page;
        }
        return list;
    }

    @Override
    public JSONObject contractInfoGet(int contractId) throws BGException {
        boolean chekPermission;
        PreparedStatement ps;
        JSONObject contractJson;
        JSONObject contractInfo;
        Connection con;
        block107: {
            con = this.getConnection();
            contractInfo = new JSONObject();
            contractJson = new JSONObject();
            contractInfo.put("contract", (Object)contractJson);
            Contract contract = null;
            try (ContractDao contractDao = new ContractDao(con, this.userId);){
                contract = (Contract)contractDao.get(contractId);
                if (contract == null) break block107;
                contractJson.put("domainId", contract.getDomainId());
                contractJson.put("title", (Object)contract.getTitle());
                contractJson.put("comment", (Object)contract.getComment());
                contractJson.put("limit", (Object)Utils.formatBigDecimalSumm(contract.getBalanceLimit()));
                contractJson.put("mode", (int)contract.getBalanceMode());
                contractJson.put("date1", (Object)TimeUtils.formatDate(contract.getDateFrom()));
                contractJson.put("date2", (Object)TimeUtils.formatDate(contract.getDateTo()));
                contractJson.put("fc", (int)contract.getPersonType());
                contractJson.put("del", contract.isHidden() ? 1 : 0);
                contractJson.put("status", (Object)StatusCache.getInstance().getStatusTitle(contract.getStatus()));
                if (contract.getSuperCid() == 0) {
                    contractJson.put("hierarchy", (Object)"independent");
                    break block107;
                }
                if (contract.getSuperCid() == -1) {
                    contractJson.put("hierarchy", (Object)"super");
                    try (PreparedStatement ps2 = con.prepareStatement("SELECT sub_mode FROM contract WHERE scid=?");){
                        ps2.setInt(1, contractId);
                        int dep = 0;
                        int indep = 0;
                        try (ResultSet rs = ps2.executeQuery();){
                            while (rs.next()) {
                                if (rs.getInt(1) == 0) {
                                    ++dep;
                                    continue;
                                }
                                ++indep;
                            }
                        }
                        contractJson.put("hierarchyDep", dep);
                        contractJson.put("hierarchyIndep", indep);
                        break block107;
                    }
                    catch (SQLException ex) {
                        throw new BGException(ex);
                    }
                }
                if (contract.getBalanceSubMode() == 0) {
                    contractJson.put("hierarchy", (Object)"depend_sub");
                } else if (contract.getBalanceSubMode() == 1) {
                    contractJson.put("hierarchy", (Object)"independ_sub");
                }
            }
        }
        try {
            ps = con.prepareStatement("SELECT ( isNUll(date1) OR not date1>now() ) AND ( isNull(date2) OR not date2<now() ) FROM object WHERE cid=?");
            try {
                ps.setInt(1, contractId);
                int objectCountAll = 0;
                int objectCountActive = 0;
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        if (rs.getBoolean(1)) {
                            ++objectCountActive;
                        }
                        ++objectCountAll;
                    }
                }
                contractJson.put("objects", (Object)(objectCountActive + "/" + objectCountAll));
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        try {
            ps = con.prepareStatement("SELECT count(*) FROM contract_comment WHERE cid=?");
            try {
                ps.setInt(1, contractId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        contractJson.put("comments", (Object)rs.getString(1));
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        JSONObject infoJson = new JSONObject();
        contractInfo.put("info", (Object)infoJson);
        JSONArray groupsJson = new JSONArray();
        infoJson.put("groups", (Object)groupsJson);
        ContractLabelManager contractLabelManager = new ContractLabelManager(con);
        List<Integer> contractLabelIds = contractLabelManager.getContractLabelIds(contractId);
        List<ContractLabelItem> allItems = contractLabelManager.getContractLabelItemList(false);
        List contractItems = allItems.stream().filter(i -> contractLabelIds.contains(i.getId())).collect(Collectors.toList());
        Collections.sort(contractItems);
        for (ContractLabelItem item : contractItems) {
            JSONObject jsonItem = new JSONObject();
            jsonItem.put("id", item.getId());
            jsonItem.put("title", (Object)item.getTitle());
            groupsJson.put((Object)jsonItem);
        }
        JSONArray tariffJson = new JSONArray();
        infoJson.put("tariff", (Object)tariffJson);
        HashMap<String, String> mapRequest = new HashMap<String, String>();
        mapRequest.put("action", "PersonalTariffTable");
        mapRequest.put("module", "contract.tariff");
        ModuleAction action = PermissionChecker.getInstance().findAction(new String[]{"0"}, mapRequest);
        boolean bl = chekPermission = Setup.getSetup().getInt("bgsecure.check", 1) == 0;
        if (chekPermission || action == null || PermissionChecker.getInstance().checkActionAllow(mapRequest, "0", action, this.userId, contractId) == null) {
            for (PersonalTariff personalTariff : new PersonalTariffManager(con).getPersonalTariffList(contractId, new Date())) {
                JSONObject jsonItem = new JSONObject();
                jsonItem.put("id", personalTariff.getId());
                jsonItem.put("title", (Object)("\u041f\u0422: " + personalTariff.getTitle()));
                tariffJson.put((Object)jsonItem);
            }
        }
        mapRequest.clear();
        mapRequest.put("action", "ContractTariffPlans");
        mapRequest.put("module", "contract");
        action = PermissionChecker.getInstance().findAction(new String[]{"0"}, mapRequest);
        if (chekPermission || action == null || PermissionChecker.getInstance().checkActionAllow(mapRequest, "0", action, this.userId, contractId) == null) {
            String query = "SELECT t2.id, title FROM contract_tariff AS t1, tariff_plan AS t2 WHERE  cid=? AND tpid=t2.id AND emid=0 AND eid=0 AND ( isNull( date1 ) OR date1<=CURDATE() ) AND ( isNull( date2 ) OR date2>=CURDATE() )";
            try (PreparedStatement ps3 = con.prepareStatement(query);){
                ps3.setInt(1, contractId);
                try (ResultSet rs = ps3.executeQuery();){
                    while (rs.next()) {
                        JSONObject jsonItem = new JSONObject();
                        jsonItem.put("id", rs.getInt(1));
                        jsonItem.put("title", (Object)rs.getString(2));
                        tariffJson.put((Object)jsonItem);
                    }
                }
            }
            catch (SQLException ex) {
                throw new BGException(ex);
            }
        }
        mapRequest.clear();
        mapRequest.put("action", "ContractBalanceGeneral");
        mapRequest.put("module", "contract");
        action = PermissionChecker.getInstance().findAction(new String[]{"0"}, mapRequest);
        if (chekPermission || action == null || PermissionChecker.getInstance().checkActionAllow(mapRequest, "0", action, this.userId, contractId) == null) {
            JSONObject balanceJson = new JSONObject();
            infoJson.put("balance", (Object)balanceJson);
            LocalDate now = LocalDate.now();
            int yy = now.getYear();
            int mm = now.getMonthValue();
            ContractBalance contractBalance = null;
            try (BalanceDao balanceDao = new BalanceDao(con);){
                contractBalance = balanceDao.getContractBalance(contractId, yy, mm);
            }
            catch (Exception ex) {
                throw new BGException(ex);
            }
            GregorianCalendar paybackFrom = new GregorianCalendar();
            paybackFrom.set(contractBalance.getYear(), contractBalance.getMonth() - 1, 1, 0, 0, 0);
            Calendar paybackTo = (Calendar)((Calendar)paybackFrom).clone();
            paybackTo.add(2, 1);
            ChargeDao chargeDao = new ChargeDao(con);
            BigDecimal payback = chargeDao.getSum(contractId, paybackFrom.getTime(), paybackTo.getTime(), 0, 1, true);
            chargeDao.close();
            balanceJson.put("summa1", (Object)Utils.formatBigDecimalSumm(contractBalance.getIncomingSaldo()));
            balanceJson.put("summa2", (Object)Utils.formatBigDecimalSumm(contractBalance.getPayments()));
            balanceJson.put("summa3", (Object)Utils.formatBigDecimalSumm(contractBalance.getAccounts()));
            balanceJson.put("summa4", (Object)Utils.formatBigDecimalSumm(contractBalance.getCharges().subtract(payback)));
            balanceJson.put("summa5", (Object)Utils.formatBigDecimalSumm(contractBalance.toBalanceWithoutReserves()));
            balanceJson.put("summa6", (Object)Utils.formatBigDecimalSumm(contractBalance.toBalance()));
            balanceJson.put("summa7", (Object)Utils.formatBigDecimalSumm(payback));
            balanceJson.put("summa8", (Object)Utils.formatBigDecimalSumm(contractBalance.getReserve()));
            balanceJson.put("yy", contractBalance.getYear());
            balanceJson.put("mm", contractBalance.getMonth());
        }
        JSONArray modulesJson = new JSONArray();
        infoJson.put("modules", (Object)modulesJson);
        for (BGModule module : new ContractModuleManager(con).getContractModules(contractId)) {
            JSONObject itemJson = new JSONObject();
            itemJson.put("id", module.getId());
            itemJson.put("title", (Object)module.getTitle());
            BGInstalledModule bgInstalledModule = module.getInstalledModule();
            if (bgInstalledModule != null) {
                itemJson.put("package", (Object)module.getInstalledModule().getPackageClient());
                String className = module.getInstalledModule().getPackageServer() + ".Module";
                ApplicationModule moduleClass = Utils.newInstance(className, ApplicationModule.class);
                if (moduleClass != null) {
                    itemJson.put("status", (Object)moduleClass.getStatus(con, module.getId(), contractId));
                }
            }
            modulesJson.put((Object)itemJson);
        }
        mapRequest.clear();
        mapRequest.put("action", "ContractScriptTable");
        mapRequest.put("module", "contract");
        action = PermissionChecker.getInstance().findAction(new String[]{"0"}, mapRequest);
        if (chekPermission || action == null || PermissionChecker.getInstance().checkActionAllow(mapRequest, "0", action, this.userId, contractId) == null) {
            JSONArray scriptJson = new JSONArray();
            infoJson.put("script", (Object)scriptJson);
            String query = "SELECT s.id, s.title FROM contract_script cs LEFT JOIN script s ON cs.script_id=s.id WHERE cid=? AND ( isNull( date1 ) OR date1<=CURDATE() ) AND ( isNull( date2 ) OR date2>=CURDATE() )";
            try (PreparedStatement ps4 = con.prepareStatement(query);){
                ps4.setInt(1, contractId);
                try (ResultSet rs = ps4.executeQuery();){
                    while (rs.next()) {
                        JSONObject jsonItem = new JSONObject();
                        jsonItem.put("id", rs.getInt(1));
                        jsonItem.put("title", (Object)rs.getString(2));
                        scriptJson.put((Object)jsonItem);
                    }
                }
            }
            catch (SQLException ex) {
                throw new BGException(ex);
            }
        }
        JSONArray pluginsJson = new JSONArray();
        infoJson.put("plugins", (Object)pluginsJson);
        for (BGPlugInElement extension : BGPluginManagerServer.getManager().getExtensions("bitel.billing.server.contract.action.ActionContractInfo", true)) {
            Element extensionElement = extension.getElement();
            BGPluginServer plugin = (BGPluginServer)extension.getPlugin();
            NodeList list = extensionElement.getElementsByTagName("treeNode");
            for (int index = 0; index < list.getLength(); ++index) {
                Element treeNode = (Element)list.item(index);
                try {
                    String key = plugin.getResourceString(treeNode.getAttribute("key"));
                    String className = treeNode.getAttribute("class");
                    PluginTreeNodeInterface node = (PluginTreeNodeInterface)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                    JSONObject itemJson = new JSONObject();
                    itemJson.put("key", (Object)key);
                    itemJson.put("title", (Object)node.getTitle(this.context, contractId));
                    itemJson.put("value", (Object)node.getValue(this.context, contractId));
                    pluginsJson.put((Object)itemJson);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return contractInfo;
    }

    @Override
    public JSONObject contractTitleAndCommentGet(int contractId) throws BGException, BGMessageException {
        JSONObject json = new JSONObject();
        if (contractId > 0) {
            ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);
            Contract contract = (Contract)contractDao.get(contractId);
            contractDao.close();
            if (contract != null) {
                json.put("title", (Object)contract.getTitle());
                json.put("comment", (Object)contract.getComment());
            }
        }
        return json;
    }

    @Override
    public void contractTitleAndCommentUpdate(int contractId, String title, String comment, int patternId) throws BGException, BGMessageException {
        if (contractId > 0) {
            Connection con = this.getConnection();
            try (ContractDao contractDao = new ContractDao(con, this.userId);){
                if (Utils.notBlankString(title) && ContractPatternManager.isContractTitleDuplicated((String)title.trim(), (boolean)false, (int)contractId, (Connection)con)) {
                    throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
                }
                Contract contract = (Contract)contractDao.get(contractId);
                ContractPatternManager.removeContractTitleFromLastTitles((String)contract.getTitle());
                if (title != null) {
                    contract.setTitle(title.trim());
                }
                if (comment != null) {
                    contract.setComment(comment.trim());
                }
                if (patternId > 0) {
                    contract.setTitlePatternId(patternId);
                }
                contractDao.update(contract);
            }
            this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
        }
    }

    @Override
    public JSONObject contractCommentPatternList(int contractId) throws BGException, BGMessageException {
        JSONObject json = new JSONObject();
        if (contractId > 0) {
            Connection con = this.getConnection();
            try (ContractDao contractDao = new ContractDao(con, this.userId);){
                Contract contract = (Contract)contractDao.get(contractId);
                if (contract != null) {
                    json.put("contractPatternId", contract.getTitlePatternId());
                }
            }
        }
        try {
            JSONArray patterns = new JSONArray();
            JSONObject withoutPattern = new JSONObject();
            withoutPattern.put("id", 0);
            withoutPattern.put("title", (Object)"\u0411\u0435\u0437 \u0448\u0430\u0431\u043b\u043e\u043d\u0430");
            patterns.put((Object)withoutPattern);
            for (IdTitle idTitle : new CommentPatternManager(this.getConnection()).getContractCommentPatternList()) {
                JSONObject item = new JSONObject();
                item.put("id", idTitle.getId());
                item.put("title", (Object)idTitle.getTitle());
                patterns.put((Object)item);
            }
            json.put("patterns", (Object)patterns);
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return json;
    }

    @Override
    public String contractCommentPatternValue(int contractId, int patternId) throws BGException, BGMessageException {
        if (patternId > 0 && contractId > 0) {
            try {
                return new CommentPatternManager(this.getConnection()).transformValueToComment(patternId, contractId);
            }
            catch (SQLException ex) {
                throw new BGException(ex);
            }
        }
        return "";
    }

    @Override
    public List<ContractCard> contractCardList(int contractId) throws BGException, BGMessageException {
        ArrayList<ContractCard> cards = new ArrayList<ContractCard>();
        String card = "";
        Contract contract = null;
        if (contractId > 0) {
            try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
                contract = (Contract)contractDao.get(contractId);
            }
        }
        Setup setup = Setup.getSetup();
        int i = 1;
        while (card != null) {
            String[] arr;
            card = setup.get("contractcard." + i, null);
            if (card != null && (arr = card.split(":", 3)).length > 1 && (contract == null || arr.length <= 2 || (contract.getGroups() & Utils.enumToMask(arr[2])) != 0L)) {
                ContractCard contractCard = new ContractCard();
                contractCard.setId(String.valueOf(i));
                contractCard.setTitle(arr[1]);
                cards.add(contractCard);
            }
            ++i;
        }
        EventProcessor.getInstance().request(new GetContractCardsList(this.userId, contractId, cards));
        return cards;
    }
}

