/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventSubscriber;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.event.CustomerPanelReinitEvent;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.Customer;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerFParamPanel;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerUParamPanel;
import ru.bitel.common.client.AbstractBGUPanel;

public class CustomerParamPanel
extends BGUPanel
implements EventSubscriber<CustomerPanelReinitEvent> {
    private Customer.CustomerType customerType = Customer.CustomerType.FIZ_CUSTOMER;
    private CustomerFParamPanel customerFParamPanel = null;
    private CustomerUParamPanel customerUParamPanel = null;
    private ContractParameterService contractParameterService = null;
    AbstractBGUPanel.DefaultAction refresh = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            try {
                JSONObject customer = ((ClientContext)CustomerParamPanel.this.getContext()).getCustomer();
                if (customer == null) {
                    customer = new JSONObject(CustomerParamPanel.this.getContractParameterService().customerParameterGet(((ClientContext)CustomerParamPanel.this.getContext()).getContractId()));
                }
                CustomerParamPanel.this.customerType = Customer.CustomerType.defineType(customer.optString("personType"));
                int customerId = ((ClientContext)CustomerParamPanel.this.getContext()).getCustomerId();
                if (CustomerParamPanel.this.getComponentCount() == 0 && customerId > 0) {
                    if (CustomerParamPanel.this.customerType == Customer.CustomerType.JUR_CUSTOMER) {
                        CustomerParamPanel.this.customerUParamPanel = new CustomerUParamPanel(CustomerParamPanel.this);
                    } else {
                        CustomerParamPanel.this.customerFParamPanel = new CustomerFParamPanel(CustomerParamPanel.this);
                    }
                    CustomerParamPanel.this.add((Component)(CustomerParamPanel.this.customerType == Customer.CustomerType.JUR_CUSTOMER ? CustomerParamPanel.this.customerUParamPanel : CustomerParamPanel.this.customerFParamPanel), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            if (((ClientContext)CustomerParamPanel.this.getContext()).getCustomerId() > 0) {
                if (CustomerParamPanel.this.customerType == Customer.CustomerType.JUR_CUSTOMER && CustomerParamPanel.this.customerUParamPanel != null) {
                    CustomerParamPanel.this.customerUParamPanel.setData();
                } else if (CustomerParamPanel.this.customerFParamPanel != null) {
                    CustomerParamPanel.this.customerFParamPanel.setData();
                }
            }
        }
    };

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        EventBus.subscribe(CustomerPanelReinitEvent.class, (EventSubscriber)this);
    }

    public void onEvent(CustomerPanelReinitEvent event) {
        if (event.getContractId() == ((ClientContext)this.getContext()).getContractId()) {
            SwingUtilities.invokeLater(this::reinit);
        }
    }

    private void reinit() {
        this.removeAll();
        this.refresh();
        this.revalidate();
        this.repaint();
    }

    ContractParameterService getContractParameterService() {
        if (this.contractParameterService == null) {
            this.contractParameterService = ((ClientContext)this.getContext()).getPort(ContractParameterService.class);
        }
        return this.contractParameterService;
    }

    public void updateCustomerValue(String fieldKey, String text) {
        try {
            JSONObject customer = ((ClientContext)this.getContext()).getCustomer();
            customer.put("customer", (Object)new JSONObject(this.getContractParameterService().customerParameterUpdate(((ClientContext)this.getContext()).getCustomerId(), fieldKey, text)).getJSONObject("customer"));
            EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)this.getContext()).getContractId()));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void refresh() {
        this.performAction("refresh");
    }
}

