/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.module.server.service;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ServiceService;
import ru.bitel.bgbilling.kernel.module.server.bean.ServiceDao;
import ru.bitel.bgbilling.kernel.module.server.event.ServicesChangedEvent;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.module.common.service.ServiceService")
public class ServiceServiceImpl
extends AbstractService
implements ServiceService {
    private ServiceDao serviceDao;
    private Directory<Service> directory;

    @PostConstruct
    protected void init() throws BGException {
        this.serviceDao = new ServiceDao(this.getConnection());
        this.directory = this.context.getDirectory(Service.class, 0);
    }

    @Override
    public Service serviceGet(int serviceId) throws BGException {
        return this.directory.get(serviceId);
    }

    @Override
    public List<Service> serviceList(int moduleId) throws BGException {
        if (moduleId > 0) {
            return this.serviceDao.list(moduleId);
        }
        return this.directory.list();
    }

    @Override
    public int serviceUpdate(Service service) throws BGException {
        this.directory.update(service);
        this.context.publishAfterCommit(new ServicesChangedEvent(this.userId));
        return service.getId();
    }

    @Override
    public void serviceDelete(int id) throws BGException {
        this.directory.delete(id);
        this.context.publishAfterCommit(new ServicesChangedEvent(this.userId));
    }
}

