/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.search.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.bgbilling.kernel.search.common.bean.SearchModule;
import ru.bitel.bgbilling.kernel.search.common.service.SearchService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.RowData;
import ru.bitel.common.model.SearchResult;

public class SearchConfigPanel
extends BGUPanel {
    private SearchService searchService;
    private BGUList<KeyValue> searchEntityList = new BGUList();
    private SearchFinderTableModel finderTableModel = new SearchFinderTableModel();
    AbstractBGUPanel.DefaultAction newAction = new AbstractBGUPanel.DefaultAction("new", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            new SearchFinderEditor("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043c\u043e\u0434\u0443\u043b\u044c \u043f\u043e\u0438\u0441\u043a\u0430", new SearchModule()).getDialog().setVisible(true);
        }
    };
    AbstractBGUPanel.DefaultAction editAction = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            SearchModule searchModule = (SearchModule)SearchConfigPanel.this.finderTableModel.getSelectedRow();
            if (searchModule == null) {
                ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043c\u043e\u0434\u0443\u043b\u044c");
                return;
            }
            new SearchFinderEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043c\u043e\u0434\u0443\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430", searchModule).getDialog().setVisible(true);
        }
    };

    @Override
    protected void jbInit() throws Exception {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, this.getSearchEntityListPanel(), (Component)this.getSearchFinderTablePanel(), 300L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getSearchEntityListPanel() {
        this.searchEntityList.setSelectionMode(0);
        this.searchEntityList.setData(Arrays.asList(new KeyValue("customer", "\u041a\u043b\u0438\u0435\u043d\u0442"), new KeyValue("contract", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440")));
        this.searchEntityList.addListSelectionListener(e -> {
            KeyValue listItem = (KeyValue)this.searchEntityList.getSelectedValue();
            if (listItem != null) {
                try {
                    SearchResult<SearchModule> searchResult = this.getSearchService().searchModules(listItem.getKey(), null);
                    this.finderTableModel.setData(searchResult.getList());
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0418\u0441\u043a\u0430\u0442\u044c:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 5, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane(this.searchEntityList), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getSearchFinderTablePanel() {
        BGUTable table = new BGUTable(this.finderTableModel);
        table.setSelectionMode(0);
        BGSwingUtilites.handleEdit(table, this, "edit");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u043e\u0438\u0441\u043a\u043e\u0432\u044b\u0435 \u043c\u043e\u0434\u0443\u043b\u0438:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 5, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 5, 5, 5), 0, 0));
        return panel;
    }

    private SearchService getSearchService() {
        if (this.searchService == null) {
            this.searchService = ((ClientContext)this.getContext()).getPort(SearchService.class, 0);
        }
        return this.searchService;
    }

    class SearchFinderTableModel
    extends BGTableModel<SearchModule> {
        public SearchFinderTableModel() {
            super(SearchFinderTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 300, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043b\u0430\u0441\u0441", 100, 300, -1, "classImpl", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0412\u043a\u043b\u044e\u0447\u0435\u043d", Boolean.class, 100, 100, 100, "on", true);
            this.addColumnId();
        }
    }

    class SearchFinderEditor
    extends BGEditorDialog<SearchModule> {
        private JTextField titleField;
        private JToggleButton onButton;
        private JToggleButton offButton;
        private ParamTableModel paramTableModel;
        private DynamicClassChooser chooser;

        public SearchFinderEditor(String title, SearchModule data) {
            super(title, data);
            this.titleField = new JTextField(50);
            this.onButton = new JToggleButton("\u0412\u041a\u041b.", true);
            this.offButton = new JToggleButton("\u0412\u042b\u041a\u041b.", false);
            this.paramTableModel = new ParamTableModel();
            this.chooser = new DynamicClassChooser(false, 1);
        }

        @Override
        public void doDialogPanel() {
            this.panel.add((Component)this.getTopPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getClassParamPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        }

        private JPanel getTopPanel() {
            this.titleField.setHorizontalAlignment(0);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.onButton);
            buttonGroup.add(this.offButton);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.titleField, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.onButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 20, 0, 0), 0, 0));
            panel.add((Component)this.offButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getClassParamPanel() {
            JPanel panel = new JPanel(new GridLayout(1, 2, 10, 5));
            panel.add(this.getSearchModuleClassPanel());
            panel.add(this.getSearchModuleParamPanel());
            return panel;
        }

        private JPanel getSearchModuleClassPanel() {
            this.chooser.setPreferredSize(new Dimension(500, 400));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041a\u043b\u0430\u0441\u0441 \u043c\u043e\u0434\u0443\u043b\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
            panel.add((Component)this.chooser, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getSearchModuleParamPanel() {
            BGUTable table = new BGUTable(this.paramTableModel);
            table.setSelectionMode(0);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043c\u043e\u0434\u0443\u043b\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        class ParamTableModel
        extends BGTableModel<RowData> {
            public ParamTableModel() {
                super(ParamTableModel.class.getName());
            }

            @Override
            protected void initColumns() {
                this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 50, 100, 200, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 100, -1, -1, "value", true, HorizontalAlignmentTableCellRenderer.LEFT());
            }
        }
    }
}

