/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.tariff.util.TimeLimits;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.model.IdTitle;

public class TimeFilterTariffTreeNode
extends DefaultTariffTreeNode {
    private JPanel _editor = new JPanel();
    private JLabel _view = new JLabel();
    private DefaultListModel<TimeLimits> _listModel = new DefaultListModel();
    private JList<TimeLimits> _limitList = new JList<TimeLimits>(this._listModel);
    private BGComboBox<IdTitle> timeRange;
    private CardLayout cardLayout = new CardLayout();
    private Directory timeRangesDir;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.timeRangesDir = this.getDirManager().getDirectory("time_range");
        this.makeEditor();
    }

    private void makeEditor() {
        this._editor.setLayout(this.cardLayout);
        JPanel listPanel = new JPanel();
        this._editor.add((Component)listPanel, "view");
        listPanel.setLayout(new GridBagLayout());
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().add(this._limitList);
        listPanel.add((Component)scroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 15, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel editButtons = new JPanel();
        JButton addBut = new JButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c");
        JButton delBut = new JButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        JButton editBut = new JButton("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        editButtons.add(addBut);
        editButtons.add(delBut);
        editButtons.add(editBut);
        addBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeLimits tl = new TimeLimits();
                TimeFilterTariffTreeNode.this._listModel.addElement(tl);
                TimeFilterTariffTreeNode.this.editTimeLimits(tl);
            }
        });
        editBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeFilterTariffTreeNode.this.editSelectedTl();
            }
        });
        delBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pos = TimeFilterTariffTreeNode.this._limitList.getSelectedIndex();
                if (pos >= 0) {
                    TimeFilterTariffTreeNode.this._listModel.removeElementAt(pos);
                }
            }
        });
        this._limitList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TimeFilterTariffTreeNode.this.editSelectedTl();
                }
            }
        });
        listPanel.add((Component)editButtons, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (this.timeRangesDir != null) {
            JPanel setRangePanel = new JPanel(new GridBagLayout());
            this.timeRange = new BGComboBox();
            this.buildDirectoryCombo(this.timeRangesDir, this.timeRange);
            IdTitle di = new IdTitle();
            di.setId(0);
            di.setTitle("-- \u043d\u0435\u0442 --");
            this.timeRange.insertItemAt(di, 0);
            JPanel dirPanel = this.getDirectoryAddPanel(this.timeRangesDir, this.timeRange, true);
            setRangePanel.add((Component)new JLabel("\u0423\u0441\u0442. \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
            setRangePanel.add(this.timeRange, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            setRangePanel.add((Component)dirPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            listPanel.add((Component)setRangePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 0, 5, 0), 0, 0));
        }
        BGButtonPanelOkCancel yesNoPane = new BGButtonPanelOkCancel();
        listPanel.add((Component)yesNoPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 5, 5, 5), 0, 0));
        yesNoPane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command != null) {
                    if (command.equals("ok")) {
                        TimeFilterTariffTreeNode.this.serializeData();
                        TimeFilterTariffTreeNode.this.saveData();
                        TimeFilterTariffTreeNode.this.updateView();
                        TimeFilterTariffTreeNode.this.tree.updateTree();
                        TimeFilterTariffTreeNode.this.tree.getViewableTree().stopEditing();
                    } else if (command.equals("cancel")) {
                        TimeFilterTariffTreeNode.this.loadData();
                        TimeFilterTariffTreeNode.this.tree.getViewableTree().stopEditing();
                    }
                }
            }
        });
    }

    @Override
    public void setData(String data) {
        super.setData(data);
        this.loadData();
        this.updateView();
    }

    private void editSelectedTl() {
        TimeLimits tl = this._limitList.getSelectedValue();
        if (tl != null) {
            this.editTimeLimits(tl);
        }
    }

    private void editTimeLimits(TimeLimits tl) {
        tl.startEdit();
        this._editor.add((Component)tl, "edit");
        this.cardLayout.show(this._editor, "edit");
        tl.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                TimeFilterTariffTreeNode.this.cardLayout.show(TimeFilterTariffTreeNode.this._editor, "view");
            }
        });
    }

    @Override
    protected void loadData() {
        this._listModel.removeAllElements();
        Map<String, String> data = this.getDataInHash();
        for (String key : data.keySet()) {
            String value = data.get(key);
            if (Utils.parseInt(key, -1) < 0) continue;
            TimeLimits tl = new TimeLimits();
            tl.setData(value);
            this._listModel.addElement(tl);
        }
        if (this.timeRangesDir != null) {
            this.setDirectoryItemSelection(this.timeRange, Utils.parseInt(data.get("time_range"), 0));
        }
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        for (int i = 0; i < this._listModel.getSize(); ++i) {
            String key = String.valueOf(i);
            TimeLimits tl = this._listModel.getElementAt(i);
            data.put(key, tl.getData());
        }
        if (this.timeRangesDir != null) {
            data.put("time_range", String.valueOf(this.getIdFromDirectoryCombo(this.timeRange)));
        }
        this.setDataInHash(data);
    }

    private void updateView() {
        IdTitle di;
        StringBuffer text = new StringBuffer("<html>\u041d\u0430\u0431\u043e\u0440 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439:");
        int size = this._listModel.getSize();
        for (int i = 0; i < size; ++i) {
            TimeLimits tl = this._listModel.getElementAt(i);
            if (text.length() != 0) {
                text.append("<br>");
            }
            text.append(tl.toString());
        }
        if (this.timeRangesDir != null && (di = this.timeRange.getSelectedItem()).getId() != 0) {
            text.append("<br>&gt;&gt;&gt;&gt; ");
            text.append(di.getTitle());
        }
        this._view.setText(text.toString());
    }

    @Override
    protected JPanel getEditorPanel() {
        return new JPanel();
    }

    @Override
    public Component getView() {
        return this._view;
    }

    @Override
    public Component getEditor() {
        return this._editor;
    }

    @Override
    public void serializeToXML(Element el) {
        super.serializeToXML(el);
        el.setAttribute("data", this.getData());
        this.serializeChildsToXML(el);
    }

    @Override
    public void loadFromXML(Element el) {
        String data = el.getAttribute("data");
        if (data.length() > 0) {
            this.setData(String.valueOf(data));
            this.saveData();
        }
        this.loadChildsFromXML(el);
    }
}

