/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.list;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.client.list.BGUKeySelectionListener;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class BGUList<I extends GuiTitlable>
extends JList<I> {
    private List<I> items = new ArrayList<I>();
    private final BGUKeySelectionListener<I> ksl;
    private DefaultListModel<I> defaultListModel;

    public BGUList() {
        this(new ArrayList());
    }

    public BGUList(List<I> items) {
        this.ksl = new BGUKeySelectionListener<I>(this, items);
        this.setData(items);
        this.addKeyListener(this.ksl);
        this.setCellRenderer(new BGListCellRenderer());
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 27: {
                if (this.ksl.getPattern() != null && keyEvent.getID() == 401) {
                    this.ksl.selectionForKey('\u001b');
                    this.ksl.showPatternPopup();
                    break;
                }
                super.processKeyEvent(keyEvent);
                break;
            }
            default: {
                super.processKeyEvent(keyEvent);
            }
        }
    }

    public long getSelectedMask() {
        long result = 0L;
        for (Object selected : this.getSelectedValuesList()) {
            if (!(selected instanceof Idable)) continue;
            result |= 1L << ((Idable)selected).getId();
        }
        return result;
    }

    public void setData(List<I> items) {
        this.items = items;
        this.resetFilter();
        if (this.defaultListModel == null) {
            this.defaultListModel = new DefaultListModel();
        }
        this.defaultListModel.removeAllElements();
        this.defaultListModel.addAll(items);
        this.setModel(this.defaultListModel);
    }

    public void resetFilter() {
        this.ksl.selectionForKey('\u001b');
        this.setFilterList(this.ksl.getPattern());
    }

    public void setFilterList(String pattern) {
        DefaultListModel<GuiTitlable> listModel = new DefaultListModel<GuiTitlable>();
        for (GuiTitlable idTitle : this.items) {
            if (pattern != null && !idTitle.getGuiTitle().toLowerCase().contains(pattern) && (!(idTitle instanceof BGUListItem) || !((BGUListItem)idTitle).isSelected())) continue;
            listModel.addElement(idTitle);
        }
        this.defaultListModel = listModel;
        this.setModel(this.defaultListModel);
        if (!this.defaultListModel.isEmpty()) {
            this.setSelectedIndex(0);
        }
    }

    public void setSelectedId(int selectedId, boolean shouldScroll) {
        for (GuiTitlable item : this.items) {
            Id id;
            if (!(item instanceof Id) || (id = (Id)((Object)item)).getId() != selectedId) continue;
            this.setSelectedValue(item, shouldScroll);
            break;
        }
    }

    @Override
    public DefaultListModel<I> getModel() {
        if (this.defaultListModel == null) {
            this.defaultListModel = new DefaultListModel();
            this.setModel(this.defaultListModel);
        }
        return this.defaultListModel;
    }

    public Optional<I> optSelectedValue() {
        return Optional.ofNullable((GuiTitlable)super.getSelectedValue());
    }

    class BGListCellRenderer
    extends DefaultListCellRenderer {
        BGListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof GuiTitlable && component instanceof JLabel) {
                ((JLabel)component).setText(((GuiTitlable)value).getGuiTitle());
            }
            return component;
        }
    }
}

