/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client.table;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.oss.kernel.entity.client.table.EntityAttrDateCellEditor;
import ru.bitel.oss.kernel.entity.client.table.EntityAttrEntry;
import ru.bitel.oss.kernel.entity.client.table.EntityAttrIntCellEditor;
import ru.bitel.oss.kernel.entity.client.table.EntityAttrListCellEditor;
import ru.bitel.oss.kernel.entity.client.table.EntityAttrTextCellEditor;
import ru.bitel.oss.kernel.entity.client.table.EntityAttributesTableModel;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrHouse;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrInt;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttrType;

public class EntityAttributesTable
extends BGUTable {
    public EntityAttributesTable(EntityAttributesTableModel model) {
        super(model);
        this.setDefaultEditor(EntityAttrText.class, new EntityAttrTextCellEditor());
        this.setDefaultEditor(EntityAttrList.class, new EntityAttrListCellEditor(this.getContext()));
        this.setDefaultEditor(EntityAttrDate.class, new EntityAttrDateCellEditor());
        this.setDefaultEditor(EntityAttrInt.class, new EntityAttrIntCellEditor());
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor;
        if (column == 2) {
            EntityAttrEntry entry = (EntityAttrEntry)this.getValueAt(row, column);
            switch (EntitySpecAttrType.getEntitySpecAttrType((int)entry.getSpecAttr().getType())) {
                case TEXT: {
                    return this.getDefaultEditor(EntityAttrText.class);
                }
                case INT: {
                    return this.getDefaultEditor(EntityAttrInt.class);
                }
                case LIST: {
                    return this.getDefaultEditor(EntityAttrList.class);
                }
                case DATE: {
                    return this.getDefaultEditor(EntityAttrDate.class);
                }
                case HOUSE: {
                    return this.getDefaultEditor(EntityAttrHouse.class);
                }
            }
            return null;
        }
        Object value = this.getValueAt(row, column);
        TableCellEditor tableCellEditor = editor = value != null ? this.getDefaultEditor(value.getClass()) : null;
        if (editor == null) {
            TableColumn tableColumn = this.getColumnModel().getColumn(column);
            editor = tableColumn.getCellEditor();
        }
        if (editor == null) {
            editor = this.getDefaultEditor(this.getColumnClass(column));
        }
        return editor;
    }
}

