/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.action.web;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.util.MailMsg;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.license.server.action.web.ActionOrders;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class ActionSendBills
extends ActionOrders {
    @Override
    public void doAction() throws BGException {
        Contract contract = null;
        try (ContractManager contractManager = new ContractManager(this.con);){
            contract = contractManager.getContractById(this.contractId);
        }
        StringBuilder emailMessage = new StringBuilder();
        emailMessage.append("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 " + contract.getTitle() + " [ " + contract.getComment() + " ]\n");
        emailMessage.append(this.getBillsInfo());
        String senderEmail = this.req.get("email", null);
        String comment = this.req.get("comment", "");
        String receiverEmail = this.moduleSetup.get("license.bills.email.to", "");
        if (Utils.notBlankString((String)senderEmail) && Utils.notBlankString((String)receiverEmail)) {
            if (Utils.notBlankString((String)comment)) {
                emailMessage.append("==========\n\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:\n");
                emailMessage.append(comment);
            }
            emailMessage.append("\nE-mail \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044f:" + senderEmail);
            MailMsg message = new MailMsg((Preferences)this.setup);
            if (Utils.notBlankString((String)receiverEmail)) {
                message.sendMessage(receiverEmail, "BGBilling", emailMessage.toString());
            }
        } else {
            this.context.getRequest().setAttribute("error", (Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f.");
        }
        this.context.getRequest().setAttribute("action", (Object)"Orders");
    }

    private String getBillsInfo() {
        String[] columnTitles = new String[]{"\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0432 \u043d\u0430\u043b\u0438\u0447\u0438\u0438", "\u041d\u0430 \u0441\u0443\u043c\u043c\u0443", "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0437\u0430\u043a\u0430\u0437\u0430\u043d\u043e", "\u041d\u0430 \u0441\u0443\u043c\u043c\u0443", "\u041e\u0431\u0449\u0435\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", "\u041d\u0430 \u0441\u0443\u043c\u043c\u0443", "\u041a \u043e\u043f\u043b\u0430\u0442\u0435"};
        StringBuilder bills = new StringBuilder();
        int rowIndex = 1;
        String title = this.req.get("title_" + rowIndex, null);
        bills.append(columnTitles[0] + " || " + columnTitles[1] + " | " + columnTitles[2] + " || " + columnTitles[3] + " | " + columnTitles[4] + " || " + columnTitles[5] + " | " + columnTitles[6] + " || " + columnTitles[7] + "\n");
        while (title != null) {
            bills.append(title + " || ");
            bills.append(this.req.get("existCount_" + rowIndex, "0") + " | ");
            bills.append(this.req.get("existCost_" + rowIndex, "0") + " || ");
            bills.append(this.req.get("newCount_" + rowIndex, "0") + " | ");
            bills.append(this.req.get("newCost_" + rowIndex, "0") + " || ");
            bills.append(this.req.get("totalCount_" + rowIndex, "0") + " | ");
            bills.append(this.req.get("totalCost_" + rowIndex, "0") + " || ");
            bills.append(this.req.get("paySum_" + rowIndex, "0") + "\n");
            title = this.req.get("title_" + ++rowIndex, null);
        }
        bills.append("\u0418\u0442\u043e\u0433\u043e \u043a \u043e\u043f\u043b\u0430\u0442\u0435: " + this.req.get("totalPaySum", "0") + "\n");
        return bills.toString();
    }
}

