/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.moneta.server.service;

import java.math.BigDecimal;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.ContractAutopaymentMode;
import ru.bitel.bgbilling.modules.moneta.common.bean.Transaction;
import ru.bitel.bgbilling.modules.moneta.common.service.MonetaService;
import ru.bitel.bgbilling.modules.moneta.server.bean.TransactionManager;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.moneta.common.service.MonetaService")
public class MonetaServiceImpl
extends AbstractService
implements MonetaService {
    private static final Logger logger = LogManager.getLogger();
    private TransactionManager manager;

    @PostConstruct
    private void init() {
        this.manager = new TransactionManager(this.getConnection(), this.moduleId);
    }

    public SearchResult<Transaction> searchTransactionList(int contractId, String contractTitle, String status, Period period, String[] sort, Page page) throws BGException {
        SearchResult transactionSearchResult = new SearchResult(period, page, sort);
        this.manager.searchTransaction((SearchResult<Transaction>)transactionSearchResult, contractId, contractTitle, status);
        return transactionSearchResult;
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        this.beginAutopaymentTransaction(contractId, amount, url, mode, params, null);
    }

    public void beginAutopaymentTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params, ContractAutopaymentMode autopaymentMode) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        super.beginAutopaymentTransaction(contractId, amount, url, mode, params, autopaymentMode);
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        if (logger.isDebugEnabled()) {
            logger.debug("endTransaction");
        }
    }
}

