/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.GenericOSMPTransactionManager;
import ru.bitel.common.Utils;

public class ColomnaTransactionManager
extends GenericOSMPTransactionManager {
    public ColomnaTransactionManager() {
        super(null, null, null, null, null, null);
    }

    private static String enc(String s) throws UnsupportedEncodingException {
        return s;
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        byte[] byArray;
        StringBuilder sb = new StringBuilder();
        BalanceUtils bu = new BalanceUtils(con);
        try {
            sb.append("result=").append(ColomnaTransactionManager.enc(String.valueOf(response.getResult()))).append('&');
            if (response.getTransId() != null) {
                sb.append(this.resultTxnID).append('=').append(ColomnaTransactionManager.enc(String.valueOf(response.getResult()))).append('&');
            }
            if (response.getAction() == 2) {
                sb.append(this.resultPrvTxnID).append('=').append(ColomnaTransactionManager.enc(String.valueOf(response.getId()))).append('&');
                sb.append("sum").append('=').append(ColomnaTransactionManager.enc(Utils.formatCost((BigDecimal)response.getSum()))).append('&');
            }
            if (response.getMessage() != null) {
                sb.append("comment").append('=').append(ColomnaTransactionManager.enc(response.getMessage())).append('&');
            }
            if (system.extAddBalanceInfo && response.getContract() != null && response.getTransId() != null) {
                BigDecimal balance = bu.getBalance(new Date(), response.getContract().getId());
                sb.append("account_balance").append('=').append(ColomnaTransactionManager.enc(Utils.formatCost((BigDecimal)balance))).append('&');
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            byArray = sb.toString().getBytes(this.getEncoding());
        }
        catch (Throwable throwable) {
            try {
                try {
                    bu.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return sb.toString().getBytes();
            }
        }
        bu.close();
        return byArray;
    }

    @Override
    public String getDefaultEncoding() {
        return "cp1251";
    }
}

