/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.Contract;
import java.io.StringReader;
import java.math.BigDecimal;
import java.security.PrivateKey;
import java.security.Signature;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class VtbTransactionManager
extends MPSTransactionManager {
    private static final String PARAM_BILLING_ID = "BillingID";
    private static final String PARAM_RESULT_CODE = "ResultCode";
    private static final String PARAM_BILLING_TIME = "BillingTime";
    private static final String TIME_FORMAT_VTB = "yyyy-MM-dd'T'hh:mm:ss";
    private static final TimeZone TIME_TZ_VTB = TimeZone.getTimeZone("Europe/Moscow");
    private static final int ACTION_REGISTRY = 20;
    private static final int ACTION_GETREGISTRYRESULT = 21;
    private static final int RESULT_CODE_OK = 0;
    private static Map<String, Registry> registries = new HashMap<String, Registry>();
    private static final Logger logger = LogManager.getLogger();
    private static final String XMLNS_BillingMessage = "http://vtb24.ru/schemas/billing/billing-message-1.1";
    private static final String XMLNS_Response = "http://vtb24.ru/schemas/billing/response-1.0";
    private static final String XMLNS_billing_registry = "http://schemas.vtb24.ru/BillingGateway/billing-registry-1.0";
    String[] XMLNS = new String[]{"xmlns=\"http://vtb24.ru/schemas/billing/billing-message-1.1\"", "xmlns=\"http://schemas.vtb24.ru/BillingGateway/billing-registry-1.0\""};

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            MPSRequest mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            mpsResponse.setAction(mpsRequest.getAction());
            logger.debug("mpsRequest.getAction()={}", (Object)mpsRequest.getAction());
            switch (mpsRequest.getAction()) {
                case 1: {
                    logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0443\u043c\u043c\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
                    if (mpsRequest.getSum().compareTo(system.minSumm) >= 0 && mpsRequest.getSum().compareTo(system.maxSumm) <= 0) {
                        logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                        Contract contract = this.actionCheck(mpsRequest);
                        logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043e\u043a. \u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0430\u0439\u0434\u0435\u043d, \u0441\u0443\u043c\u043c\u0430 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430.");
                        mpsResponse.setResult(0);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0451\u0436 \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0447\u0438\u0441\u043b\u0438\u0442\u044c \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + contract.getTitle() + " (contractId=" + contract.getId() + ")");
                        String billingName = Setup.getSetup().get("billing.name");
                        mpsResponse.getParameters().put(PARAM_BILLING_ID, String.valueOf((String)(billingName == null ? "" : billingName + "_") + System.currentTimeMillis()));
                        mpsResponse.getParameters().put(PARAM_BILLING_TIME, VtbTransactionManager.formatTime(new Date()));
                        mpsResponse.getParameters().put(PARAM_RESULT_CODE, "0");
                        break;
                    }
                    throw new MPSException(8, "\u0412\u0432\u0435\u0434\u0435\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430. \u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0441\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 " + system.minSumm + " " + Setup.getSetup().get("client.gui.currency.title.medium", "\u0440\u0443\u0431.;") + " \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 - " + system.maxSumm + " " + Setup.getSetup().get("client.gui.currency.title.medium", "\u0440\u0443\u0431."));
                }
                case 2: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction == null) {
                        logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0438 \u0435\u0433\u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435.");
                        Contract contract = this.actionCheck(mpsRequest);
                        transaction = this.addTransaction(con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getNumber(), mpsRequest.getType(), system.title);
                        logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043e\u043a. \u041a\u043e\u0434 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 {}", (Object)transaction.getId());
                        mpsResponse.setResult(0);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0447\u0438\u0441\u043b\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + contract.getTitle() + " (contractId=" + contract.getId() + ")");
                    } else {
                        Contract contract = this.actionCheck(mpsRequest);
                        mpsResponse.setResult(0);
                        mpsResponse.setMessage("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0443\u0436\u0435 \u0431\u044b\u043b \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + contract.getTitle() + " (contractId=" + contract.getId() + ")");
                    }
                    mpsResponse.getParameters().put(PARAM_BILLING_ID, String.valueOf(transaction.getId()));
                    mpsResponse.getParameters().put(PARAM_BILLING_TIME, VtbTransactionManager.formatTime(transaction.getLocalTime()));
                    mpsResponse.getParameters().put(PARAM_RESULT_CODE, "0");
                    break;
                }
                case 3: {
                    String status = null;
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction == null) {
                        status = "NotFound";
                        mpsResponse.setResult(0);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 " + mpsRequest.getTransId() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0435");
                    } else if (transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                        status = "Accepted";
                        mpsResponse.setResult(0);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 " + mpsRequest.getTransId() + " \u0431\u044b\u043b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0451\u043d");
                    } else {
                        status = "Cancelled";
                        mpsResponse.setResult(0);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 " + mpsRequest.getTransId() + " \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0435, \u043d\u043e \u043d\u0435 \u043f\u0440\u043e\u0432\u0435\u0434\u0451\u043d (\u043e\u0442\u043c\u0435\u043d\u0451\u043d?)");
                    }
                    String bankId = String.valueOf(mpsRequest.parameters.get("TechnologicalPartition.Properties.Property.BankID"));
                    mpsResponse.getParameters().put(PARAM_BILLING_ID, String.valueOf(transaction.getId()));
                    mpsResponse.getParameters().put("BankID", bankId);
                    mpsResponse.getParameters().put("Status", status);
                    break;
                }
                case 20: {
                    logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0441\u0432\u0435\u0440\u043a\u0438 \u0440\u0435\u0435\u0441\u0442\u0440\u043e\u0432 - \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0440\u0435\u0435\u0441\u0442\u0440\u0430");
                    String BankRegistryID = String.valueOf(mpsRequest.parameters.get("_BankRegistryID"));
                    String OperationTemplate = String.valueOf(mpsRequest.parameters.get("_OperationTemplate"));
                    Date date1 = VtbTransactionManager.parseTime(String.valueOf(mpsRequest.parameters.get("_BeginDate")));
                    Date date2 = VtbTransactionManager.parseTime(String.valueOf(mpsRequest.parameters.get("_EndDate")));
                    List operations = (List)mpsRequest.parameters.get("_Operations");
                    logger.debug("BankRegistryID={}, date={}-{}, operations={}", (Object)BankRegistryID, (Object)date1, (Object)date2, (Object)operations);
                    Registry registry = new Registry();
                    registry.date1 = date1;
                    registry.date2 = date2;
                    registry.operations = operations;
                    registries.put(BankRegistryID, registry);
                    mpsResponse.getParameters().put("OperationTemplate", OperationTemplate);
                    mpsResponse.getParameters().put("State", "AcceptedByBilling");
                    mpsResponse.getParameters().put("BankRegistryID", BankRegistryID);
                    mpsResponse.getParameters().put("BillingRegistryID", BankRegistryID);
                    break;
                }
                case 21: {
                    logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0441\u0432\u0435\u0440\u043a\u0438 \u0440\u0435\u0435\u0441\u0442\u0440\u043e\u0432 - \u0437\u0430\u043f\u0440\u043e\u0441 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0441\u0432\u0435\u0440\u043a\u0438");
                    String BankRegistryID = String.valueOf(mpsRequest.parameters.get("_BankRegistryID"));
                    String OperationTemplate = String.valueOf(mpsRequest.parameters.get("_OperationTemplate"));
                    logger.debug("BankRegistryID={}", (Object)BankRegistryID);
                    Registry reg = registries.getOrDefault(BankRegistryID, null);
                    if (reg == null) {
                        mpsResponse.getParameters().put("OperationTemplate", OperationTemplate);
                        mpsResponse.getParameters().put("State", "Error");
                        mpsResponse.getParameters().put("BankRegistryID", BankRegistryID);
                        break;
                    }
                    Date date1 = reg.date1;
                    Date date2 = reg.date2;
                    List<String> operations = reg.operations;
                    logger.debug("date={}-{}, operations={}", (Object)date1, (Object)date2, operations);
                    String state = "Success";
                    mpsResponse.getParameters().put("OperationTemplate", OperationTemplate);
                    mpsResponse.getParameters().put("State", state);
                    mpsResponse.getParameters().put("BankRegistryID", BankRegistryID);
                    mpsResponse.getParameters().put("BillingRegistryID", BankRegistryID);
                    mpsResponse.getParameters().put("BeginDate", VtbTransactionManager.formatTime(date1));
                    mpsResponse.getParameters().put("EndDate", VtbTransactionManager.formatTime(date2));
                    break;
                }
            }
        }
        catch (MPSException ex) {
            logger.error("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430", (Throwable)((Object)ex));
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            logger.error("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0431\u0449\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430", (Throwable)e);
            this.processError(new MPSException(-1, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u044b"), mpsResponse);
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        Element element;
        MPSRequest mpsRequest = new MPSRequest(con, moduleId, mpsId, request, system);
        logger.debug("\u0420\u0430\u0437\u0431\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 moduleId={}, mpsId={}", (Object)moduleId, (Object)mpsId);
        Document requestDocument = null;
        try {
            String doc = request.getReader().lines().collect(Collectors.joining("\n"));
            for (String xmlns : this.XMLNS) {
                doc = doc.replace(xmlns, "");
            }
            requestDocument = XMLUtils.parseDocument((InputSource)new InputSource(new StringReader(doc)));
        }
        catch (Exception e) {
            throw new MPSException(21, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 xml: " + e.getMessage());
        }
        String documentNodeName = requestDocument.getDocumentElement().getNodeName();
        logger.debug("documentNodeName={}", (Object)documentNodeName);
        if ("BillingMessage".equals(documentNodeName)) {
            element = XMLUtils.selectElement((Node)requestDocument, (String)"/BillingMessage/*");
            if (element == null) {
                throw new MPSException(21, "billing message \"/BillingMessage/*\" not found!");
            }
            String messageType = element.getNodeName();
            logger.debug("messageType={}", (Object)messageType);
            switch (messageType) {
                case "Check": {
                    mpsRequest.setAction(1);
                    break;
                }
                case "Pay": {
                    mpsRequest.setAction(2);
                    break;
                }
                case "CheckStatus": {
                    mpsRequest.setAction(3);
                    break;
                }
                default: {
                    throw new MPSException(21, "billing message type \"" + messageType + "\" not supported!");
                }
            }
            this.parseOperationElement(mpsRequest, element, system.config);
        } else if ("billing-registry".equals(documentNodeName)) {
            element = XMLUtils.selectElement((Node)requestDocument, (String)"/billing-registry/*");
            if (element == null) {
                throw new MPSException(21, "billing registry \"/billing-registry/*\" not found!");
            }
            String registryType = element.getNodeName();
            logger.debug("registryType={}", (Object)registryType);
            switch (registryType) {
                case "Registry": {
                    mpsRequest.setAction(20);
                    mpsRequest.parameters.put("_BankRegistryID", XMLUtils.getAttribute((Element)element, (String)"BankRegistryID"));
                    mpsRequest.parameters.put("_BeginDate", XMLUtils.getAttribute((Element)element, (String)"BeginDate"));
                    mpsRequest.parameters.put("_EndDate", XMLUtils.getAttribute((Element)element, (String)"EndDate"));
                    mpsRequest.parameters.put("_OperationTemplate", XMLUtils.getAttribute((Element)element, (String)"OperationTemplate"));
                    ArrayList<String> operations = new ArrayList<String>();
                    for (Element operationElement : XMLUtils.selectElements((Node)element, (String)"/Operation/*")) {
                        operations.add(XMLUtils.getAttribute((Element)operationElement, (String)"Uni"));
                    }
                    mpsRequest.parameters.put("_Operations", operations);
                    break;
                }
                case "GetRegistryResult": {
                    mpsRequest.setAction(21);
                    mpsRequest.parameters.put("_BankRegistryID", XMLUtils.getAttribute((Element)element, (String)"BankRegistryID"));
                    mpsRequest.parameters.put("_OperationTemplate", XMLUtils.getAttribute((Element)element, (String)"OperationTemplate"));
                    break;
                }
                default: {
                    throw new MPSException(21, "billing registry type \"" + registryType + "\" not supported!");
                }
            }
        } else {
            throw new MPSException(21, "document name \"" + documentNodeName + "\" not supported!");
        }
        return mpsRequest;
    }

    private void parseOperationElement(MPSRequest mpsRequest, Element messageElement, ParameterMap systemParams) throws MPSException {
        Element operationElement = XMLUtils.selectElement((Node)messageElement, (String)"Operation");
        if (operationElement == null) {
            throw new MPSException(21, "Element \"Operation\" not found!");
        }
        this.parseAttrElement(operationElement, mpsRequest.parameters);
        this.parseAttrElement(XMLUtils.selectElement((Node)operationElement, (String)"SourceFunds"), mpsRequest.parameters);
        this.parseAttrElement(XMLUtils.selectElement((Node)operationElement, (String)"InfoPeriod"), mpsRequest.parameters);
        this.parsePartitionElement(operationElement, "//InfoPartition/Properties/Property", "Name", "Value", mpsRequest.parameters);
        this.parsePartitionElement(operationElement, "//TechnologicalPartition/Properties/Property", "Name", "Value", mpsRequest.parameters);
        String accountPath = systemParams.get("accountPath", "InfoPartition.Properties.Property.Phone");
        Object accountValue = mpsRequest.parameters.getOrDefault(accountPath, null);
        if (accountValue == null) {
            throw new MPSException(21, "\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0437\u0430\u0434\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"mps.<mpsId>.accountPath=" + accountPath + "\" (\u0438\u043b\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u043e \u044d\u0442\u043e\u043c\u0443 \u043f\u0443\u0442\u0438 \u043d\u0438\u0447\u0435\u0433\u043e \u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0435)");
        }
        mpsRequest.setNumber(String.valueOf(accountValue));
        mpsRequest.setType(0);
        mpsRequest.setTransId(String.valueOf(mpsRequest.parameters.get("Operation.Uni")));
        mpsRequest.setTime(VtbTransactionManager.parseTime(String.valueOf(mpsRequest.parameters.get("Operation.DateOperation"))));
        mpsRequest.setSum(Utils.parseBigDecimal((String)String.valueOf(mpsRequest.parameters.get("Operation.Amount")), (BigDecimal)BigDecimal.ZERO));
    }

    private void parsePartitionElement(Element element, String path, String attrName, String attrValue, Map<String, Object> attrMap) {
        String prefix = path.substring(2).replace("/", ".") + ".";
        for (Element propertyElement : XMLUtils.selectElements((Node)element, (String)path)) {
            attrMap.put(prefix + propertyElement.getAttribute(attrName), propertyElement.getAttribute(attrValue));
            if (!logger.isDebugEnabled()) continue;
            logger.debug("parsePartitionElement: " + prefix + propertyElement.getAttribute(attrName) + "=" + propertyElement.getAttribute(attrValue));
        }
    }

    private void parseAttrElement(Element element, Map<String, Object> attrMap) {
        if (element != null) {
            String prefix = element.getNodeName() + ".";
            NamedNodeMap namedNodeMap = element.getAttributes();
            if (namedNodeMap != null) {
                for (int index = 0; index < namedNodeMap.getLength(); ++index) {
                    Node attr = namedNodeMap.item(index);
                    attrMap.put(prefix + attr.getNodeName(), attr.getNodeValue());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("parseAttrElement: " + prefix + attr.getNodeName() + "=" + attr.getNodeValue());
                }
            }
        }
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        logger.error("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + ex.getMessage());
        response.setAction(0);
        response.setResult(ex.getErrorCode());
        response.setMessage(ex.getErrorMessage());
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        return null;
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse mpsResponse) {
        Document doc = this.documentBuilder.newDocument();
        Element resultElement = null;
        switch (mpsResponse.getAction()) {
            default: {
                Element rootNode1 = XMLUtils.createElementNS((Document)doc, (String)XMLNS_Response, (String)"Response");
                resultElement = XMLUtils.createElement((Element)rootNode1, (String)"Result");
                break;
            }
            case 20: 
            case 21: {
                Element rootNode2 = XMLUtils.createElementNS((Document)doc, (String)XMLNS_billing_registry, (String)"billing-registry");
                resultElement = XMLUtils.createElement((Element)rootNode2, (String)"RegistryResult");
            }
        }
        switch (mpsResponse.getAction()) {
            case 1: 
            case 2: {
                resultElement.setAttribute("resultCode", "OK");
                resultElement.setAttribute("message", Utils.maskBlank((String)mpsResponse.getMessage(), (String)""));
                VtbTransactionManager.addParamToResult(mpsResponse, resultElement, PARAM_BILLING_ID);
                VtbTransactionManager.addParamToResult(mpsResponse, resultElement, PARAM_BILLING_TIME);
                VtbTransactionManager.addParamToResult(mpsResponse, resultElement, PARAM_RESULT_CODE);
                break;
            }
            case 3: {
                resultElement.setAttribute("resultCode", "OK");
                resultElement.setAttribute("message", Utils.maskBlank((String)mpsResponse.getMessage(), (String)""));
                VtbTransactionManager.addParamToResult(mpsResponse, resultElement, PARAM_BILLING_ID);
                VtbTransactionManager.addParamToResult(mpsResponse, resultElement, "BankID");
                VtbTransactionManager.addParamToResult(mpsResponse, resultElement, "Status");
                break;
            }
            case 20: {
                VtbTransactionManager.addParamToAttr(mpsResponse, resultElement, "OperationTemplate");
                VtbTransactionManager.addParamToAttr(mpsResponse, resultElement, "State");
                VtbTransactionManager.addParamToAttr(mpsResponse, resultElement, "BankRegistryID");
                VtbTransactionManager.addParamToAttr(mpsResponse, resultElement, "BillingRegistryID");
                break;
            }
            case 21: {
                VtbTransactionManager.addParamToAttr(mpsResponse, resultElement, "OperationTemplate");
                VtbTransactionManager.addParamToAttr(mpsResponse, resultElement, "State");
                VtbTransactionManager.addParamToAttr(mpsResponse, resultElement, "BankRegistryID");
                VtbTransactionManager.addParamToAttr(mpsResponse, resultElement, "BillingRegistryID");
                VtbTransactionManager.addParamToAttr(mpsResponse, resultElement, "BeginDate");
                VtbTransactionManager.addParamToAttr(mpsResponse, resultElement, "EndDate");
                break;
            }
            default: {
                resultElement.setAttribute("resultCode", "ERROR");
                resultElement.setAttribute("errorCode", String.valueOf(mpsResponse.getResult()));
                resultElement.setAttribute("message", Utils.maskBlank((String)mpsResponse.getMessage(), (String)"\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430"));
            }
        }
        byte[] bytes = this.xmlSerialize(doc);
        String x_sign = null;
        try {
            logger.debug("\u041f\u043e\u0434\u043f\u0438\u0441\u044c \u0441 private key \"{}\"", (Object)Utils.maskBlank((String)system.privateKeyAlias, (String)"<\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e>"));
            PrivateKey privateKey = system.getPrivateKey();
            if (privateKey == null) {
                throw new Exception("\u041f\u0440\u0438\u0432\u0430\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u043a\u0430\u043a\u0430\u044f-\u0442\u043e \u043e\u0448\u0438\u0431\u043a\u0430");
            }
            Signature sign = Signature.getInstance("MD5withRSA");
            sign.initSign(privateKey);
            sign.update(bytes);
            x_sign = Base64.getEncoder().encodeToString(sign.sign());
        }
        catch (Exception ex) {
            logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u0438", (Throwable)ex);
            x_sign = "error billing sign";
        }
        mpsResponse.getResponse().setHeader("x-sign", x_sign);
        return bytes;
    }

    private static void addParamToResult(MPSResponse response, Element resultElement, String name) {
        if (response.getParameters().containsKey(name)) {
            Element paramElement = XMLUtils.createElement((Element)resultElement, (String)"Param");
            paramElement.setAttribute("name", name);
            paramElement.setAttribute("value", response.getParameters().get(name).toString());
        }
    }

    private static void addParamToAttr(MPSResponse response, Element resultElement, String name) {
        if (response.getParameters().containsKey(name)) {
            resultElement.setAttribute(name, response.getParameters().get(name).toString());
        }
    }

    private static String formatTime(Date date) {
        return String.valueOf(TimeUtils.format((Date)date, (String)TIME_FORMAT_VTB, (TimeZone)TIME_TZ_VTB));
    }

    private static Date parseTime(String date) {
        return TimeUtils.parseDate((String)date, (String)TIME_FORMAT_VTB, (TimeZone)TIME_TZ_VTB);
    }

    private static class Registry {
        Date date1;
        Date date2;
        List<String> operations;

        private Registry() {
        }
    }
}

