/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.action;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.npay.server.Recalculator;
import ru.bitel.bgbilling.modules.npay.server.action.base.ActionBase;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class ActionRecalculatePay
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        String email = this.getParameter("mail");
        int serviceSet = this.getIntParameter("service_set", 0);
        String cids = this.getParameter("cids");
        List contractLabelIds = Utils.toIntegerList((String)this.getParameter("contractGroups"));
        String comment = this.getParameter("comment");
        Period period = this.getPeriod();
        boolean detail = this.getBooleanParameter("detail", true);
        Date date = this.getDateParameter("date");
        if (date != null) {
            period.setDateFrom(date);
            period.setDateTo(date);
        }
        if (this.mid < 0) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 mid=" + this.mid);
        }
        Calendar cal = null;
        cal = period.getDateFrom() != null ? period.getDateFromCalendar() : new GregorianCalendar();
        cal.set(5, 1);
        period.setDateFrom(cal.getTime());
        cal = period.getDateFrom() != null ? period.getDateToCalendar() : new GregorianCalendar();
        cal.set(5, cal.getActualMaximum(5));
        period.setDateTo(cal.getTime());
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionRecalculatePay", (int)this.mid, (int)this.userId);
        if (closedDate != null) {
            try {
                ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (Date)period.getDateFrom());
            }
            catch (BGMessageException ex) {
                throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043f\u0435\u0440\u0435\u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u0435");
            }
        }
        if (TimeUtils.monthsDelta((Calendar)new GregorianCalendar(), (Calendar)period.getDateToCalendar()) > 0) {
            throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0443 \u0437\u0430 \u0431\u0443\u0434\u0443\u0449\u0438\u0435 \u043c\u0435\u0441\u044f\u0446\u044b!");
        }
        cal = period.getDateFromCalendar();
        while (cal.getTime().before(period.getDateTo())) {
            new RunTaskDataManager(this.con).addTask((RunTask)new Recalculator(this.mid, cal, email, serviceSet, cids, contractLabelIds, comment, detail));
            cal.add(2, 1);
        }
    }
}

