/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.dao.AbstarctDaoConstant;

public class NPayServiceStatusDao
extends AbstarctDaoConstant {
    public static final String TABLE_NPAY_SERVICE_STATUS_MATRIX = "npay_service_status_matrix";
    private Logger logger = LogManager.getLogger();
    private int moduleId = 0;
    private Connection con = null;

    public NPayServiceStatusDao(Connection con, int moduleId) {
        this.con = con;
        this.moduleId = moduleId;
    }

    public Boolean[][] getServiceStatusValues(List<Integer> serviceIds, List<Integer> statusIds) throws BGException {
        Boolean[][] values = null;
        if (serviceIds != null && statusIds != null) {
            values = new Boolean[serviceIds.size()][statusIds.size()];
            for (int i1 = 0; i1 < serviceIds.size(); ++i1) {
                for (int i2 = 0; i2 < statusIds.size(); ++i2) {
                    values[i1][i2] = false;
                }
            }
            String query = "SELECT `service_id`, `status_id`, `value` FROM npay_service_status_matrix WHERE module_id=?";
            try (PreparedStatement psSelect = this.con.prepareStatement(query);){
                psSelect.setInt(1, this.moduleId);
                ResultSet resultSet = psSelect.executeQuery();
                while (resultSet.next()) {
                    int i1 = serviceIds.indexOf(resultSet.getInt("service_id"));
                    int i2 = statusIds.indexOf(resultSet.getInt("status_id"));
                    if (i1 <= -1 || i2 <= -1) continue;
                    values[i1][i2] = resultSet.getBoolean("value");
                }
                resultSet.close();
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                throw new BGException((Throwable)e);
            }
        }
        return values;
    }

    public void updateServiceStatusValues(List<Integer> serviceIds, List<Integer> statusIds, Boolean[][] values) throws BGException {
        if (serviceIds != null && statusIds != null) {
            String query = "REPLACE INTO npay_service_status_matrix SET `module_id`=?, `service_id`=?, `status_id`=?, `value`=?";
            try (PreparedStatement psUpdate = this.con.prepareStatement(query);){
                psUpdate.setInt(1, this.moduleId);
                int l1 = serviceIds.size();
                for (int i1 = 0; i1 < l1; ++i1) {
                    psUpdate.setInt(2, serviceIds.get(i1));
                    int l2 = statusIds.size();
                    for (int i2 = 0; i2 < l2; ++i2) {
                        psUpdate.setInt(3, statusIds.get(i2));
                        psUpdate.setBoolean(4, values[i1][i2]);
                        psUpdate.executeUpdate();
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                throw new BGException((Throwable)e);
            }
        }
    }
}

