/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.bean.account;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.npay.server.bean.account.ModuleAccount;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class InetModuleAccount
extends ModuleAccount {
    private static Logger log = LogManager.getLogger();

    @Override
    public BigDecimal getPeriodAccount(Connection con, int contractId, Calendar from, Calendar to) {
        Calendar afterTo;
        StringBuilder query;
        BigDecimal result = BigDecimal.ZERO;
        String sessionAccount = ServerUtils.getModuleMonthTableName((String)"inet_session_log_account", (Date)from.getTime(), (int)this.getModleId());
        String sessionTable = ServerUtils.getModuleMonthTableName((String)"inet_session_log", (Date)from.getTime(), (int)this.getModleId());
        if (ServerUtils.tableExists((Connection)con, (String)sessionTable)) {
            query = new StringBuilder(200);
            query.append("SELECT ROUND(SUM(session_account.account), 2) FROM ");
            query.append(sessionAccount);
            query.append(" AS session_account INNER JOIN ");
            query.append(sessionTable);
            query.append(" AS session ON session_account.sessionId=session.id");
            query.append(" WHERE session_account.contractId=? ");
            if (from.get(5) != 1) {
                query.append(" AND session.sessionStart>='");
                query.append(TimeUtils.formatSQLDate((Date)from.getTime()));
                query.append("'");
            }
            if (to.get(5) != to.getActualMaximum(5)) {
                afterTo = (Calendar)to.clone();
                afterTo.add(5, 1);
                query.append(" AND session.sessionStart<'");
                query.append(TimeUtils.formatSQLDate((Date)afterTo.getTime()));
                query.append("'");
            }
            if (Utils.notBlankString((String)this.getSids())) {
                query.append(" AND session_account.serviceId IN ( ");
                query.append(this.getSids());
                query.append(" ) ");
            }
            try (PreparedStatement ps = con.prepareStatement(query.toString());){
                ps.setInt(1, contractId);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        result = Utils.maskNull((BigDecimal)rs.getBigDecimal(1));
                    }
                }
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
        }
        query = new StringBuilder(200);
        query.append("SELECT ROUND(SUM(session_account.account), 2) FROM ");
        query.append("inet_session_account_").append(this.getModleId());
        query.append(" AS session_account INNER JOIN ");
        query.append("inet_session_").append(this.getModleId());
        query.append(" AS session ON session_account.sessionId=session.id");
        query.append(" WHERE session_account.contractId=? ");
        query.append(" AND session.sessionStart>='");
        query.append(TimeUtils.formatSQLDate((Date)from.getTime()));
        query.append("'");
        afterTo = (Calendar)to.clone();
        afterTo.add(5, 1);
        query.append(" AND session.sessionStart<'");
        query.append(TimeUtils.formatSQLDate((Date)afterTo.getTime()));
        query.append("'");
        if (Utils.notBlankString((String)this.getSids())) {
            query.append(" AND session_account.serviceId IN ( ");
            query.append(this.getSids());
            query.append(" ) ");
        }
        try (PreparedStatement ps = con.prepareStatement(query.toString());){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                BigDecimal r;
                if (rs.next() && (r = rs.getBigDecimal(1)) != null) {
                    result = result.add(r);
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return result;
    }
}

