/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.service;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.common.service.NPayService;
import ru.bitel.bgbilling.modules.npay.server.bean.NPayServiceStatusDao;
import ru.bitel.bgbilling.modules.npay.server.bean.object.ServiceObjectManager;
import ru.bitel.bgbilling.modules.npay.server.bean.sets.ServiceSetManager;
import ru.bitel.bgbilling.modules.npay.server.utils.NpayUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.npay.common.service.NPayService")
public class NPayServiceImpl
extends AbstractService
implements NPayService {
    public BigDecimal precalculateAccount(int contractId, int serviceSet, Date dateFrom, Date dateTo) throws BGException, BGMessageException, BGIllegalAccessException {
        return NpayUtils.precalculateAccount(this.moduleId, serviceSet, contractId, dateFrom, dateTo);
    }

    public BigDecimal getAmountForUnlock(int contractId) throws BGException, BGMessageException, BGIllegalAccessException {
        return NpayUtils.getAmountForUnlock(this.getConnection(), this.moduleId, contractId);
    }

    public ServiceObject serviceObjectGet(int id) throws BGException, BGMessageException {
        return new ServiceObjectManager(this.getConnection(), this.moduleId).getServiceObject(id);
    }

    public void serviceObjectUpdate(ServiceObject serviceObject) throws BGException, BGMessageException {
    }

    public void serviceObjectDelete(int id) throws BGException, BGMessageException {
    }

    public Boolean[][] serviceStatusMatrixGet(List<Integer> serviceIds, List<Integer> statusIds) throws BGException, BGMessageException {
        return new NPayServiceStatusDao(this.getConnection(), this.moduleId).getServiceStatusValues(serviceIds, statusIds);
    }

    public void serviceStatusMatrixUpdate(List<Integer> serviceIds, List<Integer> statusIds, Boolean[][] values) throws BGException, BGMessageException {
        new NPayServiceStatusDao(this.getConnection(), this.moduleId).updateServiceStatusValues(serviceIds, statusIds, values);
    }

    public Collection<String> serviceSetGet(int serviceSetId) throws BGException, BGMessageException {
        ServiceSetManager setManager = new ServiceSetManager(this.getConnection(), this.moduleId, (Preferences)Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)));
        return Utils.toSet((String)setManager.getServiceSetMap().get(serviceSetId).getSidList());
    }
}

