/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.tariff;

import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.bean.ServiceDao;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.npay.server.bean.NPayServiceStatusDao;
import ru.bitel.bgbilling.modules.npay.server.bean.account.ModuleAccount;
import ru.bitel.bgbilling.modules.npay.server.bean.account.ModuleAccountManager;
import ru.bitel.bgbilling.modules.npay.server.bean.amount.ModuleAmount;
import ru.bitel.bgbilling.modules.npay.server.bean.amount.ModuleAmountManager;
import ru.bitel.bgbilling.modules.npay.server.bean.quantity.ModuleQuantity;
import ru.bitel.bgbilling.modules.npay.server.bean.quantity.ModuleQuantityManger;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class NPayTariffContext
extends TariffContext {
    private static final Logger log = LogManager.getLogger();
    private static final String MODE_SERVICE_STATUS_MATRIX = "matrix";
    private String serviceStatusMode;
    private int moduleId;
    private Calendar startMonth;
    private Calendar endMonth;
    private String cids;
    private List<Integer> contractLabelIds;
    private String serviceList;
    private Map<Integer, ModuleAmount> moduleAmountMap;
    private Map<Integer, ModuleAccount> moduleAccountMap;
    private Map<Integer, ModuleQuantity> moduleQuantityMap;
    private Period precalcOpenPeriod;
    private Calendar currentDay;
    private Map<Integer, Map<Integer, List<Period>>> suspendPeriodsMap;
    private Map<Integer, Set<Integer>> serviceNoSuspend = new HashMap<Integer, Set<Integer>>();
    private Map<Integer, Map<Integer, Integer>> wrapService = new HashMap<Integer, Map<Integer, Integer>>();

    public NPayTariffContext(Preferences moduleSetup, Connection con, int moduleId, Calendar startMonth, Calendar endMonth, Calendar currentDay, String cids, List<Integer> contractLabelIds, String serviceList) throws BGException {
        super(new MathContext(12, RoundingMode.HALF_UP), startMonth.getTime());
        String value;
        String key;
        this.moduleId = moduleId;
        this.moduleAmountMap = new ModuleAmountManager(moduleSetup).getModuleAmountMap();
        this.moduleAccountMap = new ModuleAccountManager(moduleSetup).getModuleAccountMap();
        this.moduleQuantityMap = new ModuleQuantityManger(moduleSetup).getQuantityMap();
        this.startMonth = (Calendar)startMonth.clone();
        this.endMonth = (Calendar)endMonth.clone();
        this.cids = cids;
        this.contractLabelIds = contractLabelIds;
        this.serviceList = serviceList;
        this.serviceStatusMode = moduleSetup.get("npay.service.status.mode", MODE_SERVICE_STATUS_MATRIX);
        for (Map.Entry me : moduleSetup.sub("wrap.service.").entrySet()) {
            key = (String)me.getKey();
            value = (String)me.getValue();
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            StringTokenizer st = new StringTokenizer(value, ";,");
            while (st.hasMoreTokens()) {
                String[] from_to = st.nextToken().split(":");
                if (from_to.length != 2) continue;
                map.put(Utils.parseInt((String)from_to[0]), Utils.parseInt((String)from_to[1]));
            }
            if (map.size() <= 0) continue;
            for (Integer statusCode : Utils.toIntegerList((String)key)) {
                this.wrapService.put(statusCode, map);
            }
        }
        if (MODE_SERVICE_STATUS_MATRIX.equals(this.serviceStatusMode)) {
            try (ServiceDao serviceDao = new ServiceDao(con);){
                List services = serviceDao.list(moduleId);
                List statusList = StatusCache.getInstance().getStatusList();
                Boolean[][] values = new NPayServiceStatusDao(con, moduleId).getServiceStatusValues(services.stream().map(a -> a.getId()).collect(Collectors.toList()), statusList.stream().map(a -> a.getId()).collect(Collectors.toList()));
                int l2 = statusList.size();
                for (int i2 = 0; i2 < l2; ++i2) {
                    HashSet<Integer> serviceSet = new HashSet<Integer>();
                    int l1 = services.size();
                    for (int i1 = 0; i1 < l1; ++i1) {
                        if (values[i1][i2] == null || !values[i1][i2].booleanValue()) continue;
                        serviceSet.add(((Service)services.get(i1)).getId());
                    }
                    if (serviceSet.isEmpty()) continue;
                    this.serviceNoSuspend.put(((Status)statusList.get(i2)).getId(), serviceSet);
                }
            }
        } else {
            for (Map.Entry me : moduleSetup.sub("service.no.suspend.").entrySet()) {
                key = (String)me.getKey();
                value = (String)me.getValue();
                Set serviceSet = Utils.toIntegerSet((String)value);
                if (serviceSet.size() <= 0) continue;
                for (Integer statusCode : Utils.toIntegerList((String)key)) {
                    this.serviceNoSuspend.put(statusCode, serviceSet);
                }
            }
        }
        this.loadSuspendMap(con);
        this.currentDay = currentDay;
    }

    public ModuleAmount getModuleAmount(int amountType) {
        return this.moduleAmountMap.get(amountType);
    }

    public ModuleAccount getModuleAccount(int accountType) {
        return this.moduleAccountMap.get(accountType);
    }

    public ModuleQuantity getModuleQuantity(int sid) {
        return this.moduleQuantityMap.get(sid);
    }

    public Map<Integer, List<Period>> getSuspendPeriods(int contractId, int serviceId) {
        HashMap<Integer, List<Period>> result = new HashMap<Integer, List<Period>>();
        Map<Integer, List<Period>> contractSuspendedPeriods = this.suspendPeriodsMap.get(contractId);
        if (contractSuspendedPeriods != null) {
            for (Map.Entry<Integer, List<Period>> me : contractSuspendedPeriods.entrySet()) {
                Integer status = me.getKey();
                Set<Integer> noSuspendSids = this.serviceNoSuspend.get(status);
                if (noSuspendSids != null && noSuspendSids.contains(serviceId)) continue;
                result.put(me.getKey(), me.getValue());
            }
        }
        return result;
    }

    public void setPrecalcOpenPeriod(Period per) {
        this.precalcOpenPeriod = new Period(this.trimByMonthStart(per.getDateFrom()), this.trimByMonthEnd(per.getDateTo()));
    }

    public Period getPrecalcOpenPeriod() {
        return this.precalcOpenPeriod;
    }

    public Calendar getCurrentDay() {
        return this.currentDay;
    }

    public Integer getWrapService(int serviceId, int status) {
        Map<Integer, Integer> serviceMap = this.wrapService.get(status);
        if (serviceMap != null && serviceMap.containsKey(serviceId)) {
            return serviceMap.get(serviceId);
        }
        return 0;
    }

    private void loadSuspendMap(Connection con) {
        HashMap<Integer, Map<Integer, List<Period>>> suspendMap = new HashMap<Integer, Map<Integer, List<Period>>>();
        Set suspendStatusSet = StatusCache.getInstance().getModuleSuspendStatusSet(this.moduleId);
        if (suspendStatusSet.size() > 0 || MODE_SERVICE_STATUS_MATRIX.equals(this.serviceStatusMode)) {
            try {
                String contractJoin = "";
                if (Utils.isBlankString((String)this.cids) && this.contractLabelIds != null && !this.contractLabelIds.isEmpty()) {
                    contractJoin = " INNER JOIN contract ON contract.id=status.cid ";
                }
                String query = "SELECT status.cid, status.date1, status.date2, status.status FROM contract_status AS status LEFT JOIN contract_module ON status.cid=contract_module.cid " + contractJoin + "WHERE " + (String)(MODE_SERVICE_STATUS_MATRIX.equals(this.serviceStatusMode) ? "" : "status.status IN (" + Utils.toString((Iterable)suspendStatusSet) + ") AND ") + "(status.date1 IS NULL OR status.date1<=?) AND (status.date2 IS NULL OR status.date2>=?) AND contract_module.mid=" + this.moduleId;
                if (Utils.notBlankString((String)this.cids)) {
                    query = query + " AND status.cid IN (" + this.cids + ")";
                } else if (this.contractLabelIds != null && !this.contractLabelIds.isEmpty()) {
                    query = query + " AND contract.id IN (SELECT cll.contract_id FROM contract_label_link AS cll WHERE label_id IN ( " + Utils.toString(this.contractLabelIds) + " ))";
                }
                query = query + " ORDER BY status.cid, status.date1";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)this.endMonth));
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)this.startMonth));
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    ArrayList<Period> periodList;
                    int cid = rs.getInt(1);
                    Period period = new Period(this.trimByMonthStart(rs.getDate(2)), this.trimByMonthEnd(rs.getDate(3)));
                    int status = rs.getInt(4);
                    HashMap<Integer, ArrayList<Period>> contactSuspendMap = (HashMap<Integer, ArrayList<Period>>)suspendMap.get(cid);
                    if (contactSuspendMap == null) {
                        contactSuspendMap = new HashMap<Integer, ArrayList<Period>>(2);
                        suspendMap.put(cid, contactSuspendMap);
                    }
                    if ((periodList = (ArrayList<Period>)contactSuspendMap.get(status)) == null) {
                        periodList = new ArrayList<Period>(2);
                        contactSuspendMap.put(status, periodList);
                    }
                    periodList.add(period);
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.suspendPeriodsMap = suspendMap;
    }

    private Date trimByMonthEnd(Date date) {
        if (date == null || TimeUtils.dateBefore((Date)this.endMonth.getTime(), (Date)date)) {
            date = ((Calendar)this.endMonth.clone()).getTime();
        }
        return date;
    }

    private Date trimByMonthStart(Date date1) {
        if (date1 == null || TimeUtils.dateBefore((Date)date1, (Date)this.startMonth.getTime())) {
            date1 = ((Calendar)this.startMonth.clone()).getTime();
        }
        return date1;
    }

    public void setModuleAmountMap(Map<Integer, ModuleAmount> moduleAmountMap) {
        this.moduleAmountMap = moduleAmountMap;
    }

    public void setModuleAccountMap(Map<Integer, ModuleAccount> moduleAccountMap) {
        this.moduleAccountMap = moduleAccountMap;
    }

    public void setModuleQuantityMap(Map<Integer, ModuleQuantity> moduleQuantityMap) {
        this.moduleQuantityMap = moduleQuantityMap;
    }
}

