/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.tariff;

import java.math.BigDecimal;
import java.util.Calendar;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.worker.ThreadContext;

public class OptionTariffTreeNode
extends TariffTreeNode<AbstractTariffRequest<?>, TariffContext, TreeContext, ThreadContext> {
    private static final int MODE_ON = 0;
    private static final int MODE_PROPORTIONAL = 1;
    private static final int MODE_PROPORTIONAL_COUNT = 2;
    private final int mode;
    private final boolean add;
    private final Integer option;

    public OptionTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.option = parameterMap.getInt("option", -1);
        this.add = parameterMap.getInt("add", -1) > 0;
        this.mode = parameterMap.getInt("mode", 0);
    }

    public int execute(Long treeNodeId, Long parentTreeNodeId, AbstractTariffRequest<?> req, TariffTreeNodeHolder holder, TariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        if (this.option > 0) {
            ContractTariffOptionList options = ctx.getContractTariffOptionList(req.getConnectionSet(), req.contractId);
            long count = switch (this.mode) {
                case 0, 2 -> options.count(this.option.intValue(), TimeUtils.convertCalendarToDate((Calendar)req.serviceCost.date1), TimeUtils.convertCalendarToDate((Calendar)req.serviceCost.date2));
                default -> options.countMillis(this.option.intValue(), TimeUtils.convertCalendarToDate((Calendar)req.serviceCost.date1), TimeUtils.convertCalendarToDate((Calendar)req.serviceCost.date2));
            };
            if (count > 0L) {
                BigDecimal parentCost = req.serviceCost.cost;
                super.execute(treeNodeId, parentTreeNodeId, req, holder, ctx, treeContext, workerContext);
                BigDecimal cost = req.serviceCost.cost != null ? req.serviceCost.cost : BigDecimal.ZERO;
                switch (this.mode) {
                    case 2: {
                        cost = cost.multiply(BigDecimal.valueOf(count), ctx.mc);
                        break;
                    }
                    case 1: {
                        count = (count + 1L) / 1000L;
                        cost = cost.multiply(BigDecimal.valueOf(count), ctx.mc).divide(BigDecimal.valueOf((req.serviceCost.date2.getTimeInMillis() - req.serviceCost.date1.getTimeInMillis() + 1L) / 1000L), ctx.mc);
                        break;
                    }
                }
                req.serviceCost.cost = this.add && parentCost != null ? parentCost.add(cost, ctx.mc) : cost;
                return 1;
            }
        }
        return 0;
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, AbstractTariffRequest<?> req, TariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        return 1;
    }
}

