/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.task;

import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import bitel.billing.server.admin.errorlog.bean.PeriodicErrorManager;
import bitel.billing.server.contract.bean.ContractTariff;
import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.events.CalculateEvent;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTree;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.server.bean.account.ModuleAccount;
import ru.bitel.bgbilling.modules.npay.server.bean.amount.ModuleAmount;
import ru.bitel.bgbilling.modules.npay.server.bean.quantity.ModuleQuantity;
import ru.bitel.bgbilling.modules.npay.server.bean.sets.ServiceSet;
import ru.bitel.bgbilling.modules.npay.server.bean.sets.ServiceSetManager;
import ru.bitel.bgbilling.modules.npay.server.calculate.AddCostItem;
import ru.bitel.bgbilling.modules.npay.server.calculate.AmountDetail;
import ru.bitel.bgbilling.modules.npay.server.calculate.AmountDetailCache;
import ru.bitel.bgbilling.modules.npay.server.calculate.ServiceConfigCache;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayServiceCost;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffContext;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffRequest;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public class Calculator
extends TaskBase {
    private Calendar startMonth;
    private Calendar endMonth;
    private int daysInMonth;
    private NPayTariffContext context;
    private String cids;
    private List<Integer> contractLabelIds;
    private boolean preCalcMode;
    private Calendar activeFromDate;
    private List<ServiceObject> serviceObjectList;
    private List<ContractTariff> tariffList;
    private boolean tariffOptionEnable = true;
    private boolean calcErrors = false;
    private Map<Integer, ModuleAmount> moduleAmountMap = null;
    private Map<Integer, ModuleAccount> moduleAccountMap = null;
    private Map<Integer, ModuleQuantity> moduleQuantityMap = null;
    private ServiceCostCache costCache = new ServiceCostCache();
    private AmountDetailCache amountDetailCache = new AmountDetailCache();
    private AddCostDetail addCostDetail = new AddCostDetail();
    private ServiceConfigCache configCache = new ServiceConfigCache();
    private PeriodicErrorManager errorManager;
    private ConnectionSet connectionSet;
    private Connection con;
    private Connection conSlave;
    private Map<Integer, SoftReference<Map<Integer, Map<Integer, TariffModuleTreeSet>>>> treeSetMap = new HashMap<Integer, SoftReference<Map<Integer, Map<Integer, TariffModuleTreeSet>>>>(1024);

    public void setCids(String codes) {
        this.cids = codes;
    }

    public void setContractLabelIds(List<Integer> contractLabelIds) {
        this.contractLabelIds = contractLabelIds;
    }

    public void setPreCalc() {
        this.preCalcMode = true;
        if (this.activeFromDate == null && this.getOperatingTime() != null) {
            this.activeFromDate = this.getOperatingTime();
        }
    }

    public void setActiveFromDate(Calendar value) {
        this.activeFromDate = value;
    }

    public void setServiceObjectList(List<ServiceObject> serviceObjectList) {
        this.serviceObjectList = serviceObjectList;
    }

    public void setTariffList(List<ContractTariff> tariffList) {
        this.tariffList = tariffList;
    }

    public void setTariffOptionEnable(boolean tariffOptionEnable) {
        this.tariffOptionEnable = tariffOptionEnable;
    }

    public ServiceCostCache getCostCache() {
        return this.costCache;
    }

    public ServiceConfigCache getConfigCache() {
        return this.configCache;
    }

    public boolean isCalcErrors() {
        return this.calcErrors;
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Npay. \u0417\u0430\u0434\u0430\u0447\u0430 \u043e\u0431\u0441\u0447\u0435\u0442\u0430 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ". " + (!Utils.isBlankString((String)this.cids) ? "\u041a\u043e\u0434\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: " + this.cids : "\u041a\u043e\u0434\u044b \u043c\u0435\u0442\u043e\u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: " + Utils.toString(this.contractLabelIds));
    }

    protected boolean initTask() {
        if (this.moduleId <= 0) {
            this.log.error("Param mid NOT Found in task config");
            String key = "npay.calculator.mid.empty";
            long time = System.currentTimeMillis();
            if (AlarmSender.needAlarmSend((String)key, (long)time, (long)30000L)) {
                String message = "mid \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0437\u0430\u0434\u0430\u0447\u0438 id=>" + this.taskId;
                AlarmSender.sendAlarm((AlarmErrorMessage)new AlarmErrorMessage(key, "mid \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438", message), (long)time);
            }
            return false;
        }
        return true;
    }

    private Set<Integer> getContractModuleIds(int contractId) throws BGException {
        return ContractRuntimeMap.getInstance().getContractRuntime(this.connectionSet, Integer.valueOf(contractId)).getModuleIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        ServerContext threadContext = (ServerContext)ThreadContext.get();
        this.connectionSet = threadContext != null ? threadContext.getConnectionSet() : ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
        this.con = this.connectionSet.getConnection();
        this.conSlave = this.connectionSet.getSlaveConnection();
        String serviceList = null;
        try (BalanceUtils balanceUtils = new BalanceUtils(this.con);
             TariffModuleTreeSetDao tariffModuleTreeSetDao = new TariffModuleTreeSetDao(this.con);){
            String query;
            boolean minusHour;
            boolean bl = minusHour = this.taskSetup.getInt("hour.minus", 1) == 1;
            if (!this.preCalcMode && minusHour) {
                this.getOperatingTime().add(11, -1);
            }
            this.startMonth = TimeUtils.getStartMonth((Calendar)this.getOperatingTime());
            this.startMonth = TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)this.startMonth);
            this.endMonth = TimeUtils.getEndMonth((Calendar)this.getOperatingTime());
            this.daysInMonth = this.startMonth.getActualMaximum(5);
            int sidSetId = this.taskSetup.getInt("service.set", 0);
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
            ServiceSetManager setManager = new ServiceSetManager(this.con, this.moduleId, (Preferences)moduleSetup);
            ServiceSet set = setManager.getServiceSetMap().get(sidSetId);
            if (set == null) {
                this.log.error("Not found service set with id=" + sidSetId);
                String key = "npay.calculator.service.empty";
                long time = System.currentTimeMillis();
                if (AlarmSender.needAlarmSend((String)key, (long)time, (long)30000L)) {
                    String message = "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 service.set \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0437\u0430\u0434\u0430\u0447\u0438 id=>" + this.taskId;
                    AlarmSender.sendAlarm((AlarmErrorMessage)new AlarmErrorMessage(key, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 service.set \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438", message), (long)time);
                }
                return;
            }
            serviceList = set.getSidList();
            if (!this.preCalcMode) {
                EventProcessor.getInstance().request((QueueEvent)new CalculateEvent(0, this.moduleId, 0, this.startMonth.getTime(), this.endMonth.getTime(), Utils.toIntegerSet((String)serviceList), Utils.toIntegerSet((String)this.cids), this.taskSetup.get("comment", null)));
            }
            this.context = new NPayTariffContext((Preferences)moduleSetup, this.con, this.moduleId, this.startMonth, this.endMonth, this.getOperatingTime(), this.cids, this.contractLabelIds, serviceList);
            this.context.setTariffOptionEnable(this.tariffOptionEnable);
            if (this.preCalcMode) {
                if (this.activeFromDate != null) {
                    this.context.setPrecalcOpenPeriod(new Period(TimeUtils.convertCalendarToDate((Calendar)this.activeFromDate), null));
                }
                if (this.moduleAmountMap != null) {
                    this.context.setModuleAmountMap(this.moduleAmountMap);
                }
                if (this.moduleAccountMap != null) {
                    this.context.setModuleAccountMap(this.moduleAccountMap);
                }
                if (this.moduleQuantityMap != null) {
                    this.context.setModuleQuantityMap(this.moduleQuantityMap);
                }
            } else {
                this.errorManager = new PeriodicErrorManager(this.con);
                this.errorManager.initErrorMessage(this.moduleId, "Npay", String.valueOf(this.moduleId), this.startMonth.getTime());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Services: " + serviceList);
            }
            if (!this.preCalcMode) {
                this.addCostDetail.init(this.startMonth.getTime(), this.moduleId, this.con);
            }
            int cnt = 0;
            if (this.preCalcMode && this.serviceObjectList != null) {
                ContractRuntimeMap contractRuntimeMap = ContractRuntimeMap.getInstance();
                for (ServiceObject serviceObject : this.serviceObjectList) {
                    ContractRuntime contractRuntime = contractRuntimeMap.getContractRuntime(this.con, Integer.valueOf(serviceObject.getContractId()));
                    cnt = this.processServiceObject(cnt, serviceObject, tariffModuleTreeSetDao, contractRuntime.getDomainId());
                }
            } else {
                String contractJoin = "";
                contractJoin = " INNER JOIN contract ON contract.id = npay.cid ";
                query = "SELECT npay.cid, npay.sid, npay.date1, npay.date2, npay.col, npay.emid, npay.eid, contract.domainId FROM npay_service_object_" + this.moduleId + " AS npay " + contractJoin + "WHERE (npay.date1 IS NULL OR npay.date1<=?) AND (npay.date2 IS NULL OR npay.date2>=?) AND npay.sid IN (" + serviceList + ") ";
                if (Utils.notBlankString((String)this.cids)) {
                    query = query + " AND npay.cid IN (" + this.cids + ")";
                } else if (this.contractLabelIds != null && !this.contractLabelIds.isEmpty()) {
                    query = query + " AND contract.id IN (SELECT cll.contract_id FROM contract_label_link AS cll WHERE label_id IN ( " + Utils.toString(this.contractLabelIds) + " ))";
                }
                query = query + " ORDER BY cid, sid";
                PreparedStatement ps = this.conSlave.prepareStatement(query);
                ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)this.endMonth));
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)this.startMonth));
                ResultSet rs = ps.executeQuery();
                if (this.log.isInfoEnabled()) {
                    this.log.info(Utils.memoryStatus());
                }
                while (rs.next()) {
                    ServiceObject serviceObject = new ServiceObject();
                    serviceObject.setContractId(rs.getInt(1));
                    serviceObject.setServiceId(rs.getInt(2));
                    serviceObject.setDate1((Date)rs.getDate(3));
                    serviceObject.setDate2((Date)rs.getDate(4));
                    serviceObject.setCol(rs.getInt(5));
                    serviceObject.setEntityMid(rs.getInt(6));
                    serviceObject.setEntityId(rs.getInt(7));
                    int domainId = rs.getInt(8);
                    cnt = this.processServiceObject(cnt, serviceObject, tariffModuleTreeSetDao, domainId);
                }
                rs.close();
                ps.close();
            }
            tariffModuleTreeSetDao.freeResources();
            if (!this.preCalcMode) {
                String npayDetailTable = ServerUtils.getModuleMonthTableName((String)"npay_detail", (Date)this.startMonth.getTime(), (int)this.moduleId);
                query = "CREATE TABLE IF NOT EXISTS " + npayDetailTable + "( `id` int(11) NOT NULL AUTO_INCREMENT,`cid` INT NOT NULL,`mid` INT NOT NULL,`eid` INT NOT NULL,`sid` INT NOT NULL,`treeId` INT NOT NULL,`col` INT NOT NULL,`summa` DECIMAL(15,2) NOT NULL, PRIMARY KEY (`id`),KEY `cid_mid_eid` (`cid`, `mid`, `eid`),KEY `sid` (`sid`),KEY `treeId` (`treeId`),KEY `mid` (`mid`) )";
                Statement st = this.con.createStatement();
                st.executeUpdate(query);
                st.close();
                if (!ServerUtils.columnExist((Connection)this.con, (String)npayDetailTable, (String)"col")) {
                    st = this.con.createStatement();
                    try {
                        st.executeUpdate("ALTER TABLE " + npayDetailTable + " ADD col INT NOT NULL");
                    }
                    catch (SQLException rs) {
                    }
                    finally {
                        st.close();
                    }
                }
                if (!ServerUtils.columnExist((Connection)this.con, (String)npayDetailTable, (String)"treeId")) {
                    st = this.con.createStatement();
                    try {
                        st.executeUpdate("ALTER TABLE " + npayDetailTable + " ADD treeId INT NOT NULL");
                    }
                    catch (SQLException rs) {
                    }
                    finally {
                        st.close();
                    }
                }
                boolean autoCommit = this.con.getAutoCommit();
                try {
                    this.con.setAutoCommit(false);
                    this.con.commit();
                    if (this.taskSetup.getInt("detail", 1) > 0) {
                        query = "DELETE FROM " + npayDetailTable + " WHERE sid IN (" + serviceList + ") ";
                        if (Utils.notBlankString((String)this.cids)) {
                            query = query + " AND cid IN (" + this.cids + ")";
                        }
                        st = this.con.createStatement();
                        st.executeUpdate(query);
                        st.close();
                        query = "INSERT INTO " + npayDetailTable + " (cid, mid, eid, sid, treeId, col, summa) VALUES (?, ?, ?, ?, ?, ?, ?)";
                        PreparedStatement ps = this.con.prepareStatement(query);
                        int count = 0;
                        for (AmountDetail detail : this.amountDetailCache.getAmounts()) {
                            ps.setInt(1, detail.cid);
                            ps.setInt(2, detail.mid);
                            ps.setInt(3, detail.eid);
                            ps.setInt(4, detail.sid);
                            ps.setInt(5, detail.tree);
                            ps.setInt(6, detail.col);
                            ps.setBigDecimal(7, detail.cost);
                            ps.addBatch();
                            if (++count % 1000 != 0) continue;
                            ps.executeBatch();
                        }
                        ps.executeBatch();
                        ps.close();
                    }
                    this.con.commit();
                    this.addCostDetail.flushCache(this.con);
                    this.con.commit();
                    this.con.setAutoCommit(autoCommit);
                    balanceUtils.setAccount(this.con, this.log, this.startMonth, this.costCache, serviceList, this.cids, this.contractLabelIds);
                }
                finally {
                    this.con.setAutoCommit(autoCommit);
                }
            }
            if (!this.preCalcMode) {
                EventProcessor.getInstance().request((QueueEvent)new CalculateEvent(1, this.moduleId, 0, this.startMonth.getTime(), this.endMonth.getTime(), Utils.toIntegerSet((String)serviceList), Utils.toIntegerSet((String)this.cids), this.taskSetup.get("comment", null)));
            }
        }
        catch (Exception e) {
            this.calcErrors = true;
            if (!this.preCalcMode && this.errorManager != null && !this.errorManager.isCapReached()) {
                String subject = e.getMessage();
                String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0435 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 " + (!Utils.isBlankString((String)this.cids) ? "\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 = " + this.cids : " \u043c\u0435\u0442\u043a\u043e\u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 = " + Utils.toString(this.contractLabelIds)) + "\n\u041e\u0431\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u043c\u044b\u0435 \u0443\u0441\u043b\u0443\u0433\u0438: " + serviceList;
                this.errorManager.addErrorToList(subject, text, e);
            }
            this.log.error(e.getMessage(), (Throwable)e);
            if (!this.preCalcMode) {
                try {
                    EventProcessor.getInstance().request((QueueEvent)new CalculateEvent(2, this.moduleId, 0, this.startMonth.getTime(), this.endMonth.getTime(), Utils.toIntegerSet(serviceList), Utils.toIntegerSet((String)this.cids), this.taskSetup.get("comment", null)));
                }
                catch (BGException ex) {
                    this.log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        finally {
            try {
                if (!this.preCalcMode && this.errorManager != null) {
                    if (Utils.isBlankString((String)this.cids) && (this.contractLabelIds == null || this.contractLabelIds.isEmpty())) {
                        this.errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), this.startMonth.getTime());
                    }
                    this.errorManager.processErrors();
                }
            }
            finally {
                if (threadContext == null) {
                    this.connectionSet.recycle();
                }
            }
        }
    }

    private int processServiceObject(int cnt, ServiceObject serviceObject, TariffModuleTreeSetDao tariffModuleTreeSetDao, int domainId) {
        int contractId = serviceObject.getContractId();
        int serviceId = serviceObject.getServiceId();
        try {
            Set<Integer> moduleIds = this.getContractModuleIds(contractId);
            if (moduleIds == null || !moduleIds.contains(this.moduleId)) {
                this.calcErrors = true;
                if (!this.preCalcMode && !this.errorManager.isCapReached()) {
                    String subject = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438";
                    String text = "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u043e\u0434\u0443\u043b\u044c mid=" + this.moduleId + " \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 cid=" + contractId + ", \u043d\u043e \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430 sid=" + serviceId;
                    this.errorManager.addErrorToList(subject, text);
                }
                this.log.error("No module mid=" + this.moduleId + " on the contract cid=" + contractId + ", but the presence active sid=" + serviceId);
            }
            Date serviceStartDate = serviceObject.getDate1();
            Date serviceEndDate = serviceObject.getDate2();
            int emid = serviceObject.getEntityMid();
            int eid = serviceObject.getEntityId();
            Calendar serviceStart = TimeUtils.convertDateToCalendar((Date)serviceObject.getDate1());
            Calendar serviceEnd = TimeUtils.convertDateToCalendar((Date)serviceObject.getDate2());
            int col = serviceObject.getCol();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Found service taker: contractId -> " + contractId + "; serviceId -> " + serviceId + "; date1 -> " + TimeUtils.formatDate((Calendar)serviceStart) + "; date2 -> " + TimeUtils.formatDate((Calendar)serviceEnd) + "; amount -> " + col);
            }
            if (serviceEnd != null && TimeUtils.dateBefore((Calendar)serviceEnd, (Calendar)this.startMonth)) {
                this.log.debug("Service end before month start.");
                return 0;
            }
            if (serviceStart != null && TimeUtils.dateBefore((Calendar)this.endMonth, (Calendar)serviceStart)) {
                this.log.debug("Service starting after month end.");
                return 0;
            }
            Calendar serviceDate1 = TimeUtils.convertDateToCalendar((Date)this.trimByMonthStart(serviceStartDate));
            Calendar serviceDate2 = TimeUtils.convertDateToCalendar((Date)this.trimByMonthEnd(serviceEndDate));
            if (this.log.isDebugEnabled()) {
                this.log.debug("After trimming: contractId -> " + contractId + "; serviceId -> " + serviceId + "; date1 -> " + TimeUtils.formatDate((Calendar)serviceDate1) + "; date2 -> " + TimeUtils.formatDate((Calendar)serviceDate2));
            }
            TariffModuleTreeSet tariffModuleTreeSet = this.getTreeSet(contractId, emid, eid, tariffModuleTreeSetDao);
            boolean accept = false;
            for (TariffModuleTreeSet.Entry tariffPeriod : tariffModuleTreeSet.entries()) {
                Calendar tariffFrom = tariffPeriod.getCalendarFrom();
                Calendar tariffTo = tariffPeriod.getCalendarTo();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Tariff period: " + TimeUtils.formatPeriod((Calendar)tariffFrom, (Calendar)tariffTo));
                }
                Calendar date1 = (Calendar)serviceDate1.clone();
                Calendar date2 = (Calendar)serviceDate2.clone();
                if (tariffFrom != null && TimeUtils.dateBefore((Calendar)date2, (Calendar)tariffFrom)) continue;
                if (tariffFrom != null && TimeUtils.dateBefore((Calendar)date1, (Calendar)tariffFrom)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Trim left");
                    }
                    date1 = tariffFrom;
                }
                if (tariffTo != null && TimeUtils.dateBefore((Calendar)tariffTo, (Calendar)date2)) {
                    if (!TimeUtils.dateBeforeOrEq((Calendar)date1, (Calendar)tariffTo)) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Trim right");
                    }
                    date2 = tariffTo;
                }
                NPayTariffRequest tariffRequest = new NPayTariffRequest(this.moduleId, contractId, serviceId, domainId);
                tariffRequest.setInfoEnable(this.log.isDebugEnabled());
                tariffRequest.setConnectionSet(this.connectionSet);
                tariffRequest.setAccountingMonthDays(this.daysInMonth);
                tariffRequest.tariffDateFrom = tariffFrom;
                tariffRequest.tariffDateTo = tariffTo;
                tariffRequest.setTime(date1);
                tariffRequest.setServiceCost(serviceId, Collections.singletonList(new NPayServiceCost(serviceId, serviceStart, serviceEnd, date1, date2, col)));
                TariffModuleTree tree = tariffPeriod.getTree();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Request in tree: " + tree.getTreeId());
                    this.log.debug(tariffRequest.toString());
                }
                tree.execute((AbstractTariffRequest)tariffRequest, (TariffContext)this.context);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Request after processing: " + tariffPeriod.getTree().getTreeId());
                    this.log.debug(tariffRequest.toString());
                }
                if (!tariffRequest.isAccepted()) continue;
                accept = true;
                for (NPayServiceCost serviceCost : tariffRequest.getServiceCostList()) {
                    BigDecimal addCost = serviceCost.addCost;
                    if (addCost != null) {
                        this.addCostDetail.addRecord(new AddCostItem(contractId, serviceCost.serviceId, addCost));
                    }
                    CostSum sum = new CostSum(contractId, serviceCost.serviceId, serviceCost.cost);
                    this.costCache.addAmount(sum);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Add cost cache cid: " + contractId + "; sid: " + serviceCost.serviceId + "; cost: " + serviceCost.cost);
                    }
                    AmountDetail detail = new AmountDetail(contractId, serviceCost.serviceId, emid, eid, tree.getTreeId());
                    detail.col = col;
                    detail.cost = sum.cost;
                    this.amountDetailCache.addAmount(detail);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Add detail amount cache cid: " + contractId + "; sid: " + serviceCost.serviceId + "; mid: " + this.moduleId + "; eid: " + eid + "; cost: " + sum.cost);
                    }
                    this.configCache.addConfig(contractId, tariffRequest.getConfig());
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Add config cache cid: " + contractId + "; sid: " + serviceCost.serviceId + "; config: " + tariffRequest.getConfig());
                }
            }
            if (!accept) {
                this.calcErrors = true;
                if (!this.preCalcMode && !this.errorManager.isCapReached()) {
                    String subject = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438";
                    String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + contractId + "\n\u041e\u0431\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u043c\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430: " + serviceId;
                    this.errorManager.addErrorToList(subject, text);
                }
                this.log.error("Tariff error contractId: " + contractId + "; serviceId: " + serviceId);
            }
            if (++cnt % 1000 == 0 && this.log.isInfoEnabled()) {
                this.log.info("Item count " + cnt);
            }
        }
        catch (Exception e) {
            this.calcErrors = true;
            if (!this.preCalcMode && !this.errorManager.isCapReached()) {
                String subject = "\u041d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 " + e.getMessage();
                String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + contractId + "\n\u041e\u0431\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u043c\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430: " + serviceId;
                this.errorManager.addErrorToList(subject, text, e);
            }
            Contract c = null;
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                c = (Contract)contractDao.get(contractId);
            }
            catch (BGException e1) {
                this.log.error("\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0441 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c " + contractId + " \u0438\u0437 \u0411\u0414", (Throwable)e1);
            }
            this.log.error("Fatal tariff error contractId: " + contractId + "; serviceId: " + serviceId + "; contractStatus: " + c.getStatus(), (Throwable)e);
        }
        return cnt;
    }

    private Date trimByMonthEnd(Date date) {
        if (date == null || TimeUtils.dateBefore((Date)this.endMonth.getTime(), (Date)date)) {
            date = ((Calendar)this.endMonth.clone()).getTime();
        }
        return date;
    }

    private Date trimByMonthStart(Date date1) {
        if (date1 == null || TimeUtils.dateBefore((Date)date1, (Date)this.startMonth.getTime())) {
            date1 = ((Calendar)this.startMonth.clone()).getTime();
        }
        return date1;
    }

    private TariffModuleTreeSet getTreeSet(int cid, int emid, int eid, TariffModuleTreeSetDao tariffModuleTreeSetDao) throws BGException {
        TariffModuleTreeSet result;
        Map<Integer, TariffModuleTreeSet> eidMap;
        Map<Integer, Map<Integer, TariffModuleTreeSet>> emidMap;
        SoftReference<Map<Integer, Map<Integer, TariffModuleTreeSet>>> emidMapRef = this.treeSetMap.get(cid);
        Map<Integer, Map<Integer, TariffModuleTreeSet>> map = emidMap = emidMapRef != null ? emidMapRef.get() : null;
        if (emidMap == null) {
            emidMap = new HashMap<Integer, Map<Integer, TariffModuleTreeSet>>(8);
            this.treeSetMap.put(cid, new SoftReference<Map<Integer, Map<Integer, TariffModuleTreeSet>>>(emidMap));
        }
        if ((eidMap = emidMap.get(emid)) == null) {
            eidMap = new HashMap<Integer, TariffModuleTreeSet>(8);
            emidMap.put(emid, eidMap);
        }
        if ((result = eidMap.get(eid)) == null) {
            result = this.tariffList != null ? tariffModuleTreeSetDao.getRealtimeTariffTreeSet("npay", this.moduleId, this.tariffList) : tariffModuleTreeSetDao.getRealtimeTariffTreeSet(cid, this.startMonth.getTime(), "npay", this.moduleId, emid, eid);
            eidMap.put(eid, result);
        }
        return result;
    }

    public void setModuleAmountMap(Map<Integer, ModuleAmount> moduleAmountMap) {
        this.moduleAmountMap = moduleAmountMap;
    }

    public void setModuleAccountMap(Map<Integer, ModuleAccount> moduleAccountMap) {
        this.moduleAccountMap = moduleAccountMap;
    }

    public void setModuleQuantityMap(Map<Integer, ModuleQuantity> moduleQ\u043auantityMap) {
        this.moduleQuantityMap = moduleQ\u043auantityMap;
    }

    class AddCostDetail {
        private String tableName;
        private Map<String, AddCostItem> cache = new HashMap<String, AddCostItem>(100);

        public void init(Date month, int mid, Connection con) {
            this.tableName = ServerUtils.getModuleMonthTableName((String)"npay_add_cost_detail", (Date)month, (int)mid);
            String query = null;
            try {
                Statement st;
                if (!ServerUtils.tableExists((Connection)con, (String)this.tableName)) {
                    query = "CREATE TABLE " + this.tableName + " ( cid INT NOT NULL, sid INT NOT NULL, summa DECIMAL(15,2) NOT NULL, KEY cid(cid) )";
                    st = con.createStatement();
                    st.executeUpdate(query);
                    st.close();
                }
                query = "DELETE FROM " + this.tableName;
                if (Utils.notBlankString((String)Calculator.this.cids)) {
                    query = query + " WHERE cid IN ( " + Calculator.this.cids + ")";
                }
                st = con.createStatement();
                st.executeUpdate(query);
                st.close();
            }
            catch (Exception e) {
                Calculator.this.log.error(e.getMessage(), (Throwable)e);
            }
        }

        public void addRecord(AddCostItem item) {
            String key = item.getKey();
            this.cache.put(key, item);
        }

        public void flushCache(Connection con) {
            try {
                String query = "INSERT INTO " + this.tableName + " SET cid=?, sid=?, summa=?";
                PreparedStatement ps = con.prepareStatement(query);
                for (AddCostItem item : this.cache.values()) {
                    ps.setInt(1, item.cid);
                    ps.setInt(2, item.sid);
                    ps.setBigDecimal(3, item.summa);
                    ps.executeUpdate();
                }
                ps.close();
            }
            catch (Exception e) {
                Calculator.this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

