/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.client;

import bitel.billing.module.common.ActualDateFilter;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGTextArea;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.common.service.NPayService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

public class ServicePropertiesPanel
extends ServicePanel {
    private NPayService npayService = null;
    private ModuleService moduleService = null;
    private ServiceObjectTableModel tableModel = new ServiceObjectTableModel(ServiceObjectTableModel.class.getName());
    private BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
    private ActualDateFilter filter = new ActualDateFilter((BGPanel)this);

    public ServicePropertiesPanel() {
        this.jbInit();
        this.table.setComponentPopupMenu(this.getPopupMenu());
    }

    private void jbInit() {
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ServicePropertiesPanel.this.startEdit((ServiceObjectRow)ServicePropertiesPanel.this.tableModel.getSelectedRow());
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.filter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 3), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
    }

    public void setData() {
        this.filter.updateDate();
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ServiceObjectTable");
        request.setModuleId(this.getModuleId());
        request.setContractId(this.getContractId());
        request.setAttribute("object_id", this.objectId);
        request.setAttribute("actualItemsOnly", this.filter.isEnabled());
        request.setAttribute("actualItemsDate", TimeUtils.format((Calendar)this.filter.getDateCalendar(), (String)"dd.MM.yyyy"));
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ArrayList<ServiceObjectRow> list = new ArrayList<ServiceObjectRow>();
            for (Element element : XMLUtils.selectElements((Node)doc, (String)"/data/table/data/row")) {
                ServiceObjectRow serviceObjectRow = new ServiceObjectRow();
                serviceObjectRow.setId(Utils.parseInt((String)element.getAttribute("id")));
                serviceObjectRow.setService(element.getAttribute("service"));
                serviceObjectRow.setCol(Utils.parseInt((String)element.getAttribute("col")));
                serviceObjectRow.setPeriod(element.getAttribute("period"));
                serviceObjectRow.setObject(element.getAttribute("object"));
                serviceObjectRow.setComment(element.getAttribute("comment"));
                list.add(serviceObjectRow);
            }
            this.tableModel.setData(list);
        }
    }

    public void deleteItem() {
        List serviceObjectRows = this.tableModel.getSelectedRows();
        if (serviceObjectRows == null || serviceObjectRows.isEmpty()) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
            return;
        }
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0443(\u044b)?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            for (ServiceObjectRow serviceObjectRow : serviceObjectRows) {
                Request request = new Request();
                request.setModule(this.module);
                request.setAction("ServiceObjectDelete");
                request.setModuleId(this.getModuleId());
                request.setContractId(this.getContractId());
                request.setAttribute("id", serviceObjectRow.getId());
                ClientUtils.checkStatus((Document)this.getDocument(request));
            }
            this.setData();
        }
    }

    public void editItem() {
        this.startEdit((ServiceObjectRow)this.tableModel.getSelectedRow());
    }

    public void newItem() {
        this.startEdit(new ServiceObjectRow());
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem transferItem = new JMenuItem("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        popupMenu.add(transferItem);
        transferItem.addActionListener(e -> {
            ServiceObjectRow serviceObjectRow = (ServiceObjectRow)this.tableModel.getSelectedRow();
            if (serviceObjectRow != null) {
                this.transferToContract("MovePay", "id", String.valueOf(serviceObjectRow.getId()));
            }
        });
        JMenuItem wrapItem = new JMenuItem("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u0434\u0430\u0442\u044b");
        popupMenu.add(wrapItem);
        wrapItem.addActionListener(e -> {
            ServiceObjectRow serviceObjectRow = (ServiceObjectRow)this.tableModel.getSelectedRow();
            if (serviceObjectRow != null) {
                this.wrapToContract("WrapPay", "id", String.valueOf(serviceObjectRow.getId()));
            }
        });
        return popupMenu;
    }

    private void startEdit(ServiceObjectRow serviceObjectRow) {
        if (serviceObjectRow == null) {
            return;
        }
        new ServiceObjectEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440", serviceObjectRow).getDialog().setVisible(true);
        this.setData();
    }

    private NPayService getNPayService() {
        if (this.npayService == null) {
            this.npayService = (NPayService)this.getContext().getPort(NPayService.class);
        }
        return this.npayService;
    }

    private ModuleService getModuleService() {
        if (this.moduleService == null) {
            this.moduleService = (ModuleService)this.getContext().getPort(ModuleService.class);
        }
        return this.moduleService;
    }

    class ServiceObjectTableModel
    extends BGTableModel<ServiceObjectRow> {
        public ServiceObjectTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", 100, 100, -1, "service", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043b-\u0432\u043e", 50, 50, 50, "col", true).setTableCellRenderer((TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, "period", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041e\u0431\u044a\u0435\u043a\u0442", 100, 100, -1, "object", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class ServiceObjectRow {
        private int id = 0;
        private String service = null;
        private int col = 0;
        private String period = null;
        private String object = null;
        private String comment = null;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public int getCol() {
            return this.col;
        }

        public void setCol(int col) {
            this.col = col;
        }

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public String getObject() {
            return this.object;
        }

        public void setObject(String object) {
            this.object = object;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }

    class ServiceObjectEditor
    extends BGEditorDialog<ServiceObjectRow> {
        private JTabbedPane tabbedPane;
        private List<Service> serviceList;
        private IntTextField col;
        private BGUList<IdTitle> services;
        private BGUList<IdTitle> serviceSets;
        private BGComboBox<ComboBoxItem> objectCombo;
        private BGControlPanelPeriodNoB servicePeriod;
        private BGTextArea comment;
        private JCheckBox showAllObj;
        private JCheckBox filterActive;
        private JCheckBox filterUsed;

        public ServiceObjectEditor(String title, ServiceObjectRow data) {
            super(title, (Object)data);
            this.serviceList = null;
            this.col = new IntTextField(10);
            this.services = new BGUList();
            this.serviceSets = new BGUList();
            this.objectCombo = new BGComboBox();
            this.servicePeriod = new BGControlPanelPeriodNoB();
            this.comment = new BGTextArea();
            this.showAllObj = new JCheckBox("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0432\u0441\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b");
            this.filterActive = new JCheckBox("\u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u043c\u0443 \u043f\u0435\u0440\u0438\u043e\u0434\u0443");
            this.filterUsed = new JCheckBox("\u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0444\u043b\u0430\u0433\u0443 \"\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f\"");
        }

        public void doDialogPanel() {
            int gridx = 0;
            this.panel.add((Component)this.getServicePanel(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.panel.add((Component)this.getParameterPanel(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            try {
                this.serviceList = ServicePropertiesPanel.this.getModuleService().moduleServiceList(ServicePropertiesPanel.this.getContext().getModuleId());
                this.setServiceListData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.services.setSelectionMode(0);
            this.services.addListSelectionListener(e -> {
                if (this.tabbedPane.getSelectedIndex() == 1) {
                    this.serviceSets.clearSelection();
                }
            });
            Request request = new Request();
            request.setModule(ServicePropertiesPanel.this.module);
            request.setAction("ServiceSetList");
            request.setModuleId(ServicePropertiesPanel.this.getModuleId());
            Document doc = ServicePropertiesPanel.this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                ArrayList<IdTitle> items = new ArrayList<IdTitle>();
                for (Element element : XMLUtils.selectElements((Node)doc, (String)"/data/list/item")) {
                    items.add(new IdTitle(Utils.parseInt((String)element.getAttribute("id")), element.getAttribute("title")));
                }
                this.serviceSets.setData(items);
            }
            this.serviceSets.addListSelectionListener(e -> {
                if (this.tabbedPane.getSelectedIndex() == 0) {
                    this.services.clearSelection();
                    this.services.setSelectedIndex(-1);
                }
            });
            String oid = "0";
            if (((ServiceObjectRow)this.data).getId() < 1) {
                this.servicePeriod.setDateCalendar1((Calendar)new GregorianCalendar());
                this.servicePeriod.setDateCalendar2(null);
                this.col.setText("1");
                this.comment.setText("");
            } else {
                try {
                    ServiceObject serviceObject = ServicePropertiesPanel.this.getNPayService().serviceObjectGet(((ServiceObjectRow)this.data).getId());
                    if (serviceObject != null) {
                        oid = String.valueOf(serviceObject.getObjectId());
                        this.col.setText(String.valueOf(serviceObject.getCol()));
                        this.servicePeriod.setPeriod(new Period(serviceObject.getDate1(), serviceObject.getDate2()));
                        this.comment.setText(serviceObject.getComment());
                        int serviceId = serviceObject.getServiceId();
                        this.services.setSelectedId(serviceId, true);
                    }
                }
                catch (Exception e2) {
                    ClientUtils.showErrorMessageDialog((Throwable)e2);
                }
            }
            this.services.setEnabled(((ServiceObjectRow)this.data).getId() == 0);
            ServicePropertiesPanel.this.buildObjectCombo(this.objectCombo, this.showAllObj.isSelected(), oid);
            this.showAllObj.setEnabled(this.objectCombo.isEnabled());
            this.tabbedPane.setSelectedIndex(((ServiceObjectRow)this.data).getId() == 0 ? 0 : 1);
        }

        public boolean doApply() throws Exception {
            String oid = ClientUtils.getIdFromComboBox(this.objectCombo);
            IdTitle serviceId = (IdTitle)this.services.getSelectedValue();
            String colValue = this.col.getText();
            if (Utils.isBlankString((String)colValue)) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e!");
                return false;
            }
            HashSet<String> serviceIds = new HashSet<String>();
            if (serviceId != null) {
                serviceIds.add(String.valueOf(serviceId.getId()));
            }
            for (IdTitle listItem : this.serviceSets.getSelectedValuesList()) {
                serviceIds.addAll(ServicePropertiesPanel.this.getNPayService().serviceSetGet(listItem.getId()));
            }
            for (String sid : serviceIds) {
                Request request = new Request();
                request.setModule(ServicePropertiesPanel.this.module);
                request.setAction("ServiceObjectUpdate");
                request.setModuleId(ServicePropertiesPanel.this.getModuleId());
                request.setContractId(ServicePropertiesPanel.this.getContractId());
                request.setAttribute("id", ((ServiceObjectRow)this.data).getId());
                request.setAttribute("sid", sid);
                request.setAttribute("col", colValue);
                if (Utils.isBlankString((String)this.servicePeriod.getDateString1())) {
                    ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
                    return false;
                }
                request.setAttribute("date1", this.servicePeriod.getDateString1());
                request.setAttribute("date2", this.servicePeriod.getDateString2());
                request.setAttribute("comment", this.comment.getText());
                request.setAttribute("oid", ServicePropertiesPanel.this.objectId > 0 ? Integer.valueOf(ServicePropertiesPanel.this.objectId) : oid);
                if (ClientUtils.checkStatus((Document)ServicePropertiesPanel.this.getDocument(request))) continue;
                return false;
            }
            return true;
        }

        private JPanel getServicePanel() {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.add((Component)this.getListPanel(this.serviceSets, null), "\u041d\u0430\u0431\u043e\u0440\u044b \u0443\u0441\u043b\u0443\u0433");
            this.tabbedPane.add((Component)this.getListPanel(this.services, this.getServiceFilterPanel()), "\u0423\u0441\u043b\u0443\u0433\u0438");
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
            return panel;
        }

        private JPanel getListPanel(BGUList<?> list, JPanel filterPanel) {
            Dimension dimension = new Dimension(500, 250);
            JScrollPane scrollPane = new JScrollPane((Component)list);
            scrollPane.setMinimumSize(dimension);
            scrollPane.setPreferredSize(dimension);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
            if (filterPanel != null) {
                panel.add((Component)filterPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
            }
            return panel;
        }

        private JPanel getServiceFilterPanel() {
            this.filterActive.addChangeListener(e -> this.setServiceListData());
            this.filterUsed.addChangeListener(e -> this.setServiceListData());
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.filterActive, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
            panel.add((Component)this.filterUsed, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
            return panel;
        }

        private void setServiceListData() {
            boolean active = this.filterActive.isSelected();
            boolean used = this.filterUsed.isSelected();
            LocalDate now = LocalDate.now();
            ArrayList<IdTitle> items = new ArrayList<IdTitle>();
            for (Service service : this.serviceList) {
                if (used && (!used || !service.isUsing()) || active && (!active || !TimeUtils.dateInPeriod((LocalDate)now, (Period)service.getActivePeriod()))) continue;
                items.add(new IdTitle(service.getId(), service.getTitle()));
            }
            this.services.setData(items);
        }

        private JPanel getParameterPanel() {
            this.showAllObj.addActionListener(e -> {
                ServicePropertiesPanel.this.buildObjectCombo(this.objectCombo, this.showAllObj.isSelected(), "0");
                this.showAllObj.setEnabled(this.objectCombo.isEnabled());
            });
            int gridy = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e:"), new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 0), 0, 0));
            panel.add((Component)this.servicePeriod, new GridBagConstraints(0, gridy, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)this.col, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 10, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041e\u0431\u044a\u0435\u043a\u0442:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            panel.add((Component)this.objectCombo, new GridBagConstraints(0, gridy++, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)this.showAllObj, new GridBagConstraints(0, gridy++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane((Component)this.comment), new GridBagConstraints(0, gridy++, 2, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }
    }
}

