/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paykeeper.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.paykeeper.common.bean.Transaction;
import ru.bitel.bgbilling.modules.paykeeper.common.bean.TransactionStatus;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "paykeeper_transaction");
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("status", "status");
        this.fields.put("createDatetime", "create_date");
        this.fields.put("transactionDatetime", "transaction_date");
        this.fields.put("sum", "sum");
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            String[] sort = searchResult.getSort();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            StringBuilder query = new StringBuilder(" FROM ").append(this.tableName).append(" AS pt ").append("LEFT JOIN contract c ON c.id=pt.contract_id WHERE true");
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND pt.create_date>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND pt.create_date<?");
                }
            }
            if (Utils.notBlankString((String)status)) {
                query.append(" AND pt.status=?");
            }
            if (Utils.notBlankString((String)contractTitle)) {
                query.append(" AND c.title LIKE ?");
            }
            if (contractId > 0) {
                query.append(" AND c.id=").append(contractId);
            }
            try {
                ResultSet rs = null;
                PreparedStatement ps = this.con.prepareStatement("SELECT pt.*, c.title AS contract_title" + query.toString() + this.getSQLOrder(sort, this.fields) + (page != null ? page.sqlLimit() : ""));
                int index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                    }
                }
                if (Utils.notBlankString((String)status)) {
                    ps.setString(index++, status);
                }
                if (Utils.notBlankString((String)contractTitle)) {
                    ps.setString(index++, "%" + contractTitle + "%");
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
                rs.close();
                ps.close();
                ps = this.con.prepareStatement("SELECT SUM(pt.sum), COUNT(*) " + query.toString());
                index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                    }
                }
                if (Utils.notBlankString((String)status)) {
                    ps.setString(index++, status);
                }
                if (Utils.notBlankString((String)contractTitle)) {
                    ps.setString(index++, "%" + contractTitle + "%");
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    BigDecimal sum;
                    if (page != null) {
                        page.setRecordCount(rs.getInt(2));
                    }
                    if ((sum = rs.getBigDecimal(1)) == null) continue;
                    searchResult.setSum(sum);
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException, BGException {
        Transaction transaction = new Transaction();
        transaction.setId(rs.getInt("id"));
        transaction.setContractId(rs.getInt("contract_id"));
        transaction.setContractTitle(rs.getString("contract_title"));
        transaction.setPaymentId(rs.getInt("payment_id"));
        transaction.setCreateDate((Date)rs.getTimestamp("create_date"));
        transaction.setTransactionId(rs.getString("order_id"));
        transaction.setTransactionDate((Date)rs.getTimestamp("transaction_date"));
        transaction.setStatus(rs.getString("status"));
        transaction.setParameters(rs.getString("params"));
        transaction.setSum(rs.getBigDecimal("sum"));
        return transaction;
    }

    protected Transaction getImpl(int transactionId) throws BGException, SQLException {
        PreparedStatement ps = this.getByIdPS;
        if (ps == null) {
            ps = this.getByIdPS = this.con.prepareStatement("SELECT pt.*, c.title AS contract_title FROM " + this.tableName + " AS pt LEFT JOIN contract AS c ON c.id=pt.contract_id WHERE pt.id=?");
        }
        ps.setInt(1, transactionId);
        ResultSet rs = ps.executeQuery();
        Transaction result = rs.next() ? this.getFromRS(rs) : null;
        rs.close();
        return result;
    }

    public boolean update(Transaction transaction, TransactionStatus newTransactionStatus) throws BGException {
        boolean result = false;
        if (transaction != null && newTransactionStatus != null) {
            try {
                StringBuilder query = new StringBuilder("UPDATE ").append(this.tableName).append(" SET ").append("order_id=?, status=?").append(" WHERE ").append("status=? AND id=?");
                int index = 1;
                PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
                ps.setString(index++, transaction.getTransactionId());
                ps.setString(index++, newTransactionStatus.getCode());
                ps.setString(index++, transaction.getStatus());
                ps.setInt(index++, transaction.getId());
                result = ps.executeUpdate() > 0;
                ps.close();
                if (result) {
                    transaction.setStatus(newTransactionStatus.getCode());
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return result;
    }

    protected void updateImpl(Transaction transaction) throws BGException {
        if (transaction != null) {
            try {
                String fields = " SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, order_id=?, status=?, params=?, sum=?";
                int id = transaction.getId();
                StringBuilder query = new StringBuilder(id > 0 ? "UPDATE " : "INSERT INTO ").append(this.tableName).append(" SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, order_id=?, status=?, params=?, sum=?").append(id > 0 ? " WHERE id=?" : "");
                int index = 1;
                PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
                ps.setInt(index++, transaction.getContractId());
                ps.setInt(index++, transaction.getPaymentId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
                ps.setString(index++, transaction.getTransactionId());
                ps.setString(index++, transaction.getStatus());
                ps.setString(index++, transaction.getParameters());
                ps.setBigDecimal(index++, transaction.getSum());
                if (id > 0) {
                    ps.setInt(index++, id);
                }
                ps.executeUpdate();
                if (id < 1) {
                    transaction.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                }
                ps.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void addTransactionPayment(Transaction transaction, String transactionParameters) throws BGException {
        if (this.update(transaction, TransactionStatus.APPROVED)) {
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
            Payment payment = new Payment();
            payment.setContractId(transaction.getContractId());
            payment.setSum(transaction.getSum());
            payment.setDate(new Date());
            payment.setTypeId(moduleSetup.getInt("paykeeper.payment.type.id", 0));
            payment.setComment(moduleSetup.get("paykeeper.payment.comment", "\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 PayKeeper").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId())));
            PaymentDao paymentDao = new PaymentDao(this.con);
            paymentDao.update((Object)payment);
            paymentDao.close();
            BalanceUtils balanceUtils = new BalanceUtils(this.con);
            balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
            balanceUtils.close();
            transaction.setPaymentId(payment.getId());
            transaction.setTransactionDate(new Date());
            transaction.setParameters(transactionParameters);
            this.update(transaction);
            EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getDate(), payment.getSum()));
        }
    }
}

