/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paymaster.server.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.bgbilling.modules.paymaster.common.bean.Transaction;
import ru.bitel.bgbilling.modules.paymaster.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.paymaster.common.service.PayMasterService;
import ru.bitel.bgbilling.modules.paymaster.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.paymaster.server.bean.Constants;
import ru.bitel.bgbilling.modules.paymaster.server.bean.TransactionManager;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebAction(title="PayMaster")
public class ActionDoTransaction
extends AbstractAction {
    private String moduleName = "paymaster";
    @Resource
    private PayMasterService payMasterService;

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.paymentForm(this.moduleName, Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchResult searchResult = new SearchResult(null, this.getPage(), new String[]{"transactionDatetime:1"});
            transactionManager.searchTransactionList((SearchResult<Transaction>)searchResult, 0, this.contractId, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
            this.context.getRequest().setAttribute("transactions", (Object)searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    public void failure() throws BGException {
        this.execute();
        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
    }

    public void success() throws BGException {
        this.execute();
        throw new BGMessageException("\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal sumMin = this.moduleSetup.getBigDecimal("paymaster.sum.min", new BigDecimal(100));
        BigDecimal sumMax = this.moduleSetup.getBigDecimal("paymaster.sum.max", new BigDecimal(5000));
        String customerAddress = ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            this.execute();
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
        }
        try {
            Holder mode = new Holder();
            Holder redirectUrl = new Holder();
            Holder params = new Holder((Object)new MapHolder());
            if (!Utils.isBlankString((String)customerAddress)) {
                ((MapHolder)params.value).getMap().put(customerAddress.contains("@") ? "email" : "phone", customerAddress);
            }
            this.payMasterService.beginTransaction(this.contractId, sum, redirectUrl, mode, params);
            this.context.getRequest().setAttribute("contentType", (Object)ActionResultContentType.binary);
            this.context.getResponse().sendRedirect((String)redirectUrl.value);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autopayment() throws BGException {
        int mode;
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        boolean autopaymentEnable = this.moduleSetup.getBoolean("paymaster.autopayment.enable", false);
        BigDecimal sum = BigDecimal.ZERO;
        boolean createToken = false;
        if (autopaymentEnable && ContractAutopaymentManager.isContractAutopaymentEnabled((Connection)this.con, (int)this.moduleId, (int)this.contractId) && (mode = this.req.getInt("mode", 0)) > -1 && mode < 4) {
            Preferences modeDataMap;
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(this.contractId);
            if (autopayment != null) {
                if (autopayment.getMode() != AutopaymentMode.OFF) {
                    autopaymentManager.autopaymentOff(autopayment);
                }
                if (mode != autopayment.getMode().getCode()) {
                    autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                    autopaymentManager.updateAutopayment(autopayment);
                    autopayment = null;
                }
            }
            if (autopayment == null) {
                autopayment = new Autopayment();
                autopayment.setContractId(this.contractId);
            }
            Preferences preferences = modeDataMap = autopayment.getModeData() != null ? new Preferences(autopayment.getModeData(), "\n") : new Preferences();
            if (mode == AutopaymentMode.OFF.getCode()) {
                autopayment.setMode(AutopaymentMode.OFF);
                autopayment.setSum(BigDecimal.ZERO);
                autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
                autopayment.setAccessToken(null);
            } else if (mode == AutopaymentMode.WEEK.getCode()) {
                int autopaymentWeekDay = this.moduleSetup.getInt("paymaster.autopayment.mode.week.day.default", 1);
                modeDataMap.set("autopayment.mode.week.day", String.valueOf(this.req.getInt("dayOfWeek", autopaymentWeekDay)));
                BigDecimal autopaymentWeekSum = this.moduleSetup.getBigDecimal("paymaster.autopayment.mode.week.sum.default", new BigDecimal(50));
                autopaymentWeekSum = this.req.getBigDecimal("weekSum", autopaymentWeekSum);
                modeDataMap.set("autopayment.mode.week.sum", String.valueOf(autopaymentWeekSum));
                autopayment.setSum(autopaymentWeekSum);
                autopayment.setMode(AutopaymentMode.WEEK);
                createToken = true;
                sum = autopaymentWeekSum;
            } else if (mode == AutopaymentMode.MONTH.getCode()) {
                int autopaymentMonthDay = this.moduleSetup.getInt("paymaster.autopayment.mode.month.day.default", 1);
                modeDataMap.set("autopayment.mode.month.day", String.valueOf(this.req.getInt("dayOfMonth", autopaymentMonthDay)));
                BigDecimal autopaymentMonthSum = this.moduleSetup.getBigDecimal("paymaster.autopayment.mode.month.sum.default", new BigDecimal(50));
                autopaymentMonthSum = this.req.getBigDecimal("monthSum", autopaymentMonthSum);
                modeDataMap.set("autopayment.mode.month.sum", String.valueOf(autopaymentMonthSum));
                autopayment.setSum(autopaymentMonthSum);
                autopayment.setMode(AutopaymentMode.MONTH);
                createToken = true;
                sum = autopaymentMonthSum;
            } else if (mode == AutopaymentMode.AUTO.getCode()) {
                BigDecimal autopaymentAutoMaxDaySum = this.moduleSetup.getBigDecimal("paymaster.autopayment.mode.auto.day.sum.default", new BigDecimal(500));
                autopaymentAutoMaxDaySum = this.req.getBigDecimal("maxDaySum", autopaymentAutoMaxDaySum);
                modeDataMap.set("autopayment.mode.auto.day.sum", String.valueOf(autopaymentAutoMaxDaySum));
                BigDecimal autopaymentAutoMaxWeekSum = this.moduleSetup.getBigDecimal("paymaster.autopayment.mode.auto.week.sum.default", new BigDecimal(1000));
                autopaymentAutoMaxWeekSum = this.req.getBigDecimal("maxWeekSum", autopaymentAutoMaxWeekSum);
                modeDataMap.set("autopayment.mode.auto.week.sum", String.valueOf(autopaymentAutoMaxWeekSum));
                BigDecimal autopaymentAutoMaxMonthSum = this.moduleSetup.getBigDecimal("paymaster.autopayment.mode.auto.month.sum.default", new BigDecimal(3000));
                autopaymentAutoMaxMonthSum = this.req.getBigDecimal("maxMonthSum", autopaymentAutoMaxMonthSum);
                modeDataMap.set("autopayment.mode.auto.month.sum", String.valueOf(autopaymentAutoMaxMonthSum));
                autopayment.setSum(autopaymentAutoMaxDaySum);
                autopayment.setMode(AutopaymentMode.AUTO);
                createToken = true;
                sum = autopaymentAutoMaxDaySum;
            }
            autopayment.setModeData(modeDataMap.toString());
            autopaymentManager.updateAutopayment(autopayment);
            autopaymentManager.close();
        }
        if (createToken) {
            try {
                Holder redirectUrl = new Holder();
                Holder mode2 = new Holder();
                MapHolder paramMap = new MapHolder();
                Holder params = new Holder((Object)paramMap);
                paramMap.getMap().put("LMI_CREATE_TOKEN", "True");
                paramMap.getMap().put("LMI_PAYMENT_METHOD", this.moduleSetup.get("paymaster.payment.method", "503"));
                this.payMasterService.beginTransaction(this.contractId, sum, redirectUrl, mode2, params);
                this.context.getRequest().setAttribute("contentType", (Object)ActionResultContentType.binary);
                this.context.getResponse().sendRedirect((String)redirectUrl.value);
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        } else {
            this.execute();
        }
    }
}

