/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.action;

import bitel.billing.server.ActionConType;
import bitel.billing.server.util.Iter;
import bitel.billing.server.util.PagedList;
import java.sql.SQLException;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.phone.server.action.ActionMailDispatch;
import ru.bitel.bgbilling.modules.phone.server.bean.ReportManager;
import ru.bitel.bgbilling.modules.phone.server.bean.Session;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@ActionConType(value=2)
public class ActionReportSessionIncoming
extends ActionMailDispatch {
    private static final HashMap<String, Integer> paramMap = new HashMap();

    @Override
    public void doAction() throws SQLException, BGException {
        if (this.mid <= 0 || this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        super.doAction();
        Thread.currentThread().setPriority(1);
        if (this.showAll) {
            this.page.setPageSize(-1);
        }
        ReportManager reportManager = new ReportManager(this.con, this.mid);
        PagedList<Session> sessionList = reportManager.getSessionIncomingList(this.cid, this.items, this.date1, this.date2, this.page);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        this.setPageAttribute(table, sessionList.getPage());
        table.setAttribute("count", String.valueOf(this.page.getRecordCount()));
        table.setAttribute("total_number", String.valueOf(this.page.getRecordCount()));
        float time = ((Session)((Object)sessionList.getTotal())).getSessionTime();
        table.setAttribute("total_time", Utils.formatSessionTime((int)((Session)((Object)sessionList.getTotal())).getSessionTime()) + " [" + Math.round(time / 60.0f) + "]");
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        if (this.html) {
            this.rootNode.setAttribute("action", "DispatchSession");
            if (this.csv) {
                this.rootNode.setAttribute("xslt", "phone_session_incoming_csv.xsl");
            } else {
                this.rootNode.setAttribute("xslt", "phone_session_incoming.xsl");
            }
            table.setAttribute("reportTitle", this.moduleSetup.get("phone.report.dispatchsessions.title", "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0441\u0435\u0441\u0441\u0438\u044f\u043c \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u0438"));
            ContractDao contractDao = new ContractDao(this.con, this.userId.intValue());
            Contract contract = (Contract)contractDao.get(this.cid);
            contractDao.close();
            table.setAttribute("contractTitle", contract.getTitle());
            table.setAttribute("comment", contract.getComment());
            table.setAttribute("date1", TimeUtils.formatDate((Calendar)this.date1));
            table.setAttribute("date2", TimeUtils.formatDate((Calendar)this.date2));
            table.setAttribute("type", String.valueOf(this.type));
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            Iterator<Session> iter = sessionList.list.iterator();
            params.put("beans", new Iter.PublicIter(iter));
            params.put("lines", new CSVLine(iter, format));
            params.put("size", new Iter.BeanNodeList(sessionList.list.size()));
            params.put("format", format);
            this.transformerParameters = params;
            if (this.request != null) {
                this.request.setAttribute("bitel.billing.server.transformer.parameters", params);
            }
        } else {
            for (Session session : sessionList.list) {
                Element sess = this.createElement(data, "row");
                sess.setAttribute("id", String.valueOf(session.getId()));
                sess.setAttribute("cdr_id", String.valueOf(session.getCdrId()));
                sess.setAttribute("hour", format.format((Object)session.getHour()));
                sess.setAttribute("item_id", String.valueOf(session.getClientItemId()));
                sess.setAttribute("item", session.getClientItem());
                sess.setAttribute("session_start", format.format((Object)session.getSessionStart()));
                sess.setAttribute("session_time", Utils.formatSessionTime((int)session.getSessionTime()));
                sess.setAttribute("from_to", session.getFromNumber164() + " / " + session.getToNumber164());
                sess.setAttribute("from164", session.getFromNumber164());
                sess.setAttribute("to164", session.getToNumber164());
                sess.setAttribute("from", session.getFromNumber());
                sess.setAttribute("to", session.getToNumber());
            }
        }
    }

    static {
        paramMap.put("cdr_id", 1);
        paramMap.put("item", 2);
        paramMap.put("session_start", 3);
        paramMap.put("session_time", 4);
        paramMap.put("from_to", 5);
    }

    public static class CSVLine {
        private Iterator<Session> sessions;
        private final Format format;
        private int[] mask;
        private final StringBuilder sb = new StringBuilder(100);

        public CSVLine(Iterator<Session> sessions, Format format) {
            this.format = format;
            this.sessions = sessions;
        }

        public void init(String pattern) {
            String[] params = Utils.patternSemicolon.split(pattern);
            this.mask = new int[params.length];
            int i = 0;
            for (String param : params) {
                this.mask[i++] = paramMap.get(param);
            }
        }

        public void setSessions(Iterator<Session> sessions) {
            this.sessions = sessions;
        }

        public String next() {
            this.sb.setLength(0);
            Session session = this.sessions.next();
            for (int i : this.mask) {
                switch (i) {
                    case 1: {
                        this.sb.append(String.valueOf(session.getCdrId()));
                        break;
                    }
                    case 2: {
                        this.sb.append(session.getClientItem());
                        break;
                    }
                    case 3: {
                        this.sb.append(this.format.format(session.getSessionStart()));
                        break;
                    }
                    case 4: {
                        this.sb.append(Utils.formatSessionTime((int)session.getSessionTime()) + " [" + Math.round(session.getSessionTime() / 60) + "]");
                        break;
                    }
                    case 5: {
                        this.sb.append(session.getFromNumber164());
                        this.sb.append(" / ");
                        this.sb.append(session.getToNumber164());
                    }
                }
                this.sb.append(';');
            }
            return this.sb.toString();
        }
    }
}

