/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.phone.common.bean.Gate;
import ru.bitel.bgbilling.modules.phone.common.bean.GateType;
import ru.bitel.bgbilling.modules.phone.common.bean.PhoneContractStatusLog;
import ru.bitel.bgbilling.modules.phone.server.bean.GateManager;
import ru.bitel.bgbilling.modules.phone.server.bean.GateTypeManager;
import ru.bitel.bgbilling.modules.phone.server.bean.GateWorker;
import ru.bitel.common.Utils;

public class PhoneContractStatusManager {
    private String table = null;
    private String table_log = null;
    protected int mid = -1;
    protected Connection con;

    public PhoneContractStatusManager(Connection con, int mid) {
        this.mid = mid;
        this.con = con;
        this.table = "phone_contract_status_" + mid;
        this.table_log = "phone_contract_status_log_" + mid;
    }

    public int getContractStatus(int cid) throws BGException {
        int result = 0;
        try {
            StringBuffer query = new StringBuffer();
            query.append(" SELECT  status from  " + this.table);
            query.append(" WHERE cid = ? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public void changeContractStatus(int cid, int status, int userId) throws BGException {
        try {
            StringBuffer query = new StringBuffer();
            query.append(" REPLACE INTO   " + this.table);
            query.append(" SET  cid= ?, status = ? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int idx = 1;
            ps.setInt(idx++, cid);
            ps.setInt(idx++, status);
            this.adjustGates(cid, status, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void adjustGates(int cid, int status, int userId) throws BGException {
        try {
            GateManager gateMan = new GateManager(this.con, this.mid);
            GateTypeManager typeMan = new GateTypeManager(this.con, this.mid);
            List<Gate> gates = gateMan.getContractGates(cid);
            for (Gate gate : gates) {
                ThreadPoolExecutor pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
                GateType type = typeMan.getTypeById(gate.getTypeId());
                GateWorker worker = new GateWorker();
                worker.init(gate, this.con, this.mid, type, cid, status);
                Future<?> f = pool.submit(worker);
                f.get();
                pool.shutdown();
                StringBuffer query = new StringBuffer();
                Object comment = "";
                if (!Utils.isEmptyString((String)worker.getExceptions())) {
                    comment = (String)comment + "\u041e\u0448\u0438\u0431\u043a\u0430!!: ";
                }
                comment = (String)comment + "\u0428\u043b\u044e\u0437: " + gate.getHost() + ":" + gate.getPort() + "[" + gate.getComment() + "]";
                query.append(" INSERT INTO   " + this.table_log);
                query.append(" SET  cid= ?, status = ?, user_id = ?, dt = now(), log = ?, comment = ? ");
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                int idx = 1;
                ps.setInt(idx++, cid);
                ps.setInt(idx++, status);
                ps.setInt(idx++, userId);
                ps.setString(idx++, worker.getResultLog().toString());
                ps.setString(idx++, (String)comment);
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (Exception e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    public List<PhoneContractStatusLog> getHistory(int cid) throws BGException {
        ArrayList<PhoneContractStatusLog> result = new ArrayList<PhoneContractStatusLog>();
        try {
            StringBuffer query = new StringBuffer();
            query.append(" SELECT  log.*, user.name  as user from  " + this.table_log + " as log ");
            query.append(" LEFT JOIN user ON log.user_id = user.id ");
            query.append(" WHERE log.cid = ? ");
            query.append(" ORDER BY dt DESC ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PhoneContractStatusLog status = new PhoneContractStatusLog();
                status.setId(rs.getInt("id"));
                status.setDate((Date)rs.getTimestamp("dt"));
                status.setUserId(rs.getInt("user_id"));
                status.setContractId(rs.getInt("cid"));
                status.setStatus(rs.getInt("status"));
                status.setLog(rs.getString("log"));
                status.setComment(rs.getString("comment"));
                status.setUserName(rs.getString("user"));
                result.add(status);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }
}

