/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.tariff;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.phone.server.tariff.PhoneServiceCost;
import ru.bitel.bgbilling.modules.phone.server.tariff.PhoneTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class ServiceSetTariffTreeNode
extends DefaultTariffTreeNode<PhoneTariffRequest, TariffContext> {
    private Pattern pattern;
    private int serviceId;

    public ServiceSetTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        String regexp = parameterMap.get("regexp", null);
        this.pattern = Utils.notBlankString((String)regexp) ? Pattern.compile(regexp) : null;
        this.serviceId = parameterMap.getInt("sid", 0);
    }

    protected int executeImpl(Long treeNodeId, PhoneTariffRequest req, TariffContext ctx) {
        String phone = req.getPhoneOriginalTo();
        if (Utils.notBlankString((String)phone) && (this.pattern == null || this.pattern.matcher(phone).find())) {
            List<PhoneServiceCost> serviceCosts = (ArrayList<PhoneServiceCost>)req.getServiceCost().get(((PhoneServiceCost)req.serviceCost).serviceId);
            if (serviceCosts != null) {
                serviceCosts.remove(req.serviceCost);
            }
            ((PhoneServiceCost)req.serviceCost).serviceId = this.serviceId;
            serviceCosts = (List)req.getServiceCost().get(this.serviceId);
            if (serviceCosts == null) {
                serviceCosts = new ArrayList<PhoneServiceCost>();
                req.getServiceCost().put(this.serviceId, serviceCosts);
            }
            serviceCosts.add((PhoneServiceCost)req.serviceCost);
            return 1;
        }
        return 0;
    }
}

