/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.client;

import bitel.billing.module.common.BSHEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.phone.common.bean.GateType;
import ru.bitel.bgbilling.modules.phone.common.service.GatesService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;

public class GateTypePanel
extends BGUPanel {
    private BGTableModel<GateType> model = null;
    private BGUTable table = null;
    private JPanel editor = new JPanel(new GridBagLayout());
    private JTextField title = new JTextField();
    private JTextArea comment = new JTextArea();
    private BGConfigEditorPane config = new BGConfigEditorPane();
    private BSHEditor script = new BSHEditor();
    private JSplitPane splitPane = new JSplitPane();
    private Integer id = null;

    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        this.model = new BGTableModel<GateType>("gates"){

            protected void initColumns() {
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 150, -1, "host", true);
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0440\u0438\u0439", -1, 150, 200, "comment", true);
            }

            public Object getValue(GateType val, int column) throws BGException {
                switch (column) {
                    case 0: {
                        return val.getTitle();
                    }
                    case 1: {
                        return val.getComment();
                    }
                }
                return super.getValue((Object)val, column);
            }
        };
        this.table = new BGUTable(this.model);
        this.table.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane((Component)this.table);
        this.initEditor();
        this.splitPane = new JSplitPane(0);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setTopComponent(jScrollPane);
        this.splitPane.setBottomComponent(this.editor);
        this.add(this.splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initEditor() {
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.title, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.comment, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel configPanel = new JPanel(new GridBagLayout());
        configPanel.add((Component)this.config, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel scriptPanel = new JPanel(new GridBagLayout());
        scriptPanel.add((Component)this.script, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JTabbedPane pane = new JTabbedPane();
        pane.add((Component)configPanel, "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
        pane.add((Component)scriptPanel, "\u0421\u043a\u0440\u0438\u043f\u0442");
        this.editor.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.editor.add((Component)leftPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editor.add((Component)pane, new GridBagConstraints(1, 0, 1, 1, 0.9, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        ActionListener buttonListener = e -> this.performAction("button.clicked", e.getActionCommand());
        JButton save = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        save.setActionCommand("save");
        save.addActionListener(buttonListener);
        JButton saveAndClose = new JButton(" \u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u044c ");
        saveAndClose.setActionCommand("saveAndClose");
        saveAndClose.addActionListener(buttonListener);
        JButton close = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u043d\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u044f");
        close.setActionCommand("close");
        close.addActionListener(buttonListener);
        bottomPanel.add((Component)new JPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        bottomPanel.add((Component)save, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        bottomPanel.add((Component)saveAndClose, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        bottomPanel.add((Component)close, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.editor.add((Component)bottomPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.editor.setVisible(false);
        this.splitPane.setBottomComponent(null);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GateTypePanel.this.editItem();
                }
            }
        });
    }

    private void setData() throws BGException {
        List result = ((GatesService)((ClientContext)this.getContext()).getPort(GatesService.class)).listTypes();
        this.model.setData(result);
    }

    private void stopEdit(boolean save) throws BGException {
        if (save) {
            if (this.save()) {
                this.editor.setVisible(false);
                this.splitPane.setBottomComponent(null);
                this.setData();
            }
        } else {
            this.editor.setVisible(false);
            this.splitPane.setBottomComponent(null);
        }
    }

    private boolean save() throws BGException {
        boolean result;
        block3: {
            result = true;
            if (Utils.isEmptyString((String)this.title.getText())) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u043e\u043b\u0435 \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435!");
                return false;
            }
            GateType type = new GateType();
            type.setId(this.id != null ? this.id : 0);
            type.setComment(this.comment.getText());
            type.setTitle(this.title.getText());
            type.setScript(this.script.getText());
            type.setConfig(this.config.getText());
            try {
                this.id = ((GatesService)((ClientContext)this.getContext()).getPort(GatesService.class)).updateType(type, true);
            }
            catch (BGException ex) {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041e\u0448\u0438\u0431\u043a\u0430: \"" + ex.getMessage() + "\";\u0412\u0441\u0435 \u0440\u0430\u0432\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c ?", "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 \u0441\u043a\u0440\u0438\u043f\u0442\u0430", 0) != 0) break block3;
                this.id = ((GatesService)((ClientContext)this.getContext()).getPort(GatesService.class)).updateType(type, false);
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.getMessage());
            }
        }
        return result;
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("button.clicked", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if ("save".equals(e.getActionCommand())) {
                    GateTypePanel.this.save();
                } else if ("saveAndClose".equals(e.getActionCommand())) {
                    GateTypePanel.this.stopEdit(true);
                } else if ("close".equals(e.getActionCommand())) {
                    GateTypePanel.this.stopEdit(false);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                GateTypePanel.this.setData();
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                GateTypePanel.this.id = null;
                GateTypePanel.this.editor.setVisible(true);
                GateTypePanel.this.splitPane.setBottomComponent(GateTypePanel.this.editor);
                GateTypePanel.this.title.setText(null);
                GateTypePanel.this.comment.setText(null);
                GateTypePanel.this.config.setText(null);
                GateTypePanel.this.script.setText(null);
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                GateType type = (GateType)GateTypePanel.this.model.getSelectedRow();
                if (type != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0448\u043b\u044e\u0437\u0430:" + type.getTitle() + " ?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    ((GatesService)((ClientContext)GateTypePanel.this.getContext()).getPort(GatesService.class)).deleteType(type.getId());
                    GateTypePanel.this.setData();
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                GateTypePanel.this.editItem();
            }
        };
    }

    private void editItem() {
        GateType type = (GateType)this.model.getSelectedRow();
        if (type != null) {
            this.id = type.getId();
            this.editor.setVisible(true);
            this.splitPane.setBottomComponent(this.editor);
            this.title.setText(type.getTitle());
            this.comment.setText(type.getComment());
            this.config.setText(type.getConfig());
            this.script.setText(type.getScript());
        }
    }
}

