/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.psb.server.bean;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collector;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.psb.common.bean.Transaction;
import ru.bitel.bgbilling.modules.psb.server.bean.Constants;
import ru.bitel.bgbilling.modules.psb.server.event.PSBAutopaymentSumEvent;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    private static final Logger logger = LogManager.getLogger();

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "psb_transaction");
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("status", "status");
        this.fields.put("createDatetime", "create_date");
        this.fields.put("transactionDatetime", "transaction_date");
        this.fields.put("sum", "sum");
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException, BGException {
        Transaction transaction = new Transaction();
        transaction.setId(rs.getInt("id"));
        transaction.setContractId(rs.getInt("contract_id"));
        transaction.setContractTitle(rs.getString("contract_title"));
        transaction.setPaymentId(rs.getInt("payment_id"));
        transaction.setCreateDate((Date)rs.getTimestamp("create_date"));
        transaction.setTransactionDate((Date)rs.getTimestamp("transaction_date"));
        transaction.setAuthorizationCode(rs.getString("authorization_code"));
        transaction.setCard(rs.getString("card"));
        transaction.setStatus(rs.getString("status"));
        transaction.setParameters(rs.getString("params"));
        transaction.setSum(rs.getBigDecimal("sum"));
        transaction.setAutopayment(rs.getBoolean("autopayment"));
        return transaction;
    }

    protected void updateImpl(Transaction transaction) throws BGException {
        if (transaction != null) {
            boolean update = transaction.getId() > 0;
            String fields = " SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, authorization_code=?, card=?, status=?, params=?, sum=?, autopayment=?";
            StringBuilder query = new StringBuilder(update ? "UPDATE " : "INSERT INTO ").append(this.tableName).append(" SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, authorization_code=?, card=?, status=?, params=?, sum=?, autopayment=?").append(update ? " WHERE id=?" : "");
            try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
                int index = 1;
                ps.setInt(index++, transaction.getContractId());
                ps.setInt(index++, transaction.getPaymentId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
                ps.setString(index++, transaction.getAuthorizationCode());
                ps.setString(index++, transaction.getPan());
                ps.setString(index++, transaction.getStatus());
                ps.setString(index++, transaction.getParameters());
                ps.setBigDecimal(index++, transaction.getSum());
                ps.setBoolean(index++, transaction.isAutopayment());
                if (update) {
                    ps.setInt(index++, transaction.getId());
                }
                ps.executeUpdate();
                if (!update) {
                    transaction.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    protected Transaction getById(int id) throws BGException, SQLException {
        Transaction result = null;
        PreparedStatement ps = this.getByIdPS;
        if (ps == null) {
            String query = "SELECT t.*, contract.title AS contract_title FROM " + this.tableName + " AS t LEFT JOIN contract ON contract.id=contract_id WHERE t.id=?";
            ps = this.getByIdPS = this.con.prepareStatement(query);
        }
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result = this.getFromRS(rs);
        }
        rs.close();
        return result;
    }

    public static String buildSignData(Map<String, Object> dataMap, String[] checkParams) {
        StringBuilder str = new StringBuilder();
        for (String paramName : checkParams) {
            String paramValue = String.valueOf(dataMap.get(paramName));
            if (paramValue == null || paramValue.length() == 0) {
                str.append("-");
                continue;
            }
            str.append(paramValue.length() + paramValue);
        }
        return str.toString();
    }

    public static String doSign(String str, ParameterMap moduleSetup) throws BGException {
        String signAlg;
        return TransactionManager.doSign(str, moduleSetup.get("psb.secret"), switch (signAlg = moduleSetup.get("psb.sign.alg", "sha1").toLowerCase()) {
            case "sha1" -> "HmacSHA1";
            case "sha256" -> "HmacSHA256";
            default -> throw new BGException("unknown psb.sign.alg=" + signAlg);
        });
    }

    private static String doSign(String str, String secret, String algorithm) throws BGException {
        if (secret == null) {
            throw new BGException("parameter psb.secret not set in module config");
        }
        byte[] keyBytes = new byte[secret.length() / 2];
        for (int j = 0; j < secret.length(); j += 2) {
            keyBytes[j / 2] = (byte)Integer.parseInt(secret.substring(j, j + 2), 16);
        }
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(keyBytes, algorithm));
            String result = Utils.bytesToString((byte[])mac.doFinal(str.getBytes()), (boolean)true, null);
            if (logger.isDebugEnabled()) {
                logger.debug("cSign = " + result);
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new BGException("error algorithm " + algorithm + ": " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new BGException("error key (alg " + algorithm + "): " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static String getNonce() {
        byte[] nonceBytes = new byte[8];
        for (int i = 0; i < nonceBytes.length; ++i) {
            nonceBytes[i] = (byte)(256.0 * Math.random());
        }
        return Utils.bytesToHexString((byte[])nonceBytes);
    }

    public Transaction newTransaction(int contractId, BigDecimal sum, boolean autopaymentTransaction, boolean reqChain) throws BGException {
        if (autopaymentTransaction || reqChain) {
            PSBAutopaymentSumEvent event = new PSBAutopaymentSumEvent(this.moduleId, contractId, sum);
            BigDecimal newSum = ((PSBAutopaymentSumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
            if (newSum != null) {
                sum = newSum;
            }
        }
        Transaction transaction = new Transaction();
        transaction.setSum(sum);
        transaction.setContractId(contractId);
        transaction.setCreateDate(new Date());
        transaction.setAutopayment(autopaymentTransaction);
        this.update(transaction);
        return transaction;
    }

    public String doRequest(Transaction transaction, String contractTitle, BigDecimal sum, String email, String intRef, String recurRef) {
        StringBuilder responce = new StringBuilder();
        try {
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("AMOUNT", TransactionManager.getFormatSum(sum));
            dataMap.put("CURRENCY", "RUB");
            dataMap.put("ORDER", new DecimalFormat("000000").format(transaction.getId()));
            dataMap.put("DESC", moduleSetup.get("psb.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116 {CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle));
            dataMap.put("TERMINAL", moduleSetup.get("psb.terminal"));
            dataMap.put("TRTYPE", "171");
            dataMap.put("MERCH_NAME", moduleSetup.get("psb.merchant.name"));
            dataMap.put("MERCHANT", moduleSetup.get("psb.merchant"));
            dataMap.put("EMAIL", email);
            dataMap.put("TIMESTAMP", TransactionManager.getFormatTime(transaction.getCreateDate()));
            dataMap.put("NONCE", TransactionManager.getNonce());
            dataMap.put("BACKREF", moduleSetup.get("psb.back.url"));
            dataMap.put("INT_REF", intRef);
            dataMap.put("RECUR_REF", recurRef);
            StringBuilder spec = dataMap.entrySet().stream().collect(Collector.of(StringBuilder::new, (accumulator, element) -> accumulator.append((String)element.getKey()).append("=").append(this.urlEncode(element.getValue())).append("&"), StringBuilder::append, new Collector.Characteristics[0]));
            String str = TransactionManager.buildSignData(dataMap, Constants.PARAMS);
            spec.append("P_SIGN").append("=").append(TransactionManager.doSign(str, (ParameterMap)moduleSetup));
            String gate = moduleSetup.get("psb.gate.url");
            URL gateUrl = new URL(gate);
            HttpURLConnection connection = (HttpURLConnection)gateUrl.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
            bw.write(spec.toString().toCharArray());
            bw.close();
            connection.connect();
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            if (br.ready()) {
                String line = null;
                while ((line = br.readLine()) != null) {
                    responce.append(line);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\t\u041e\u0442\u0432\u0435\u0442: " + responce.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return responce.toString();
    }

    private String urlEncode(Object value) {
        String encodeValue = "";
        try {
            encodeValue = URLEncoder.encode(value.toString(), "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return encodeValue;
    }

    public static String getFormatSum(BigDecimal sum) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        return new DecimalFormat("###########0.00", decimalFormatSymbols).format(sum);
    }

    public static String getFormatTime(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }
}

