/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server;

import au.com.bytecode.opencsv.CSVWriter;
import bsh.Interpreter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.report.BGCSVReport;
import ru.bitel.bgbilling.modules.reports.server.report.BGReport;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

@Deprecated
public class BGCSVReport
extends BGReport {
    protected static final Logger log = LogManager.getLogger();
    private Document repxmldoc = null;
    protected CSVWriter csvWriter = null;

    public BGCSVReport() {
        this.contentType = "cvs";
    }

    public BGCSVReport(Connection con) {
        this.contentType = "cvs";
        this.con = con;
    }

    @Override
    public void fillReportToStream(OutputStream out) {
        try {
            if (this.cfg != null) {
                this.repxmldoc = XMLUtils.parseDocument((InputSource)new InputSource(new FileInputStream(this.cfg)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<Field> fields = this.getFields();
        Object dyn_class = null;
        if (this.repxmldoc != null && (dyn_class = XMLUtils.selectText((Node)this.repxmldoc, (String)"/report/@dyn_class", null)) == null && this.cfg_clazz != null) {
            dyn_class = this.cfg_clazz.getResourcePackageName() + "." + this.id;
        }
        try {
            if (dyn_class == null) {
                this.writeCSV(fields, this.getResult(fields), out);
            } else {
                Class clazz = DynamicClassManager.getInstance().loadClass((String)dyn_class);
                List<Class<?>> list = Arrays.asList(clazz.getInterfaces());
                while (list.isEmpty() && (clazz = clazz.getSuperclass()) != null) {
                    list = Arrays.asList(clazz.getInterfaces());
                }
                if (list.contains(CSVFillerDataFields.class)) {
                    this.writeCSV(fields, this.getResultDyncodeOld((String)dyn_class, fields), out);
                } else if (list.contains(BGCSVReport.CSVFillerData.class)) {
                    this.writeCSV(fields, this.getResultDyncode((String)dyn_class, fields), out);
                } else if (list.contains(BGCSVReport.CSVFillerDataFields.class)) {
                    this.writeCSV(fields, this.getResultDyncode((String)dyn_class, fields), out);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    protected void fillCSVReportToStream(OutputStream out) throws Exception {
        try {
            if (this.cfg != null) {
                this.repxmldoc = XMLUtils.parseDocument((InputSource)new InputSource(new FileInputStream(this.cfg)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.csvWriter == null) {
            OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
            this.csvWriter = new CSVWriter((Writer)writer, ';', '\"', '\\');
            this.writeCsvLines(this.writeCsvHeader(this.getFields()));
            this.csvWriter.flush();
            this.csvWriter.close();
            this.csvWriter = null;
        }
    }

    protected int writeCsvHeader(List<Field> fields) {
        if (this.csvWriter != null) {
            String[] fieldLine = new String[fields.size()];
            for (int i = 0; i < fields.size(); ++i) {
                Field field = fields.get(i);
                fieldLine[i] = field.title;
            }
            this.csvWriter.writeNext(fieldLine, false);
        }
        return fields.size();
    }

    protected void writeCsvLines(int fieldCount) throws Exception {
    }

    protected void writeCSV(List<Field> fields, ReportResult result, OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        this.csvWriter = new CSVWriter((Writer)writer, ';', '\"', '\\');
        this.writeCsvHeader(fields);
        int count = result.getData().size();
        String[] fieldLine = new String[fields.size()];
        for (int j = 0; j < count; ++j) {
            for (int i = 0; i < fields.size(); ++i) {
                Field field = fields.get(i);
                fieldLine[i] = result.getData().get(j).get(field.id);
            }
            this.csvWriter.writeNext(fieldLine);
        }
        this.csvWriter.flush();
        this.csvWriter.close();
    }

    protected void writeCSV(List<Field> fields, BGCSVReport.ReportResult result, OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        this.csvWriter = new CSVWriter((Writer)writer, ';', '\"', '\\');
        this.writeCsvHeader(fields);
        int count = result.getData().size();
        String[] fieldLine = new String[fields.size()];
        for (int j = 0; j < count; ++j) {
            for (int i = 0; i < fields.size(); ++i) {
                Field field = fields.get(i);
                fieldLine[i] = result.getData().get(j).get(field.id);
            }
            this.csvWriter.writeNext(fieldLine);
        }
        this.csvWriter.flush();
        this.csvWriter.close();
    }

    private List<Field> getFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (this.repxmldoc != null) {
            for (Element item : XMLUtils.selectElements((Node)this.repxmldoc, (String)"//fields/item")) {
                Field field = new Field();
                field.title = XMLUtils.getAttribute((Element)item, (String)"title", (String)"");
                field.id = XMLUtils.getAttribute((Element)item, (String)"id", (String)"");
                fields.add(field);
            }
        }
        return fields;
    }

    protected ReportResult getResult(List<Field> fields) {
        ReportResult result = new ReportResult();
        File file = new File("reports/" + this.id + ".java");
        long time = System.currentTimeMillis();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            String script = new String(Utils.readByBlock((InputStream)new FileInputStream(file)), "UTF-8");
            Interpreter it = new Interpreter();
            it.getNameSpace().importCommands("/ru/bitel/bgbilling/kernel/script/server/bsh/commands");
            log.info("Running script for csv report ");
            it.set("log", (Object)log);
            it.setOut(new PrintStream(out));
            it.setErr(new PrintStream(err));
            it.eval(script);
            if (fields.isEmpty()) {
                LinkedHashMap<String, String> fieldsmap = new LinkedHashMap<String, String>();
                CSVFillerDataFields filler = (CSVFillerDataFields)it.getInterface(CSVFillerDataFields.class);
                filler.fillReport(this.con, new bitel.billing.server.admin.reports.BGReportFilter(this._params, this.moduleSetup), result, fieldsmap);
                BGCSVReport.addFields(fields, fieldsmap);
            } else {
                CSVFillerData filler = (CSVFillerData)it.getInterface(CSVFillerData.class);
                filler.fillReport(this.con, new bitel.billing.server.admin.reports.BGReportFilter(this._params, this.moduleSetup), result);
            }
        }
        catch (Exception ex) {
            log.error("Eval error: " + ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        long processTime = System.currentTimeMillis() - time;
        log.info("Process time => " + processTime);
        if (out.size() > 0) {
            log.info(out.toString());
        }
        if (err.size() > 0) {
            log.error(err.toString());
        }
        return result;
    }

    private ReportResult getResultDyncodeOld(String dyn_class, List<Field> fields) {
        ReportResult result = new ReportResult();
        long time = System.currentTimeMillis();
        try {
            log.info("Running dyncode for csv report ");
            if (fields.isEmpty()) {
                LinkedHashMap<String, String> fieldsmap = new LinkedHashMap<String, String>();
                CSVFillerDataFields filler = (CSVFillerDataFields)DynamicClassManager.getInstance().newInstance(CSVFillerDataFields.class, dyn_class);
                filler.fillReport(this.con, new bitel.billing.server.admin.reports.BGReportFilter(this._params, this.moduleSetup), result, fieldsmap);
                BGCSVReport.addFields(fields, fieldsmap);
            } else {
                CSVFillerData filler = (CSVFillerData)DynamicClassManager.getInstance().newInstance(CSVFillerData.class, dyn_class);
                filler.fillReport(this.con, new bitel.billing.server.admin.reports.BGReportFilter(this._params, this.moduleSetup), result);
            }
        }
        catch (Exception ex) {
            log.error("Eval error: " + ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        long processTime = System.currentTimeMillis() - time;
        log.info("Process time => " + processTime);
        return result;
    }

    private BGCSVReport.ReportResult getResultDyncode(String dyn_class, List<Field> fields) {
        ru.bitel.bgbilling.modules.reports.server.report.BGCSVReport report = new ru.bitel.bgbilling.modules.reports.server.report.BGCSVReport();
        BGCSVReport.ReportResult result = new BGCSVReport.ReportResult(report);
        long time = System.currentTimeMillis();
        try {
            log.info("Running dyncode for csv report ");
            if (fields.isEmpty()) {
                LinkedHashMap<String, String> fieldsmap = new LinkedHashMap<String, String>();
                BGCSVReport.CSVFillerDataFields filler = (BGCSVReport.CSVFillerDataFields)DynamicClassManager.getInstance().newInstance(BGCSVReport.CSVFillerDataFields.class, dyn_class);
                filler.fillReport(this.con, new BGReportFilter(this._params, this.moduleSetup, this.userId), result, fieldsmap);
                BGCSVReport.addFields(fields, fieldsmap);
            } else {
                BGCSVReport.CSVFillerData filler = (BGCSVReport.CSVFillerData)DynamicClassManager.getInstance().newInstance(BGCSVReport.CSVFillerData.class, dyn_class);
                filler.fillReport(this.con, new BGReportFilter(this._params, this.moduleSetup, this.userId), result);
            }
        }
        catch (Exception ex) {
            log.error("Eval error: " + ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        long processTime = System.currentTimeMillis() - time;
        log.info("Process time => " + processTime);
        return result;
    }

    protected static void addFields(List<Field> fields, Map<String, String> fieldsmap) {
        fields.addAll(fieldsmap.entrySet().stream().map(entry -> {
            Field field = new Field();
            field.id = (String)entry.getKey();
            field.title = (String)entry.getValue();
            return field;
        }).collect(Collectors.toList()));
    }

    public class ReportResult {
        private List<Map<String, String>> data = new ArrayList<Map<String, String>>();
        int count = 0;

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public List<Map<String, String>> getData() {
            return this.data;
        }

        public void setData(List<Map<String, String>> data) {
            this.data = data;
        }
    }

    public static interface CSVFillerDataFields {
        public void fillReport(Connection var1, bitel.billing.server.admin.reports.BGReportFilter var2, ReportResult var3, Map<String, String> var4) throws Exception;
    }

    public static class Field {
        public String id;
        public String title;
    }

    public static interface CSVFillerData {
        public void fillReport(Connection var1, bitel.billing.server.admin.reports.BGReportFilter var2, ReportResult var3) throws Exception;
    }
}

