/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.inbuild;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_Account
extends BGJasperReport {
    public Report_Account() {
        this.id = "kernel_contract_account";
    }

    @Override
    public void fillReportToStream(OutputStream out) {
        try {
            String gr = this.getStringParam("gr");
            Calendar date = TimeUtils.parseCalendar((String)this.getStringParam("date"), (String)"dd.MM.yyyy");
            StringBuffer query = new StringBuffer("SELECT t3.title, SUM(t1.summa) ");
            query.append(" FROM contract_account AS t1, ");
            query.append(" contract AS t2, service AS t3 ");
            query.append(" WHERE t1.cid=t2.id AND t1.sid=t3.id ");
            long grMask = Utils.enumToMask((String)gr);
            if (grMask > 0L) {
                query.append("AND t2.gr&");
                query.append(grMask);
                query.append(">0");
            }
            query.append(" AND t1.yy=");
            query.append(date.get(1));
            query.append(" AND t1.mm=");
            query.append(date.get(2) + 1);
            query.append(" GROUP BY t1.sid ");
            query.append(" ORDER BY t3.mid, t3.title");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("addInfo", " \u0433\u043e\u0434: " + date.get(1) + " \u043c\u0435\u0441\u044f\u0446: " + TimeUtils.monthNames[date.get(2)]);
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            BigDecimal sum = BigDecimal.ZERO;
            sum = sum.setScale(2, 4);
            BGDataSource bds = new BGDataSource();
            while (rs.next()) {
                BigDecimal val = rs.getBigDecimal(2).setScale(2, 4);
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put("col1", rs.getString(1));
                row.put("col2", val.toPlainString());
                bds.addRow(row);
                sum = sum.add(val);
            }
            rs.close();
            ps.close();
            params.put("sum", sum.toPlainString());
            this.fillReportToStream(this.id, out, params, (JRDataSource)bds);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

